package org.kamaeleo.canvas

import java.awt.event.KeyEvent
import java.awt.event.KeyListener
import java.awt.event.MouseEvent
import java.awt.event.MouseListener
import java.awt.event.MouseMotionListener
import java.util.*
import javax.swing.JComponent


class SwingCanvasHandler(private val canvas: JComponent) {
    private var popupTrigger = false
    private var keyListenerRegistered = false
    private var contextMenuListeners: MutableList<ContextMenuListener>? = null
    fun addMouseListener(l: org.kamaeleo.canvas.MouseListener) {
        canvas.addMouseListener(object : MouseListener {
            override fun mouseClicked(e: MouseEvent) {
                if (popupTrigger && e.clickCount == 1) {
                    for (contextMenuListener in contextMenuListeners!!) {
                        val event: org.kamaeleo.canvas.ContextMenuEvent = object : org.kamaeleo.canvas.ContextMenuEvent {
                            override val x: Int
                                get() = e.x
                            override val y: Int
                                get() = e.y
                        }
                        contextMenuListener.contextMenu(event)
                    }
                } else {
                    l.mouseClicked(SwingMouseEvent(e))
                }
            }

            override fun mousePressed(e: MouseEvent) {
                popupTrigger = e.isPopupTrigger
                l.mousePressed(SwingMouseEvent(e))
            }

            override fun mouseReleased(e: MouseEvent) {
                if (!popupTrigger) {
                    popupTrigger = e.isPopupTrigger
                }
                l.mouseReleased(SwingMouseEvent(e))
            }

            override fun mouseEntered(e: MouseEvent) {
                if (keyListenerRegistered) {
                    canvas.requestFocusInWindow()
                }
                l.mouseEntered(SwingMouseEvent(e))
            }

            override fun mouseExited(e: MouseEvent) {
                l.mouseExited(SwingMouseEvent(e))
            }
        })
    }

    fun addMouseMotionListener(l: org.kamaeleo.canvas.MouseMotionListener) {
        canvas.addMouseMotionListener(object : MouseMotionListener {
            override fun mouseDragged(e: MouseEvent) {
                l.mouseDragged(SwingMouseEvent(e))
            }

            override fun mouseMoved(e: MouseEvent) {
                l.mouseMoved(SwingMouseEvent(e))
            }
        })
    }

    fun addMouseWheelListener(l: org.kamaeleo.canvas.MouseWheelListener) {
        canvas.addMouseWheelListener { e -> l.mouseWheelMoved(SwingMouseWheelEvent(e)) }
    }

    fun addKeyListener(l: org.kamaeleo.canvas.KeyListener) {
        keyListenerRegistered = true
        canvas.addKeyListener(object : KeyListener {
            override fun keyTyped(e: KeyEvent) {
                l.keyTyped(SwingKeyEvent(e))
            }

            override fun keyPressed(e: KeyEvent) {
                l.keyPressed(SwingKeyEvent(e))
            }

            override fun keyReleased(e: KeyEvent) {
                l.keyReleased(SwingKeyEvent(e))
            }
        })
    }

    fun addContextMenuListener(l: ContextMenuListener) {
        if (contextMenuListeners == null) {
            contextMenuListeners = ArrayList()
        }
        contextMenuListeners!!.add(l)
    }
}
