package org.kamaeleo.canvas

import com.macrofocus.common.crossplatform.CPHelper
import java.awt.Toolkit
import java.awt.event.KeyEvent
import java.awt.event.MouseEvent
import java.awt.event.MouseWheelEvent
import javax.swing.SwingUtilities

class SwingMouseEvent(private val event: MouseEvent) : org.kamaeleo.canvas.MouseEvent {
    override val x: Int
        get() = event.x
    override val y: Int
        get() = event.y
    override val isMenuShortcutKeyDown: Boolean
        get() = event.modifiers and Toolkit.getDefaultToolkit().menuShortcutKeyMask != 0
    override val isAltKeyDown: Boolean
        get() = event.isAltDown
    override val isShiftKeyDown: Boolean
        get() = event.isShiftDown

    //            return (event.getModifiersEx() & KeyEvent.META_DOWN_MASK) != 0;
    override val isMultipleSelectionKey: Boolean
        get() = if (CPHelper.instance.isMac) {
            //            return (event.getModifiersEx() & KeyEvent.META_DOWN_MASK) != 0;
            event.isMetaDown
        } else {
            event.isControlDown
        }

    override val isPopupTrigger: Boolean
        get() = event.isPopupTrigger
    override val isLeftMouseButton: Boolean
        get() = SwingUtilities.isLeftMouseButton(event)
    override val isMiddleMouseButton: Boolean
        get() = SwingUtilities.isMiddleMouseButton(event)

    override fun stopPropagation() {
        event.consume()
    }

    override val clickCount: Int
        get() = event.clickCount

}

class SwingMouseWheelEvent(private val event: MouseWheelEvent) : org.kamaeleo.canvas.MouseWheelEvent {
    override val x: Int
        get() = event.x
    override val y: Int
        get() = event.y
    override val wheelRotation: Int
        get() = event.wheelRotation

}

class SwingKeyEvent(private val event: KeyEvent) : org.kamaeleo.canvas.KeyEvent {
    override val keyCode: Int
        get() = event.keyCode

}
