package org.kamaeleo.graphics

import org.kamaeleo.font.CPFontMetrics
import org.kamaeleo.geom.Rectangle2D
import java.awt.FontMetrics
import java.awt.Graphics2D


/**
 * Created by luc on 09/07/15.
 */
class SwingFontMetrics(private val g2: Graphics2D) : CPFontMetrics {
    private val fontMetrics: FontMetrics

    override fun getHeight(): Float {
        return fontMetrics.height.toFloat()
    }

    override fun getAscent(): Int {
        return fontMetrics.ascent
    }

    fun getStringBounds(text: String?): Rectangle2D {
        val stringBounds = fontMetrics.getStringBounds(text, g2)
        return Rectangle2D.Double(stringBounds.x, stringBounds.y, stringBounds.width, stringBounds.height)
    }

    init {
        fontMetrics = g2.fontMetrics
    }
}