/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.colormap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.SortedSet;
import com.macrofocus.common.collection.UniversalComparator;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyDelegates;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.color.CPColorFactory;
import org.kamaeleo.color.CPColorKt;
import org.kamaeleo.colormap.AbstractColorMap;
import org.kamaeleo.colormap.ColorMap;
import org.kamaeleo.colormap.ColorMapEvent;
import org.kamaeleo.colormap.MutableColorMap;
import org.kamaeleo.colormap.SetStoreMutableProperty;
import org.kamaeleo.palette.CustomPalette;
import org.kamaeleo.palette.InterpolatedPalette;
import org.kamaeleo.palette.MutablePalette;
import org.kamaeleo.palette.PaletteEvent;
import org.kamaeleo.palette.PaletteListener;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0013\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u009c\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B%\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u0082\u0001\u001a\u00030\u0083\u00012\f\u0010\u0084\u0001\u001a\u0007\u0012\u0002\b\u00030\u0085\u0001H\u0002\u00a2\u0006\u0003\u0010\u0086\u0001J)\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0017\u0010\b\u001a\r\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00190\u0085\u0001\"\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0003\u0010\u0089\u0001J\u001b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u000f\u0010\b\u001a\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u008a\u0001H\u0016J\u001e\u0010\u0087\u0001\u001a\u00030\u0088\u00012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\u008b\u0001\u001a\u00030\u0088\u0001H\u0016J\u0016\u0010\u008c\u0001\u001a\u0004\u0018\u0001072\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010\u0019H\u0016J\n\u0010\u008e\u0001\u001a\u00030\u0088\u0001H\u0016J\u0015\u0010\u008f\u0001\u001a\u00030\u0088\u00012\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0091\u0001\u001a\u00030\u0088\u00012\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010\u00192\t\u0010\u0092\u0001\u001a\u0004\u0018\u000107H\u0016J\u0015\u0010\u0093\u0001\u001a\u00030\u0088\u00012\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010\u0011H\u0016J\u0015\u0010\u0095\u0001\u001a\u00030\u0088\u00012\t\u0010\u0096\u0001\u001a\u0004\u0018\u000107H\u0016J!\u0010\u0097\u0001\u001a\u00030\u0088\u00012\n\u0010\u0098\u0001\u001a\u0005\u0018\u00010\u0083\u00012\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010\u0019H\u0016J\u0015\u0010\u0099\u0001\u001a\u00030\u0088\u00012\t\u0010\u009a\u0001\u001a\u0004\u0018\u000107H\u0016J\n\u0010\u009b\u0001\u001a\u00030\u0083\u0001H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR+\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R \u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R+\u0010+\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b.\u0010$\u001a\u0004\b,\u0010 \"\u0004\b-\u0010\"R \u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010(\"\u0004\b1\u0010*R \u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010(\"\u0004\b4\u0010*R.\u00105\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020706j\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u000207`8X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\u00020<8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010E\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\bI\u0010$\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR \u0010J\u001a\b\u0012\u0004\u0012\u00020\u000b0&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010(\"\u0004\bK\u0010*R\u0014\u0010L\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010FR\u0014\u0010M\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010FR\u0014\u0010N\u001a\u00020<8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010>R/\u0010P\u001a\u0004\u0018\u0001072\b\u0010\u001c\u001a\u0004\u0018\u0001078V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\bU\u0010$\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u001c\u0010V\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001070&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010(R\u001c\u0010X\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001070&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010(R \u0010Z\u001a\b\u0012\u0004\u0012\u00020\u000b0&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010(\"\u0004\b\\\u0010*R\"\u0010]\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001070&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010(\"\u0004\b_\u0010*R\u0014\u0010`\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010RR/\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u00068V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\bf\u0010$\u001a\u0004\bb\u0010c\"\u0004\bd\u0010eR\u000e\u0010g\u001a\u00020hX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010i\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010(\"\u0004\bk\u0010*R\u001a\u0010l\u001a\b\u0012\u0004\u0012\u00020n0mX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010pR+\u0010q\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\bt\u0010$\u001a\u0004\br\u0010 \"\u0004\bs\u0010\"R \u0010u\u001a\b\u0012\u0004\u0012\u00020\u001d0&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010(\"\u0004\bw\u0010*R\u001c\u0010x\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001070&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\by\u0010(R \u0010z\u001a\b\u0012\u0004\u0012\u00020\u000b0&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b{\u0010(\"\u0004\b|\u0010*R\"\u0010}\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001070&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b~\u0010(\"\u0004\b\u007f\u0010*R\u0016\u0010\u0080\u0001\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0081\u0001\u0010R\u00a8\u0006\u009d\u0001"}, d2={"Lorg/kamaeleo/colormap/SimpleColorMap;", "Lorg/kamaeleo/colormap/AbstractColorMap;", "Lorg/kamaeleo/colormap/MutableColorMap;", "interval", "Lcom/macrofocus/common/interval/MutableInterval;", "palette", "Lorg/kamaeleo/palette/MutablePalette;", "(Lcom/macrofocus/common/interval/MutableInterval;Lorg/kamaeleo/palette/MutablePalette;)V", "values", "", "cyclic", "", "(Ljava/util/Set;ZLorg/kamaeleo/palette/MutablePalette;)V", "()V", "_assignments", "Lorg/kamaeleo/colormap/ColorMap$Assignments;", "_matching", "Lorg/kamaeleo/colormap/ColorMap$Matching;", "alpha", "", "getAlpha", "()F", "setAlpha", "(F)V", "assignedValues", "", "getAssignedValues", "()Ljava/util/Set;", "<set-?>", "", "brightness", "getBrightness", "()I", "setBrightness", "(I)V", "brightness$delegate", "Lkotlin/properties/ReadWriteProperty;", "brightnessProperty", "Lcom/macrofocus/common/properties/MutableProperty;", "getBrightnessProperty", "()Lcom/macrofocus/common/properties/MutableProperty;", "setBrightnessProperty", "(Lcom/macrofocus/common/properties/MutableProperty;)V", "colorCount", "getColorCount", "setColorCount", "colorCount$delegate", "colorCountProperty", "getColorCountProperty", "setColorCountProperty", "colorCountSetProperty", "getColorCountSetProperty", "setColorCountSetProperty", "dictionary", "Ljava/util/HashMap;", "Lorg/kamaeleo/color/CPColor;", "Lcom/macrofocus/common/collection/TreeMap;", "factory", "Lorg/kamaeleo/color/CPColorFactory;", "highestFraction", "", "getHighestFraction", "()D", "getInterval", "()Lcom/macrofocus/common/interval/MutableInterval;", "setInterval", "(Lcom/macrofocus/common/interval/MutableInterval;)V", "intervalListener", "Lcom/macrofocus/common/interval/IntervalListener;", "isInverted", "()Z", "setInverted", "(Z)V", "isInverted$delegate", "isInvertedProperty", "setInvertedProperty", "isOverflowColorSet", "isUnderflowColorSet", "lowestFraction", "getLowestFraction", "nullColor", "getNullColor", "()Lorg/kamaeleo/color/CPColor;", "setNullColor", "(Lorg/kamaeleo/color/CPColor;)V", "nullColor$delegate", "nullColorProperty", "getNullColorProperty", "overColorProperty", "getOverColorProperty", "overColorSetProperty", "getOverColorSetProperty", "setOverColorSetProperty", "overColorStoreProperty", "getOverColorStoreProperty", "setOverColorStoreProperty", "overflowColor", "getOverflowColor", "getPalette", "()Lorg/kamaeleo/palette/MutablePalette;", "setPalette", "(Lorg/kamaeleo/palette/MutablePalette;)V", "palette$delegate", "paletteListener", "Lorg/kamaeleo/palette/PaletteListener;", "paletteProperty", "getPaletteProperty", "setPaletteProperty", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "Lorg/kamaeleo/colormap/SimpleColorMap$PropertyType;", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "saturation", "getSaturation", "setSaturation", "saturation$delegate", "saturationProperty", "getSaturationProperty", "setSaturationProperty", "underColorProperty", "getUnderColorProperty", "underColorSetProperty", "getUnderColorSetProperty", "setUnderColorSetProperty", "underColorStoreProperty", "getUnderColorStoreProperty", "setUnderColorStoreProperty", "underflowColor", "getUnderflowColor", "arrayToString", "", "array", "", "([Ljava/lang/Object;)Ljava/lang/String;", "assignColors", "", "([Ljava/lang/Object;)V", "", "clearAssignedColor", "getColor", "value", "resetAssignedValues", "setAssignments", "assignments", "setColor", "color", "setMatching", "matching", "setOverColor", "overColor", "setProperty", "property", "setUnderColor", "underColor", "toString", "PropertyType", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class SimpleColorMap
extends AbstractColorMap
implements MutableColorMap {
    @NotNull
    private final MutableProperties<PropertyType> properties;
    @Nullable
    private MutableInterval interval;
    @NotNull
    private MutableProperty<MutablePalette> paletteProperty;
    @NotNull
    private final ReadWriteProperty palette$delegate;
    @NotNull
    private final HashMap<Object, CPColor> dictionary;
    @NotNull
    private ColorMap.Matching _matching;
    @NotNull
    private ColorMap.Assignments _assignments;
    @NotNull
    private final MutableProperty<CPColor> nullColorProperty;
    @NotNull
    private final ReadWriteProperty nullColor$delegate;
    @NotNull
    private MutableProperty<Boolean> underColorSetProperty;
    @NotNull
    private MutableProperty<CPColor> underColorStoreProperty;
    @NotNull
    private final MutableProperty<CPColor> underColorProperty;
    @NotNull
    private MutableProperty<Boolean> overColorSetProperty;
    @NotNull
    private MutableProperty<CPColor> overColorStoreProperty;
    @NotNull
    private final MutableProperty<CPColor> overColorProperty;
    @NotNull
    private MutableProperty<Boolean> isInvertedProperty;
    @NotNull
    private final ReadWriteProperty isInverted$delegate;
    @NotNull
    private MutableProperty<Boolean> colorCountSetProperty;
    @NotNull
    private MutableProperty<Integer> colorCountProperty;
    @NotNull
    private final ReadWriteProperty colorCount$delegate;
    @NotNull
    private MutableProperty<Integer> brightnessProperty;
    @NotNull
    private final ReadWriteProperty brightness$delegate;
    @NotNull
    private MutableProperty<Integer> saturationProperty;
    @NotNull
    private final ReadWriteProperty saturation$delegate;
    private float alpha;
    @NotNull
    private final CPColorFactory factory;
    @NotNull
    private final IntervalListener intervalListener;
    @NotNull
    private final PaletteListener paletteListener;
    public static final int $stable;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

    private SimpleColorMap() {
        this.properties = (MutableProperties)new EnumProperties((Enum[])PropertyType.values());
        this.paletteProperty = this.properties.createProperty((Object)PropertyType.Palette, null);
        this.palette$delegate = PropertyDelegates.INSTANCE.mutable(this.getPaletteProperty());
        this._matching = ColorMap.Matching.EXACT;
        this._assignments = ColorMap.Assignments.STATIC;
        this.nullColorProperty = this.properties.createProperty((Object)PropertyType.MissingValuesColor, null);
        this.nullColor$delegate = PropertyDelegates.INSTANCE.mutable(this.getNullColorProperty());
        this.underColorSetProperty = (MutableProperty)new SimpleProperty((Object)false);
        this.underColorStoreProperty = (MutableProperty)new SimpleProperty(null);
        this.underColorProperty = this.properties.addProperty((Object)PropertyType.UnderflowColor, (MutableProperty)new SetStoreMutableProperty(this.getUnderColorSetProperty(), this.getUnderColorStoreProperty(), this.getPaletteProperty(), 0.0));
        this.overColorSetProperty = (MutableProperty)new SimpleProperty((Object)false);
        this.overColorStoreProperty = (MutableProperty)new SimpleProperty(null);
        this.overColorProperty = this.properties.addProperty((Object)PropertyType.OverflowColor, (MutableProperty)new SetStoreMutableProperty(this.getOverColorSetProperty(), this.getOverColorStoreProperty(), this.getPaletteProperty(), 1.0));
        this.isInvertedProperty = this.properties.createProperty((Object)PropertyType.Inverted, (Object)false);
        this.isInverted$delegate = PropertyDelegates.INSTANCE.mutable(this.isInvertedProperty());
        this.colorCountSetProperty = (MutableProperty)new SimpleProperty((Object)false);
        this.colorCountProperty = this.properties.createProperty((Object)PropertyType.NumberOfSteps, (Object)3);
        this.colorCount$delegate = PropertyDelegates.INSTANCE.mutable(this.getColorCountProperty());
        this.brightnessProperty = this.properties.createProperty((Object)PropertyType.Brightness, (Object)0);
        this.brightness$delegate = PropertyDelegates.INSTANCE.mutable(this.getBrightnessProperty());
        this.saturationProperty = this.properties.createProperty((Object)PropertyType.Saturation, (Object)0);
        this.saturation$delegate = PropertyDelegates.INSTANCE.mutable(this.getSaturationProperty());
        this.alpha = 1.0f;
        this.factory = CPColorFactory.Companion.getInstance();
        this.intervalListener = new IntervalListener(this){
            final /* synthetic */ SimpleColorMap this$0;
            {
                this.this$0 = $receiver;
            }

            public void intervalChanged(@Nullable IntervalEvent event2) {
                this.this$0.notifyColorMapChanged(new ColorMapEvent(this.this$0, "inverval", null, null));
            }
        };
        this.paletteListener = new PaletteListener(this){
            final /* synthetic */ SimpleColorMap this$0;
            {
                this.this$0 = $receiver;
            }

            public void paletteChanged(@NotNull PaletteEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                this.this$0.notifyColorMapChanged(new ColorMapEvent(this.this$0, "palette", null, null));
            }
        };
        this.properties.createProperty((Object)PropertyType.Inverval, null);
        this.properties.createProperty((Object)PropertyType.Matching, (Object)ColorMap.Matching.EXACT);
        this.properties.createProperty((Object)PropertyType.Assignments, (Object)ColorMap.Assignments.STATIC);
        this.getPaletteProperty().addPropertyListener((PropertyListener)new PropertyListener<MutablePalette>(){

            public void propertyChanged(@NotNull PropertyEvent<MutablePalette> event2) {
                MutablePalette mutablePalette;
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                if (event2.getOldValue() != null) {
                    mutablePalette = (MutablePalette)event2.getOldValue();
                    Intrinsics.checkNotNull((Object)mutablePalette);
                    mutablePalette.removePaletteListener(paletteListener);
                }
                if (event2.getNewValue() != null) {
                    mutablePalette = (MutablePalette)event2.getNewValue();
                    Intrinsics.checkNotNull((Object)mutablePalette);
                    mutablePalette.addPaletteListener(paletteListener);
                }
                this.notifyColorMapChanged(new ColorMapEvent(this, "palette", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.isInvertedProperty().addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(@NotNull PropertyEvent<Boolean> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "inverted", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getBrightnessProperty().addPropertyListener((PropertyListener)new PropertyListener<Integer>(){

            public void propertyChanged(@NotNull PropertyEvent<Integer> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "brightness", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getSaturationProperty().addPropertyListener((PropertyListener)new PropertyListener<Integer>(){

            public void propertyChanged(@NotNull PropertyEvent<Integer> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "saturation", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getOverColorProperty().addPropertyListener((PropertyListener)new PropertyListener<CPColor>(){

            public void propertyChanged(@NotNull PropertyEvent<CPColor> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "overflowColor", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getUnderColorProperty().addPropertyListener((PropertyListener)new PropertyListener<CPColor>(){

            public void propertyChanged(@NotNull PropertyEvent<CPColor> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "underflowColor", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getNullColorProperty().addPropertyListener((PropertyListener)new PropertyListener<CPColor>(){

            public void propertyChanged(@NotNull PropertyEvent<CPColor> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "missingValuesColor", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getColorCountSetProperty().addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(@NotNull PropertyEvent<Boolean> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "numberOfSteps", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getColorCountProperty().addPropertyListener((PropertyListener)new PropertyListener<Integer>(){

            public void propertyChanged(@NotNull PropertyEvent<Integer> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "numberOfSteps", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getNullColorProperty().setValue((Object)this.factory.getGray());
        this.dictionary = new HashMap();
    }

    @NotNull
    protected final MutableProperties<PropertyType> getProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public MutableInterval getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(@Nullable MutableInterval interval) {
        if (this.interval != interval) {
            MutableInterval mutableInterval;
            MutableInterval old = this.getInterval();
            if (this.interval != null) {
                mutableInterval = this.interval;
                Intrinsics.checkNotNull((Object)mutableInterval);
                mutableInterval.removeIntervalListener(this.intervalListener);
            }
            this.interval = interval;
            if (this.interval != null) {
                mutableInterval = this.interval;
                Intrinsics.checkNotNull((Object)mutableInterval);
                mutableInterval.addIntervalListener(this.intervalListener);
            }
            this.notifyColorMapChanged(new ColorMapEvent(this, "inverval", old, interval));
        }
    }

    @Override
    @NotNull
    public MutableProperty<MutablePalette> getPaletteProperty() {
        return this.paletteProperty;
    }

    public void setPaletteProperty(@NotNull MutableProperty<MutablePalette> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.paletteProperty = mutableProperty;
    }

    @Override
    @Nullable
    public MutablePalette getPalette() {
        return (MutablePalette)this.palette$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void setPalette(@Nullable MutablePalette mutablePalette) {
        this.palette$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)mutablePalette);
    }

    @Override
    @NotNull
    public MutableProperty<CPColor> getNullColorProperty() {
        return this.nullColorProperty;
    }

    @Override
    @Nullable
    public CPColor getNullColor() {
        return (CPColor)this.nullColor$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Override
    public void setNullColor(@Nullable CPColor cPColor) {
        this.nullColor$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)cPColor);
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getUnderColorSetProperty() {
        return this.underColorSetProperty;
    }

    public void setUnderColorSetProperty(@NotNull MutableProperty<Boolean> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.underColorSetProperty = mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<CPColor> getUnderColorStoreProperty() {
        return this.underColorStoreProperty;
    }

    public void setUnderColorStoreProperty(@NotNull MutableProperty<CPColor> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.underColorStoreProperty = mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<CPColor> getUnderColorProperty() {
        return this.underColorProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getOverColorSetProperty() {
        return this.overColorSetProperty;
    }

    public void setOverColorSetProperty(@NotNull MutableProperty<Boolean> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.overColorSetProperty = mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<CPColor> getOverColorStoreProperty() {
        return this.overColorStoreProperty;
    }

    public void setOverColorStoreProperty(@NotNull MutableProperty<CPColor> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.overColorStoreProperty = mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<CPColor> getOverColorProperty() {
        return this.overColorProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> isInvertedProperty() {
        return this.isInvertedProperty;
    }

    public void setInvertedProperty(@NotNull MutableProperty<Boolean> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.isInvertedProperty = mutableProperty;
    }

    @Override
    public boolean isInverted() {
        return (Boolean)this.isInverted$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public void setInverted(boolean bl) {
        this.isInverted$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getColorCountSetProperty() {
        return this.colorCountSetProperty;
    }

    public void setColorCountSetProperty(@NotNull MutableProperty<Boolean> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.colorCountSetProperty = mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Integer> getColorCountProperty() {
        return this.colorCountProperty;
    }

    public void setColorCountProperty(@NotNull MutableProperty<Integer> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.colorCountProperty = mutableProperty;
    }

    @Override
    public int getColorCount() {
        return ((Number)this.colorCount$delegate.getValue((Object)this, $$delegatedProperties[3])).intValue();
    }

    public void setColorCount(int n) {
        this.colorCount$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)n);
    }

    @Override
    @NotNull
    public MutableProperty<Integer> getBrightnessProperty() {
        return this.brightnessProperty;
    }

    public void setBrightnessProperty(@NotNull MutableProperty<Integer> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.brightnessProperty = mutableProperty;
    }

    @Override
    public int getBrightness() {
        return ((Number)this.brightness$delegate.getValue((Object)this, $$delegatedProperties[4])).intValue();
    }

    @Override
    public void setBrightness(int n) {
        this.brightness$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)n);
    }

    @Override
    @NotNull
    public MutableProperty<Integer> getSaturationProperty() {
        return this.saturationProperty;
    }

    public void setSaturationProperty(@NotNull MutableProperty<Integer> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.saturationProperty = mutableProperty;
    }

    @Override
    public int getSaturation() {
        return ((Number)this.saturation$delegate.getValue((Object)this, $$delegatedProperties[5])).intValue();
    }

    @Override
    public void setSaturation(int n) {
        this.saturation$delegate.setValue((Object)this, $$delegatedProperties[5], (Object)n);
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        if (!(this.alpha == alpha)) {
            float old = this.alpha;
            this.alpha = alpha;
            this.notifyColorMapChanged(new ColorMapEvent(this, "alpha", Float.valueOf(old), Float.valueOf(alpha)));
        }
    }

    public SimpleColorMap(@NotNull MutableInterval interval, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        this();
        this.setInterval(interval);
        this.setPalette(palette);
    }

    public SimpleColorMap(@Nullable Set<?> values, boolean cyclic, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        this();
        this.setPalette(palette);
        Set<?> set = values;
        if (set != null) {
            Set<?> set2 = set;
            boolean bl = false;
            boolean bl2 = false;
            Set<?> it = set2;
            boolean bl3 = false;
            this.assignColors(it, cyclic);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CPColor getColor(@Nullable Object value) {
        CPColor color;
        block22: {
            MutableProperty<Integer> mutableProperty;
            block23: {
                color = null;
                if (value != null) {
                    color = this.factory.createNativeColor(value);
                    if (color != null) {
                        return color;
                    }
                    if (value instanceof CPColor) {
                        return (CPColor)value;
                    }
                    if (value instanceof Comparable && this.dictionary.containsKey(value)) {
                        color = this.dictionary.get(value);
                    } else if (value instanceof Number && this.getInterval() != null) {
                        int colorCount;
                        double d;
                        double v = ((Number)value).doubleValue();
                        double fraction = 0.0;
                        MutableInterval mutableInterval = this.getInterval();
                        Intrinsics.checkNotNull((Object)mutableInterval);
                        if (!mutableInterval.isDegenerate()) {
                            mutableInterval = this.getInterval();
                            Intrinsics.checkNotNull((Object)mutableInterval);
                            double d2 = v - mutableInterval.getStart();
                            mutableInterval = this.getInterval();
                            Intrinsics.checkNotNull((Object)mutableInterval);
                            d = d2 / mutableInterval.getExtent();
                        } else {
                            d = fraction = 0.5;
                        }
                        if (this.isInverted()) {
                            fraction = 1.0 - fraction;
                        }
                        if (fraction < this.getLowestFraction()) {
                            return this.getUnderflowColor();
                        }
                        if (fraction > this.getHighestFraction()) {
                            return this.getOverflowColor();
                        }
                        Object object = this.getColorCountSetProperty();
                        Intrinsics.checkNotNull(object);
                        int n = colorCount = (Boolean)object.getValue() != false ? this.getColorCount() : 0;
                        if (colorCount > 0) {
                            fraction = colorCount > 1 ? (double)((int)(fraction * (double)colorCount)) / (double)(colorCount - 1) : 0.5;
                        }
                        MutableProperty<MutablePalette> mutableProperty2 = this.getPaletteProperty();
                        Intrinsics.checkNotNull(mutableProperty2);
                        object = (MutablePalette)mutableProperty2.getValue();
                        Intrinsics.checkNotNull(object);
                        color = object.getColor(fraction);
                    } else if (value instanceof Object[]) {
                        String str = this.arrayToString((Object[])value);
                        color = this.dictionary.containsKey(str) ? this.dictionary.get(str) : this.getNullColor();
                    } else {
                        CPColor cPColor;
                        if (this._assignments == ColorMap.Assignments.DYNAMIC) {
                            void var3_5;
                            MutablePalette mutablePalette = (MutablePalette)this.getPaletteProperty().getValue();
                            Intrinsics.checkNotNull((Object)mutablePalette);
                            MutablePalette mutablePalette2 = mutablePalette;
                            int n = this.dictionary.size();
                            mutablePalette = (MutablePalette)this.getPaletteProperty().getValue();
                            Intrinsics.checkNotNull((Object)mutablePalette);
                            CPColor c2 = mutablePalette2.getColorAt(n % mutablePalette.getColorCount());
                            this.dictionary.put(value, c2);
                            cPColor = var3_5;
                        } else {
                            cPColor = this.getNullColor();
                        }
                        color = cPColor;
                    }
                } else {
                    color = this.getNullColor();
                }
                if (color == null) break block22;
                mutableProperty = this.getBrightnessProperty();
                Intrinsics.checkNotNull(mutableProperty);
                if (((Number)mutableProperty.getValue()).intValue() != 0) break block23;
                mutableProperty = this.getSaturationProperty();
                Intrinsics.checkNotNull(mutableProperty);
                if (((Number)mutableProperty.getValue()).intValue() == 0) break block22;
            }
            mutableProperty = this.getBrightnessProperty();
            Intrinsics.checkNotNull(mutableProperty);
            float f = (float)((Number)mutableProperty.getValue()).intValue() / 300.0f;
            mutableProperty = this.getSaturationProperty();
            Intrinsics.checkNotNull(mutableProperty);
            color = CPColorKt.brightenAndSaturate(color, f, (float)((Number)mutableProperty.getValue()).intValue() / 300.0f);
        }
        if (color != null && !(this.getAlpha() == 1.0f)) {
            color = CPColorKt.alpha(color, this.getAlpha());
        }
        return color;
    }

    private final String arrayToString(Object[] array) {
        String str = "";
        int n = 0;
        int n2 = array.length + -1;
        if (n <= n2) {
            do {
                int i;
                Object v;
                if ((v = array[i = n++]) != null) {
                    str = Intrinsics.stringPlus((String)str, (Object)v);
                }
                if (i >= array.length - 1) continue;
                str = Intrinsics.stringPlus((String)str, (Object)"/");
            } while (n <= n2);
        }
        return str;
    }

    protected final double getLowestFraction() {
        SortedSet entries;
        MutableProperty<MutablePalette> mutableProperty = this.getPaletteProperty();
        Intrinsics.checkNotNull(mutableProperty);
        if (mutableProperty.getValue() instanceof InterpolatedPalette) {
            MutableProperty<MutablePalette> mutableProperty2 = this.getPaletteProperty();
            Intrinsics.checkNotNull(mutableProperty2);
            Object object = mutableProperty2.getValue();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.palette.InterpolatedPalette");
            }
            entries = (SortedSet)((InterpolatedPalette)object).getEntries();
            if (!entries.isEmpty()) {
                return ((InterpolatedPalette.Entry)CollectionsKt.first((Iterable)((Iterable)entries))).getFraction();
            }
        } else {
            entries = this.getPaletteProperty();
            Intrinsics.checkNotNull(entries);
            if (entries.getValue() instanceof CustomPalette) {
                MutablePalette mutablePalette = this.getPalette();
                if (mutablePalette == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.palette.CustomPalette");
                }
                entries = (SortedSet)((CustomPalette)mutablePalette).getEntries();
                if (!entries.isEmpty()) {
                    return ((CustomPalette.Entry)CollectionsKt.first((Iterable)((Iterable)entries))).getFraction();
                }
            }
        }
        return 0.0;
    }

    protected final double getHighestFraction() {
        SortedSet entries;
        MutableProperty<MutablePalette> mutableProperty = this.getPaletteProperty();
        Intrinsics.checkNotNull(mutableProperty);
        if (mutableProperty.getValue() instanceof InterpolatedPalette) {
            MutableProperty<MutablePalette> mutableProperty2 = this.getPaletteProperty();
            Intrinsics.checkNotNull(mutableProperty2);
            Object object = mutableProperty2.getValue();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.palette.InterpolatedPalette");
            }
            entries = (SortedSet)((InterpolatedPalette)object).getEntries();
            if (!entries.isEmpty()) {
                return ((InterpolatedPalette.Entry)CollectionsKt.last((Iterable)((Iterable)entries))).getFraction();
            }
        } else {
            entries = this.getPaletteProperty();
            Intrinsics.checkNotNull(entries);
            if (entries.getValue() instanceof CustomPalette) {
                MutablePalette mutablePalette = this.getPalette();
                if (mutablePalette == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.palette.CustomPalette");
                }
                entries = (SortedSet)((CustomPalette)mutablePalette).getEntries();
                if (!entries.isEmpty()) {
                    return ((CustomPalette.Entry)CollectionsKt.last((Iterable)((Iterable)entries))).getFraction();
                }
            }
        }
        return 1.0;
    }

    @Override
    public void setMatching(@Nullable ColorMap.Matching matching) {
        if (this._matching != matching) {
            ColorMap.Matching old = this._matching;
            Intrinsics.checkNotNull((Object)((Object)matching));
            this._matching = matching;
            this.notifyColorMapChanged(new ColorMapEvent(this, "matching", (Object)old, (Object)matching));
        }
    }

    @Override
    public void setAssignments(@Nullable ColorMap.Assignments assignments) {
        if (this._assignments != assignments) {
            ColorMap.Assignments old = this._assignments;
            Intrinsics.checkNotNull((Object)((Object)assignments));
            this._assignments = assignments;
            this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", (Object)old, (Object)assignments));
        }
    }

    @Override
    @NotNull
    public CPColor getUnderflowColor() {
        CPColor cPColor = (CPColor)this.getUnderColorProperty().getValue();
        Intrinsics.checkNotNull((Object)cPColor);
        return cPColor;
    }

    @Override
    public void setUnderColor(@Nullable CPColor underColor) {
        if (!(this.getUnderflowColor() == underColor || this.getUnderflowColor() != null && this.getUnderflowColor().equals(underColor))) {
            MutableProperty<CPColor> mutableProperty = this.getUnderColorProperty();
            Intrinsics.checkNotNull((Object)underColor);
            mutableProperty.setValue((Object)underColor);
        }
    }

    @Override
    @NotNull
    public CPColor getOverflowColor() {
        MutableProperty<CPColor> mutableProperty = this.getOverColorStoreProperty();
        Intrinsics.checkNotNull(mutableProperty);
        CPColor cPColor = (CPColor)mutableProperty.getValue();
        Intrinsics.checkNotNull((Object)cPColor);
        return cPColor;
    }

    @Override
    public void setOverColor(@Nullable CPColor overColor) {
        if (!(this.getOverflowColor() == overColor || this.getOverflowColor() != null && this.getOverflowColor().equals(overColor))) {
            this.getOverColorStoreProperty().setValue((Object)overColor);
        }
    }

    @Override
    public boolean isOverflowColorSet() {
        MutableProperty<Boolean> mutableProperty = this.getOverColorSetProperty();
        Intrinsics.checkNotNull(mutableProperty);
        return (Boolean)mutableProperty.getValue();
    }

    @Override
    public boolean isUnderflowColorSet() {
        MutableProperty<Boolean> mutableProperty = this.getUnderColorSetProperty();
        Intrinsics.checkNotNull(mutableProperty);
        return (Boolean)mutableProperty.getValue();
    }

    @Override
    public void assignColors(@NotNull Set<?> values, boolean cyclic) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.dictionary.clear();
        int i = 0;
        for (Object value : values) {
            CPColor cPColor;
            MutablePalette mutablePalette;
            CPColor color = null;
            if (!cyclic) {
                mutablePalette = (MutablePalette)this.getPaletteProperty().getValue();
                Intrinsics.checkNotNull((Object)mutablePalette);
                cPColor = mutablePalette.getColor((double)i / (double)values.size());
            } else {
                mutablePalette = (MutablePalette)this.getPaletteProperty().getValue();
                Intrinsics.checkNotNull((Object)mutablePalette);
                MutablePalette mutablePalette2 = mutablePalette;
                mutablePalette = (MutablePalette)this.getPaletteProperty().getValue();
                Intrinsics.checkNotNull((Object)mutablePalette);
                cPColor = mutablePalette2.getColorAt(i % mutablePalette.getColorCount());
            }
            color = cPColor;
            Object v = null;
            v = value instanceof Object[] ? this.arrayToString((Object[])value) : value;
            Intrinsics.checkNotNull((Object)color);
            this.dictionary.put(v, color);
            int n = i;
            i = n + 1;
        }
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public void assignColors(Object ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.dictionary.clear();
        int i = 0;
        for (Object value : values) {
            if (this.dictionary.containsKey(value)) continue;
            MutableProperty<MutablePalette> mutableProperty = this.getPaletteProperty();
            Intrinsics.checkNotNull(mutableProperty);
            MutablePalette mutablePalette = (MutablePalette)mutableProperty.getValue();
            Intrinsics.checkNotNull((Object)mutablePalette);
            MutablePalette mutablePalette2 = mutablePalette;
            mutableProperty = this.getPaletteProperty();
            Intrinsics.checkNotNull(mutableProperty);
            mutablePalette = (MutablePalette)mutableProperty.getValue();
            Intrinsics.checkNotNull((Object)mutablePalette);
            this.dictionary.put(value, mutablePalette2.getColorAt(i % mutablePalette.getColorCount()));
            int n = i;
            i = n + 1;
        }
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public void assignColors(@NotNull Iterable<? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.dictionary.clear();
        int i = 0;
        for (Object object : values) {
            if (this.dictionary.containsKey(object)) continue;
            MutableProperty<MutablePalette> mutableProperty = this.getPaletteProperty();
            Intrinsics.checkNotNull(mutableProperty);
            MutablePalette mutablePalette = (MutablePalette)mutableProperty.getValue();
            Intrinsics.checkNotNull((Object)mutablePalette);
            MutablePalette mutablePalette2 = mutablePalette;
            mutableProperty = this.getPaletteProperty();
            Intrinsics.checkNotNull(mutableProperty);
            mutablePalette = (MutablePalette)mutableProperty.getValue();
            Intrinsics.checkNotNull((Object)mutablePalette);
            this.dictionary.put(object, mutablePalette2.getColorAt(i % mutablePalette.getColorCount()));
            int n = i;
            i = n + 1;
        }
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public void setColor(@Nullable Object value, @Nullable CPColor color) {
        Intrinsics.checkNotNull((Object)color);
        this.dictionary.put(value, color);
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public void clearAssignedColor() {
        this.dictionary.clear();
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    @Nullable
    public Set<Object> getAssignedValues() {
        return this.dictionary.keySet();
    }

    @Override
    public void resetAssignedValues() {
        Set set = (Set)new SortedSet((Comparator)new UniversalComparator(), null, 2, null);
        Set<Object> set2 = this.dictionary.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"dictionary.keys");
        set.addAll((Collection)set2);
        this.assignColors(set, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setProperty(@Nullable String property, @Nullable Object value) {
        if (property != null) {
            int n = -1;
            switch (property.hashCode()) {
                case -230491182: {
                    if (!property.equals("saturation")) break;
                    n = 1;
                    break;
                }
                case 1749373766: {
                    if (!property.equals("assignments")) break;
                    n = 2;
                    break;
                }
                case 648162385: {
                    if (!property.equals("brightness")) break;
                    n = 3;
                    break;
                }
                case -469157123: {
                    if (!property.equals("underflowColor")) break;
                    n = 4;
                    break;
                }
                case -1323103225: {
                    if (!property.equals("numberOfSteps")) break;
                    n = 5;
                    break;
                }
                case 92909918: {
                    if (!property.equals("alpha")) break;
                    n = 6;
                    break;
                }
                case 627676675: {
                    if (!property.equals("inverval")) break;
                    n = 7;
                    break;
                }
                case -798910853: {
                    if (!property.equals("palette")) break;
                    n = 8;
                    break;
                }
                case 627674869: {
                    if (!property.equals("inverted")) break;
                    n = 9;
                    break;
                }
                case 581745793: {
                    if (!property.equals("overflowColor")) break;
                    n = 10;
                    break;
                }
                case -184159717: {
                    if (!property.equals("missingValuesColor")) break;
                    n = 11;
                    break;
                }
                case 296922109: {
                    if (!property.equals("matching")) break;
                    n = 12;
                    break;
                }
            }
            switch (n) {
                case 7: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.interval.MutableInterval");
                    }
                    this.setInterval((MutableInterval)value);
                    return;
                }
                case 8: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.palette.MutablePalette");
                    }
                    this.setPalette((MutablePalette)value);
                    return;
                }
                case 12: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.colormap.ColorMap.Matching");
                    }
                    this.setMatching((ColorMap.Matching)((Object)value));
                    return;
                }
                case 2: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.colormap.ColorMap.Assignments");
                    }
                    this.setAssignments((ColorMap.Assignments)((Object)value));
                    return;
                }
                case 11: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.color.CPColor");
                    }
                    this.setNullColor((CPColor)value);
                    return;
                }
                case 4: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.color.CPColor");
                    }
                    this.setUnderColor((CPColor)value);
                    return;
                }
                case 10: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.color.CPColor");
                    }
                    this.setOverColor((CPColor)value);
                    return;
                }
                case 9: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    this.setInverted((Boolean)value);
                    return;
                }
                case 5: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    this.setColorCount((Integer)value);
                    return;
                }
                case 3: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    this.setBrightness((Integer)value);
                    return;
                }
                case 1: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    this.setSaturation((Integer)value);
                    return;
                }
                case 6: {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    this.setAlpha(((Float)value).floatValue());
                    return;
                }
            }
        }
        String string = Intrinsics.stringPlus((String)"Unknonw property ", (Object)property);
        boolean bl = false;
        System.out.println((Object)string);
    }

    @NotNull
    public String toString() {
        return "SimpleColorMap{interval=" + this.getInterval() + ", palette=" + this.getPalette() + ", nullColor=" + this.getNullColor() + ", underColor=" + this.getUnderColorProperty() + '}';
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SimpleColorMap.class), "palette", "getPalette()Lorg/kamaeleo/palette/MutablePalette;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SimpleColorMap.class), "nullColor", "getNullColor()Lorg/kamaeleo/color/CPColor;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SimpleColorMap.class), "isInverted", "isInverted()Z"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SimpleColorMap.class), "colorCount", "getColorCount()I"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SimpleColorMap.class), "brightness", "getBrightness()I"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SimpleColorMap.class), "saturation", "getSaturation()I")))};
        $$delegatedProperties = kPropertyArray;
        $stable = 8;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000e\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/kamaeleo/colormap/SimpleColorMap$PropertyType;", "", "(Ljava/lang/String;I)V", "Inverval", "Palette", "Matching", "Assignments", "MissingValuesColor", "UnderflowColor", "OverflowColor", "Inverted", "NumberOfSteps", "Brightness", "Saturation", "Alpha", "kamaeleo"})
    public static final class PropertyType
    extends Enum<PropertyType> {
        public static final /* enum */ PropertyType Inverval = new PropertyType();
        public static final /* enum */ PropertyType Palette = new PropertyType();
        public static final /* enum */ PropertyType Matching = new PropertyType();
        public static final /* enum */ PropertyType Assignments = new PropertyType();
        public static final /* enum */ PropertyType MissingValuesColor = new PropertyType();
        public static final /* enum */ PropertyType UnderflowColor = new PropertyType();
        public static final /* enum */ PropertyType OverflowColor = new PropertyType();
        public static final /* enum */ PropertyType Inverted = new PropertyType();
        public static final /* enum */ PropertyType NumberOfSteps = new PropertyType();
        public static final /* enum */ PropertyType Brightness = new PropertyType();
        public static final /* enum */ PropertyType Saturation = new PropertyType();
        public static final /* enum */ PropertyType Alpha = new PropertyType();
        private static final /* synthetic */ PropertyType[] $VALUES;

        public static PropertyType[] values() {
            PropertyType[] propertyTypeArray = $VALUES;
            PropertyType[] propertyTypeArray2 = new PropertyType[propertyTypeArray.length];
            System.arraycopy(propertyTypeArray, 0, propertyTypeArray2, 0, propertyTypeArray.length);
            return propertyTypeArray2;
        }

        public static PropertyType valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(PropertyType.class, value);
        }

        static {
            PropertyType[] propertyTypeArray = new PropertyType[]{Inverval, Palette, Matching, Assignments, MissingValuesColor, UnderflowColor, OverflowColor, Inverted, NumberOfSteps, Brightness, Saturation, Alpha};
            $VALUES = propertyTypeArray;
        }
    }
}

