/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.Curve;
import org.kamaeleo.geom.PathIterator;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0005\b'\u0018\u0000 .2\u00020\u0001:\u0003./0B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001aJ&\u0010#\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003J.\u0010#\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\fJ\u001e\u0010'\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001aJ\u0018\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H&J\u0006\u0010+\u001a\u00020,J \u0010-\u001a\u00020,2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\fH&R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00061"}, d2={"Lorg/kamaeleo/geom/Crossings;", "", "xLo", "", "yLo", "xHi", "yHi", "(DDDD)V", "isEmpty", "", "()Z", "limit", "", "getLimit", "()I", "setLimit", "(I)V", "tmp", "", "Lorg/kamaeleo/geom/Curve;", "getXHi", "()D", "getXLo", "getYHi", "getYLo", "yranges", "", "getYranges", "()[D", "setYranges", "([D)V", "accumulateCubic", "x0", "y0", "coords", "accumulateLine", "x1", "y1", "direction", "accumulateQuad", "covers", "ystart", "yend", "print", "", "record", "Companion", "EvenOdd", "NonZero", "kamaeleo"})
@StabilityInferred(parameters=0)
public abstract class Crossings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double xLo;
    private final double yLo;
    private final double xHi;
    private final double yHi;
    @NotNull
    private final List<Curve> tmp;
    private int limit;
    @NotNull
    private double[] yranges;
    public static final int $stable = 8;
    public static final boolean debug = false;

    public Crossings(double xLo, double yLo, double xHi, double yHi) {
        this.xLo = xLo;
        this.yLo = yLo;
        this.xHi = xHi;
        this.yHi = yHi;
        this.tmp = new ArrayList();
        this.yranges = new double[10];
    }

    public final double getXLo() {
        return this.xLo;
    }

    public final double getYLo() {
        return this.yLo;
    }

    public final double getXHi() {
        return this.xHi;
    }

    public final double getYHi() {
        return this.yHi;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    @NotNull
    public final double[] getYranges() {
        return this.yranges;
    }

    public final void setYranges(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.yranges = dArray;
    }

    public final void print() {
        boolean bl;
        String string = "Crossings [";
        boolean bl2 = false;
        System.out.println((Object)string);
        string = "  bounds = [" + this.yLo + ", " + this.yHi + ']';
        bl2 = false;
        System.out.println((Object)string);
        for (int i = 0; i < this.limit; i += 2) {
            String string2 = "  [" + this.yranges[i] + ", " + this.yranges[i + 1] + ']';
            bl = false;
            System.out.println((Object)string2);
        }
        String string3 = "]";
        bl = false;
        System.out.println((Object)string3);
    }

    public final boolean accumulateLine(double x0, double y0, double x1, double y1) {
        return y0 <= y1 ? this.accumulateLine(x0, y0, x1, y1, 1) : this.accumulateLine(x1, y1, x0, y0, -1);
    }

    public final boolean accumulateLine(double x0, double y0, double x1, double y1, int direction) {
        if (this.yHi <= y0 || this.yLo >= y1) {
            return false;
        }
        if (x0 >= this.xHi && x1 >= this.xHi) {
            return false;
        }
        if (y0 == y1) {
            return x0 >= this.xLo || x1 >= this.xLo;
        }
        double xstart = 0.0;
        double ystart = 0.0;
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (y0 < this.yLo) {
            xstart = x0 + (this.yLo - y0) * dx / dy;
            ystart = this.yLo;
        } else {
            xstart = x0;
            ystart = y0;
        }
        double yend = 0.0;
        double xend = 0.0;
        if (this.yHi < y1) {
            xend = x0 + (this.yHi - y0) * dx / dy;
            yend = this.yHi;
        } else {
            xend = x1;
            yend = y1;
        }
        if (xstart >= this.xHi && xend >= this.xHi) {
            return false;
        }
        if (xstart > this.xLo || xend > this.xLo) {
            return true;
        }
        this.record(ystart, yend, direction);
        return false;
    }

    public abstract void record(double var1, double var3, int var5);

    public final boolean accumulateQuad(double x0, double y0, @NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (y0 < this.yLo && coords[1] < this.yLo && coords[3] < this.yLo) {
            return false;
        }
        if (y0 > this.yHi && coords[1] > this.yHi && coords[3] > this.yHi) {
            return false;
        }
        if (x0 > this.xHi && coords[0] > this.xHi && coords[2] > this.xHi) {
            return false;
        }
        if (x0 < this.xLo && coords[0] < this.xLo && coords[2] < this.xLo) {
            if (y0 < coords[3]) {
                double d = this.yLo;
                boolean bl = false;
                double d2 = Math.max(y0, d);
                d = coords[3];
                double d3 = this.yHi;
                boolean bl2 = false;
                this.record(d2, Math.min(d, d3), 1);
            } else if (y0 > coords[3]) {
                double d = coords[3];
                double d4 = this.yLo;
                boolean bl = false;
                double d5 = Math.max(d, d4);
                d = this.yHi;
                boolean bl3 = false;
                this.record(d5, Math.min(y0, d), -1);
            }
            return false;
        }
        Curve.Companion.insertQuad(this.tmp, x0, y0, coords);
        for (Curve c2 : this.tmp) {
            Intrinsics.checkNotNull((Object)c2);
            if (!c2.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public final boolean accumulateCubic(double x0, double y0, @NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (y0 < this.yLo && coords[1] < this.yLo && coords[3] < this.yLo && coords[5] < this.yLo) {
            return false;
        }
        if (y0 > this.yHi && coords[1] > this.yHi && coords[3] > this.yHi && coords[5] > this.yHi) {
            return false;
        }
        if (x0 > this.xHi && coords[0] > this.xHi && coords[2] > this.xHi && coords[4] > this.xHi) {
            return false;
        }
        if (x0 < this.xLo && coords[0] < this.xLo && coords[2] < this.xLo && coords[4] < this.xLo) {
            if (y0 <= coords[5]) {
                double d = this.yLo;
                boolean bl = false;
                double d2 = Math.max(y0, d);
                d = coords[5];
                double d3 = this.yHi;
                boolean bl2 = false;
                this.record(d2, Math.min(d, d3), 1);
            } else {
                double d = coords[5];
                double d4 = this.yLo;
                boolean bl = false;
                double d5 = Math.max(d, d4);
                d = this.yHi;
                boolean bl3 = false;
                this.record(d5, Math.min(y0, d), -1);
            }
            return false;
        }
        Curve.Companion.insertCubic(this.tmp, x0, y0, coords);
        for (Curve c2 : this.tmp) {
            Intrinsics.checkNotNull((Object)c2);
            if (!c2.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public final boolean isEmpty() {
        return this.limit == 0;
    }

    public abstract boolean covers(double var1, double var3);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/kamaeleo/geom/Crossings$EvenOdd;", "Lorg/kamaeleo/geom/Crossings;", "xlo", "", "ylo", "xhi", "yhi", "(DDDD)V", "covers", "", "ystart", "yend", "record", "", "direction", "", "kamaeleo"})
    @StabilityInferred(parameters=0)
    public static final class EvenOdd
    extends Crossings {
        public static final int $stable;

        public EvenOdd(double xlo, double ylo, double xhi, double yhi) {
            super(xlo, ylo, xhi, yhi);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void record(double ystart, double yend, int direction) {
            double[] dst$iv;
            boolean bl;
            int from;
            double ystart2 = ystart;
            double yend2 = yend;
            if (ystart2 >= yend2) {
                return;
            }
            for (from = 0; from < this.getLimit() && ystart2 > this.getYranges()[from + 1]; from += 2) {
            }
            int to = from;
            while (from < this.getLimit()) {
                int n = from;
                from = n + 1;
                double yrlo = this.getYranges()[n];
                int n2 = from;
                from = n2 + 1;
                double yrhi = this.getYranges()[n2];
                if (yend2 < yrlo) {
                    n2 = to;
                    to = n2 + 1;
                    this.getYranges()[n2] = ystart2;
                    n2 = to;
                    to = n2 + 1;
                    this.getYranges()[n2] = yend2;
                    ystart2 = yrlo;
                    yend2 = yrhi;
                    continue;
                }
                double yll = 0.0;
                double ylh = 0.0;
                if (ystart2 < yrlo) {
                    yll = ystart2;
                    ylh = yrlo;
                } else {
                    yll = yrlo;
                    ylh = ystart2;
                }
                double yhh = 0.0;
                double yhl = 0.0;
                if (yend2 < yrhi) {
                    yhl = yend2;
                    yhh = yrhi;
                } else {
                    yhl = yrhi;
                    yhh = yend2;
                }
                if (ylh == yhl) {
                    ystart2 = yll;
                    yend2 = yhh;
                } else {
                    if (ylh > yhl) {
                        ystart2 = yhl;
                        yhl = ylh;
                        ylh = ystart2;
                    }
                    if (!(yll == ylh)) {
                        int n3 = to;
                        to = n3 + 1;
                        this.getYranges()[n3] = yll;
                        n3 = to;
                        to = n3 + 1;
                        this.getYranges()[n3] = ylh;
                    }
                    ystart2 = yhl;
                    yend2 = yhh;
                }
                if (!(ystart2 >= yend2)) continue;
            }
            if (to < from && from < this.getLimit()) {
                void src$iv;
                double[] yrlo = this.getYranges();
                double[] dArray = this.getYranges();
                int size$iv = this.getLimit() - from;
                boolean $i$f$arraycopy = false;
                boolean yll = false;
                bl = false;
                boolean bl2 = false;
                ArraysKt.copyInto((double[])src$iv, (double[])dst$iv, (int)to, (int)from, (int)(from + size$iv));
            }
            to += this.getLimit() - from;
            if (ystart2 < yend2) {
                if (to >= this.getYranges().length) {
                    void srcPos$iv;
                    void src$iv;
                    double[] newranges = new double[to + 10];
                    dst$iv = this.getYranges();
                    boolean size$iv = false;
                    int dstPos$iv = 0;
                    boolean $i$f$arraycopy = false;
                    bl = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    ArraysKt.copyInto((double[])src$iv, (double[])newranges, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + to));
                    this.setYranges(newranges);
                }
                int n = to;
                to = n + 1;
                this.getYranges()[n] = ystart2;
                n = to;
                to = n + 1;
                this.getYranges()[n] = yend2;
            }
            this.setLimit(to);
        }

        @Override
        public boolean covers(double ystart, double yend) {
            return this.getLimit() == 2 && this.getYranges()[0] <= ystart && this.getYranges()[1] >= yend;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0011J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/kamaeleo/geom/Crossings$NonZero;", "Lorg/kamaeleo/geom/Crossings;", "xlo", "", "ylo", "xhi", "yhi", "(DDDD)V", "crosscounts", "", "covers", "", "ystart", "yend", "insert", "", "cur", "", "lo", "hi", "dir", "record", "direction", "remove", "kamaeleo"})
    @StabilityInferred(parameters=0)
    public static final class NonZero
    extends Crossings {
        @NotNull
        private int[] crosscounts = new int[this.getYranges().length / 2];
        public static final int $stable = 8;

        public NonZero(double xlo, double ylo, double xhi, double yhi) {
            super(xlo, ylo, xhi, yhi);
        }

        @Override
        public void record(double ystart, double yend, int direction) {
            int cur;
            double ystart2 = ystart;
            if (ystart2 >= yend) {
                return;
            }
            for (cur = 0; cur < this.getLimit() && ystart2 > this.getYranges()[cur + 1]; cur += 2) {
            }
            if (cur < this.getLimit()) {
                int rdir = this.crosscounts[cur / 2];
                double yrlo = this.getYranges()[cur + 0];
                double yrhi = this.getYranges()[cur + 1];
                if (yrhi == ystart2 && rdir == direction) {
                    if (cur + 2 == this.getLimit()) {
                        this.getYranges()[cur + 1] = yend;
                        return;
                    }
                    this.remove(cur);
                    ystart2 = yrlo;
                    rdir = this.crosscounts[cur / 2];
                    yrlo = this.getYranges()[cur + 0];
                    yrhi = this.getYranges()[cur + 1];
                }
                if (yend < yrlo) {
                    this.insert(cur, ystart2, yend, direction);
                    return;
                }
                if (yend == yrlo && rdir == direction) {
                    this.getYranges()[cur] = ystart2;
                    return;
                }
                if (ystart2 < yrlo) {
                    this.insert(cur, ystart2, yrlo, direction);
                    cur += 2;
                    ystart2 = yrlo;
                } else if (yrlo < ystart2) {
                    this.insert(cur, yrlo, ystart2, rdir);
                    cur += 2;
                }
                int newdir = rdir + direction;
                int n = 0;
                double newend = Math.min(yend, yrhi);
                if (newdir == 0) {
                    this.remove(cur);
                } else {
                    this.crosscounts[cur / 2] = newdir;
                    n = cur;
                    cur = n + 1;
                    this.getYranges()[n] = ystart2;
                    n = cur;
                    cur = n + 1;
                    this.getYranges()[n] = newend;
                }
                ystart2 = yrlo = newend;
                if (yrlo < yrhi) {
                    this.insert(cur, yrlo, yrhi, rdir);
                }
            }
            if (ystart2 < yend) {
                this.insert(cur, ystart2, yend, direction);
            }
        }

        @Override
        public boolean covers(double ystart, double yend) {
            double ystart2 = ystart;
            int i = 0;
            while (i < this.getLimit()) {
                int n = i;
                i = n + 1;
                double ylo = this.getYranges()[n];
                int n2 = i;
                i = n2 + 1;
                double yhi = this.getYranges()[n2];
                if (ystart2 >= yhi) continue;
                if (ystart2 < ylo) {
                    return false;
                }
                if (yend <= yhi) {
                    return true;
                }
                ystart2 = yhi;
            }
            return ystart2 >= yend;
        }

        /*
         * WARNING - void declaration
         */
        public final void remove(int cur) {
            NonZero nonZero = this;
            nonZero.setLimit(nonZero.getLimit() - 2);
            int rem = this.getLimit() - cur;
            if (rem > 0) {
                void dstPos$iv;
                int srcPos$iv;
                int[] src$iv;
                double[] dArray = this.getYranges();
                int n = cur + 2;
                Object[] dst$iv = this.getYranges();
                int $i$f$arraycopy = 0;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                ArraysKt.copyInto((double[])src$iv, (double[])dst$iv, (int)cur, (int)srcPos$iv, (int)(srcPos$iv + rem));
                src$iv = this.crosscounts;
                srcPos$iv = cur / 2 + 1;
                dst$iv = this.crosscounts;
                $i$f$arraycopy = cur / 2;
                int size$iv = rem / 2;
                boolean $i$f$arraycopy2 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                ArraysKt.copyInto((int[])src$iv, (int[])dst$iv, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + size$iv));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void insert(int cur, double lo, double hi, int dir) {
            boolean bl;
            boolean bl2;
            boolean $i$f$arraycopy;
            int size$iv;
            boolean bl3;
            int dstPos$iv;
            int rem = this.getLimit() - cur;
            double[] oldranges = this.getYranges();
            int[] oldcounts = this.crosscounts;
            if (this.getLimit() >= this.getYranges().length) {
                int srcPos$iv;
                int[] dst$iv;
                this.setYranges(new double[this.getLimit() + 10]);
                boolean bl4 = false;
                double[] dArray = this.getYranges();
                dstPos$iv = 0;
                boolean $i$f$arraycopy2 = false;
                boolean bl5 = false;
                bl3 = false;
                boolean bl6 = false;
                ArraysKt.copyInto((double[])oldranges, (double[])dst$iv, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + cur));
                this.crosscounts = new int[(this.getLimit() + 10) / 2];
                srcPos$iv = 0;
                dst$iv = this.crosscounts;
                dstPos$iv = 0;
                size$iv = cur / 2;
                $i$f$arraycopy = false;
                bl3 = false;
                bl2 = false;
                bl = false;
                ArraysKt.copyInto((int[])oldcounts, (int[])dst$iv, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + size$iv));
            }
            if (rem > 0) {
                void dst$iv;
                void dst$iv22;
                double[] srcPos$iv = this.getYranges();
                int dstPos$iv22 = cur + 2;
                int $i$f$arraycopy3 = 0;
                size$iv = 0;
                $i$f$arraycopy = false;
                boolean bl7 = false;
                ArraysKt.copyInto((double[])oldranges, (double[])dst$iv22, (int)dstPos$iv22, (int)cur, (int)(cur + rem));
                int dst$iv22 = cur / 2;
                int[] dstPos$iv22 = this.crosscounts;
                $i$f$arraycopy3 = cur / 2 + 1;
                size$iv = rem / 2;
                $i$f$arraycopy = false;
                bl3 = false;
                bl2 = false;
                bl = false;
                ArraysKt.copyInto((int[])oldcounts, (int[])dst$iv, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + size$iv));
            }
            this.getYranges()[cur + 0] = lo;
            this.getYranges()[cur + 1] = hi;
            this.crosscounts[cur / 2] = dir;
            NonZero nonZero = this;
            nonZero.setLimit(nonZero.getLimit() + 2);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0010\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ0\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kamaeleo/geom/Crossings$Companion;", "", "()V", "debug", "", "findCrossings", "Lorg/kamaeleo/geom/Crossings;", "curves", "", "Lorg/kamaeleo/geom/Curve;", "xlo", "", "ylo", "xhi", "yhi", "pi", "Lorg/kamaeleo/geom/PathIterator;", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Crossings findCrossings(@NotNull List<? extends Curve> curves, double xlo, double ylo, double xhi, double yhi) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            Crossings cross = new EvenOdd(xlo, ylo, xhi, yhi);
            for (Curve curve : curves) {
                Intrinsics.checkNotNull((Object)curve);
                if (!curve.accumulateCrossings(cross)) continue;
                return null;
            }
            return cross;
        }

        @Nullable
        public final Crossings findCrossings(@NotNull PathIterator pi, double xlo, double ylo, double xhi, double yhi) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Crossings cross = null;
            cross = pi.getWindingRule() == 0 ? (Crossings)new EvenOdd(xlo, ylo, xhi, yhi) : (Crossings)new NonZero(xlo, ylo, xhi, yhi);
            double[] coords = new double[23];
            double movx = 0.0;
            double movy = 0.0;
            double curx = 0.0;
            double cury = 0.0;
            while (!pi.isDone()) {
                int type = pi.currentSegment(coords);
                double newy = 0.0;
                double newx = 0.0;
                int n = type;
                switch (n) {
                    case 0: {
                        if (!(movy == cury) && cross.accumulateLine(curx, cury, movx, movy)) {
                            return null;
                        }
                        Companion companion = this;
                        boolean bl = false;
                        boolean bl2 = false;
                        Companion $this$findCrossings_u24lambda_u2d0 = companion;
                        boolean bl3 = false;
                        movx = curx = coords[0];
                        companion = this;
                        bl = false;
                        bl2 = false;
                        Companion $this$findCrossings_u24lambda_u2d1 = companion;
                        boolean bl4 = false;
                        movy = cury = coords[1];
                        break;
                    }
                    case 1: {
                        newx = coords[0];
                        newy = coords[1];
                        if (cross.accumulateLine(curx, cury, newx, newy)) {
                            return null;
                        }
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 2: {
                        newx = coords[2];
                        newy = coords[3];
                        if (cross.accumulateQuad(curx, cury, coords)) {
                            return null;
                        }
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 3: {
                        newx = coords[4];
                        newy = coords[5];
                        if (cross.accumulateCubic(curx, cury, coords)) {
                            return null;
                        }
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 4: {
                        if (!(movy == cury) && cross.accumulateLine(curx, cury, movx, movy)) {
                            return null;
                        }
                        curx = movx;
                        cury = movy;
                    }
                }
                pi.next();
            }
            if (!(movy == cury) && cross.accumulateLine(curx, cury, movx, movy)) {
                return null;
            }
            return cross;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

