/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kamaeleo.geom.Geometry;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Segment;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B#\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0000J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J6\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016J\u0011\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016J\u0016\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016J&\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016J\u0019\u0010&\u001a\u00020'2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\n\u00a8\u0006+"}, d2={"Lorg/kamaeleo/geom/Path;", "Lorg/kamaeleo/geom/Geometry;", "()V", "segments", "", "Lorg/kamaeleo/geom/Segment;", "([Lorg/kamaeleo/geom/Segment;)V", "windingRule", "", "(I[Lorg/kamaeleo/geom/Segment;)V", "(I)V", "", "getWindingRule", "()I", "setWindingRule", "close", "contains", "", "point", "Lorg/kamaeleo/geom/Point2D;", "cubicTo", "control1X", "", "control1Y", "control2X", "control2Y", "x", "y", "getSegments", "()[Lorg/kamaeleo/geom/Segment;", "lineTo", "moveTo", "pointCrossings", "px", "py", "quadTo", "controlX", "controlY", "setSegments", "", "toString", "", "Companion", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class Path
implements Geometry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int windingRule;
    @NotNull
    private List<Segment> segments;
    public static final int $stable = 8;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final long serialVersionUID = 1L;

    public final int getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(int n) {
        this.windingRule = n;
    }

    public Path() {
        this.windingRule = 1;
        this.segments = new ArrayList();
    }

    public Path(Segment ... segments) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        Segment[] segmentArray = new Segment[segments.length];
        System.arraycopy(segments, 0, segmentArray, 0, segments.length);
        this(1, segmentArray);
    }

    public Path(int windingRule, Segment ... segments) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        this(windingRule);
        for (Segment s : segments) {
            this.segments.add(s);
        }
    }

    public Path(int windingRule) {
        this.windingRule = 1;
        this.segments = new ArrayList();
        this.windingRule = windingRule;
    }

    @NotNull
    public final Path close() {
        this.segments.add(new Segment(4, new Point2D[0]));
        return this;
    }

    @NotNull
    public final Path cubicTo(double control1X, double control1Y, double control2X, double control2Y, double x, double y) {
        Point2D[] point2DArray = new Point2D[]{new Point2D.Double(control1X, control1Y), new Point2D.Double(control2X, control2Y), new Point2D.Double(x, y)};
        this.segments.add(new Segment(3, point2DArray));
        return this;
    }

    @NotNull
    public final Path lineTo(double x, double y) {
        Point2D[] point2DArray = new Point2D[]{new Point2D.Double(x, y)};
        this.segments.add(new Segment(1, point2DArray));
        return this;
    }

    @NotNull
    public final Path moveTo(double x, double y) {
        Point2D[] point2DArray = new Point2D[]{new Point2D.Double(x, y)};
        this.segments.add(new Segment(0, point2DArray));
        return this;
    }

    @NotNull
    public final Path quadTo(double controlX, double controlY, double x, double y) {
        Point2D[] point2DArray = new Point2D[]{new Point2D.Double(controlX, controlY), new Point2D.Double(x, y)};
        this.segments.add(new Segment(2, point2DArray));
        return this;
    }

    @NotNull
    public final Segment[] getSegments() {
        Collection $this$toTypedArray$iv = this.segments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Segment[] segmentArray = thisCollection$iv.toArray(new Segment[0]);
        if (segmentArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return segmentArray;
    }

    public final void setSegments(@NotNull Segment[] segments) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        this.segments = ArraysKt.toMutableList((Object[])segments);
    }

    @Override
    public boolean contains(@NotNull Point2D point) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double x = point.getX();
        double y = point.getY();
        if (x * 0.0 + y * 0.0 == 0.0) {
            int mask;
            if (this.segments.size() < 2) {
                return false;
            }
            int n = mask = this.windingRule == 1 ? -1 : 1;
            bl = (this.pointCrossings(x, y) & mask) != 0;
        } else {
            bl = false;
        }
        return bl;
    }

    public final int pointCrossings(double px, double py) {
        Point2D mov = null;
        Point2D[] point2DArray = this.segments.get(0).getPoints();
        Intrinsics.checkNotNull((Object)point2DArray);
        mov = point2DArray[0];
        Object cur = null;
        cur = mov;
        Object end = null;
        int crossings = 0;
        int ci = 0;
        ci = 1;
        int n = this.segments.size();
        int n2 = 1;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int i = n2++;
                Segment segment = this.segments.get(i);
                int n4 = segment.getType();
                switch (n4) {
                    case 0: {
                        Intrinsics.checkNotNull((Object)cur);
                        if (cur.getY() != mov.getY()) {
                            crossings += Companion.pointCrossingsForLine(px, py, cur.getX(), cur.getY(), mov.getX(), mov.getY());
                        }
                        Object object = this;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object $this$pointCrossings_u24lambda_u2d0 = object;
                        boolean bl3 = false;
                        Point2D[] point2DArray2 = segment.getPoints();
                        Intrinsics.checkNotNull((Object)point2DArray2);
                        int n5 = ci;
                        ci = n5 + 1;
                        cur = point2DArray2[n5];
                        Intrinsics.checkNotNull((Object)cur);
                        mov = cur;
                        break;
                    }
                    case 1: {
                        Object it;
                        Intrinsics.checkNotNull((Object)cur);
                        double d = cur.getX();
                        double d2 = cur.getY();
                        Object object = segment.getPoints();
                        Intrinsics.checkNotNull((Object)object);
                        int n6 = ci;
                        ci = n6 + 1;
                        object = object[n6];
                        boolean bl = false;
                        boolean bl2 = false;
                        Object $this$pointCrossings_u24lambda_u2d0 = object;
                        double d3 = d2;
                        double d4 = d;
                        double d5 = py;
                        double d6 = px;
                        Companion companion = Companion;
                        int n7 = crossings;
                        boolean bl4 = false;
                        end = it;
                        Unit unit = Unit.INSTANCE;
                        double d7 = object.getX();
                        object = segment.getPoints();
                        Intrinsics.checkNotNull((Object)object);
                        crossings = n7 + companion.pointCrossingsForLine(d6, d5, d4, d3, d7, object[ci].getY());
                        cur = end;
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)cur);
                        double d = cur.getX();
                        double d8 = cur.getY();
                        Object object = segment.getPoints();
                        Intrinsics.checkNotNull((Object)object);
                        int n8 = ci;
                        ci = n8 + 1;
                        double d9 = object[n8].getX();
                        Point2D[] point2DArray3 = segment.getPoints();
                        Intrinsics.checkNotNull((Object)point2DArray3);
                        double d10 = point2DArray3[ci].getY();
                        point2DArray3 = segment.getPoints();
                        Intrinsics.checkNotNull((Object)point2DArray3);
                        int n9 = ci;
                        ci = n9 + 1;
                        object = point2DArray3[n9];
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object;
                        double d11 = d10;
                        double d12 = d9;
                        double d3 = d8;
                        double d4 = d;
                        double d5 = py;
                        double d6 = px;
                        Companion companion = Companion;
                        int n7 = crossings;
                        boolean bl5 = false;
                        end = it;
                        Unit unit = Unit.INSTANCE;
                        double d13 = object.getX();
                        object = segment.getPoints();
                        Intrinsics.checkNotNull((Object)object);
                        crossings = n7 + companion.pointCrossingsForQuad(d6, d5, d4, d3, d12, d11, d13, object[ci].getY(), 0);
                        cur = end;
                        break;
                    }
                    case 3: {
                        Intrinsics.checkNotNull((Object)cur);
                        double d = cur.getX();
                        double d14 = cur.getY();
                        Object object = segment.getPoints();
                        Intrinsics.checkNotNull((Object)object);
                        int n10 = ci;
                        ci = n10 + 1;
                        double d15 = object[n10].getX();
                        Point2D[] point2DArray4 = segment.getPoints();
                        Intrinsics.checkNotNull((Object)point2DArray4);
                        double d16 = point2DArray4[ci].getY();
                        point2DArray4 = segment.getPoints();
                        Intrinsics.checkNotNull((Object)point2DArray4);
                        int n11 = ci;
                        ci = n11 + 1;
                        double d17 = point2DArray4[n11].getX();
                        Point2D[] point2DArray5 = segment.getPoints();
                        Intrinsics.checkNotNull((Object)point2DArray5);
                        double d18 = point2DArray5[ci].getY();
                        point2DArray5 = segment.getPoints();
                        Intrinsics.checkNotNull((Object)point2DArray5);
                        int n12 = ci;
                        ci = n12 + 1;
                        object = point2DArray5[n12];
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object;
                        double d19 = d18;
                        double d20 = d17;
                        double d11 = d16;
                        double d21 = d15;
                        double d3 = d14;
                        double d4 = d;
                        double d5 = py;
                        double d6 = px;
                        Companion companion = Companion;
                        int n7 = crossings;
                        boolean bl6 = false;
                        end = it;
                        Unit unit = Unit.INSTANCE;
                        double d22 = object.getX();
                        object = segment.getPoints();
                        Intrinsics.checkNotNull((Object)object);
                        crossings = n7 + companion.pointCrossingsForCubic(d6, d5, d4, d3, d21, d11, d20, d19, d22, object[ci].getY(), 0);
                        cur = end;
                        break;
                    }
                    case 4: {
                        Intrinsics.checkNotNull((Object)cur);
                        if (cur.getY() != mov.getY()) {
                            crossings += Companion.pointCrossingsForLine(px, py, cur.getX(), cur.getY(), mov.getX(), mov.getY());
                        }
                        cur = mov;
                    }
                }
            } while (n2 <= n3);
        }
        Intrinsics.checkNotNull((Object)cur);
        if (cur.getY() != mov.getY()) {
            crossings += Companion.pointCrossingsForLine(px, py, cur.getX(), cur.getY(), mov.getX(), mov.getY());
        }
        return crossings;
    }

    @NotNull
    public String toString() {
        return "Path{windingRule=" + this.windingRule + ", segments=" + this.segments + '}';
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0004J6\u0010\u0015\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nJN\u0010\u0016\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/kamaeleo/geom/Path$Companion;", "", "()V", "WIND_EVEN_ODD", "", "WIND_NON_ZERO", "serialVersionUID", "", "pointCrossingsForCubic", "px", "", "py", "x0", "y0", "xc0", "yc0", "xc1", "yc1", "x1", "y1", "level", "pointCrossingsForLine", "pointCrossingsForQuad", "xc", "yc", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public final int pointCrossingsForLine(double px, double py, double x0, double y0, double x1, double y1) {
            if (py < y0 && py < y1) {
                return 0;
            }
            if (py >= y0 && py >= y1) {
                return 0;
            }
            if (px >= x0 && px >= x1) {
                return 0;
            }
            if (px < x0 && px < x1) {
                return y0 < y1 ? 1 : -1;
            }
            double xintercept = x0 + (py - y0) * (x1 - x0) / (y1 - y0);
            if (px >= xintercept) {
                return 0;
            }
            return y0 < y1 ? 1 : -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final int pointCrossingsForQuad(double px, double py, double x0, double y0, double xc, double yc, double x1, double y1, int level) {
            double xc2 = xc;
            double yc2 = yc;
            if (py < y0 && py < yc2 && py < y1) {
                return 0;
            }
            if (py >= y0 && py >= yc2 && py >= y1) {
                return 0;
            }
            if (px >= x0 && px >= xc2 && px >= x1) {
                return 0;
            }
            if (px < x0 && px < xc2 && px < x1) {
                if (py >= y0) {
                    if (!(py < y1)) return 0;
                    return 1;
                }
                if (!(py >= y1)) return 0;
                return -1;
            }
            if (level > 52) {
                return this.pointCrossingsForLine(px, py, x0, y0, x1, y1);
            }
            double x0c = (x0 + xc2) / (double)2;
            double y0c = (y0 + yc2) / (double)2;
            double xc1 = (xc2 + x1) / (double)2;
            double yc1 = (yc2 + y1) / (double)2;
            xc2 = (x0c + xc1) / (double)2;
            yc2 = (y0c + yc1) / (double)2;
            double d = xc2;
            boolean bl = false;
            if (Double.isNaN(d)) return 0;
            d = yc2;
            bl = false;
            if (Double.isNaN(d)) {
                return 0;
            }
            int n = this.pointCrossingsForQuad(px, py, x0, y0, x0c, y0c, xc2, yc2, level + 1) + this.pointCrossingsForQuad(px, py, xc2, yc2, xc1, yc1, x1, y1, level + 1);
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final int pointCrossingsForCubic(double px, double py, double x0, double y0, double xc0, double yc0, double xc1, double yc1, double x1, double y1, int level) {
            double xc02 = xc0;
            double yc02 = yc0;
            double xc12 = xc1;
            double yc12 = yc1;
            if (py < y0 && py < yc02 && py < yc12 && py < y1) {
                return 0;
            }
            if (py >= y0 && py >= yc02 && py >= yc12 && py >= y1) {
                return 0;
            }
            if (px >= x0 && px >= xc02 && px >= xc12 && px >= x1) {
                return 0;
            }
            if (px < x0 && px < xc02 && px < xc12 && px < x1) {
                if (py >= y0) {
                    if (!(py < y1)) return 0;
                    return 1;
                }
                if (!(py >= y1)) return 0;
                return -1;
            }
            if (level > 52) {
                return this.pointCrossingsForLine(px, py, x0, y0, x1, y1);
            }
            double xmid = (xc02 + xc12) / (double)2;
            double ymid = (yc02 + yc12) / (double)2;
            xc02 = (x0 + xc02) / (double)2;
            yc02 = (y0 + yc02) / (double)2;
            xc12 = (xc12 + x1) / (double)2;
            yc12 = (yc12 + y1) / (double)2;
            double xc0m = (xc02 + xmid) / (double)2;
            double yc0m = (yc02 + ymid) / (double)2;
            double xmc1 = (xmid + xc12) / (double)2;
            double ymc1 = (ymid + yc12) / (double)2;
            xmid = (xc0m + xmc1) / (double)2;
            ymid = (yc0m + ymc1) / (double)2;
            double d = xmid;
            boolean bl = false;
            if (Double.isNaN(d)) return 0;
            d = ymid;
            bl = false;
            if (Double.isNaN(d)) {
                return 0;
            }
            int n = this.pointCrossingsForCubic(px, py, x0, y0, xc02, yc02, xc0m, yc0m, xmid, ymid, level + 1) + this.pointCrossingsForCubic(px, py, xmid, ymid, xmc1, ymc1, xc12, yc12, x1, y1, level + 1);
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

