/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.kamaeleo.geom.curve.Geom;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ParametricCurve;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/kamaeleo/geom/curve/BinaryCurveApproximationAlgorithm;", "", "()V", "checkSpace", "", "", "stack", "size", "", "([[DI)[[D", "genPts", "", "pc", "Lorg/kamaeleo/geom/curve/ParametricCurve;", "t_min", "", "t_max", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "kamaeleo"})
public final class BinaryCurveApproximationAlgorithm {
    @NotNull
    public static final BinaryCurveApproximationAlgorithm INSTANCE = new BinaryCurveApproximationAlgorithm();

    private BinaryCurveApproximationAlgorithm() {
    }

    public final void genPts(@NotNull ParametricCurve pc, double t_min, double t_max, @NotNull MultiPath mp) {
        double t2;
        Intrinsics.checkNotNullParameter((Object)pc, (String)"pc");
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        int n = mp.getDimension();
        double t1 = t_min;
        double[] rdy = new double[n + 1];
        rdy[n] = t1;
        pc.eval(rdy);
        double[] p = new double[n + 1];
        p[n] = t2 = t_max;
        pc.eval(p);
        int count = 0;
        Object stack = new double[10][];
        int n2 = count;
        count = n2 + 1;
        stack[n2] = p;
        double[][] limit = new double[pc.getSampleLimit()][];
        double flatSq = mp.getFlatness() * mp.getFlatness();
        double[] d = new double[n + 1];
        while (true) {
            double dist;
            double[] pt;
            double m;
            block12: {
                block11: {
                    m = (t1 + t2) / (double)2;
                    pt = new double[n + 1];
                    pt[n] = m;
                    pc.eval(pt);
                    double d2 = dist = Geom.INSTANCE.ptSegDistSq(rdy, stack[count - 1], pt, d, n);
                    boolean bl = false;
                    if (Double.isNaN(d2)) break block11;
                    d2 = dist;
                    bl = false;
                    if (!Double.isInfinite(d2)) break block12;
                }
                String msg = "NaN or infinity resulted from calling the eval method of the " + Reflection.getOrCreateKotlinClass(pc.getClass()) + " class.";
                throw new RuntimeException(msg);
            }
            boolean flag = false;
            if (dist < flatSq) {
                int n3;
                int i = 0;
                double mm = 0.0;
                while (i < ((Object[])limit).length) {
                    mm = (t1 + m) / (double)2;
                    double[] q = new double[n + 1];
                    limit[i] = q;
                    q[n] = mm;
                    pc.eval(q);
                    if (Geom.INSTANCE.ptSegDistSq(rdy, pt, q, d, n) >= flatSq) break;
                    m = mm;
                    n3 = i;
                    i = n3 + 1;
                }
                if (i == ((Object[])limit).length) {
                    flag = true;
                } else {
                    stack = this.checkSpace((double[][])stack, count);
                    int n4 = count;
                    count = n4 + 1;
                    stack[n4] = pt;
                    n4 = 0;
                    n3 = i;
                    if (n4 <= n3) {
                        int j;
                        do {
                            j = n4++;
                            stack = this.checkSpace((double[][])stack, count);
                            int n5 = count;
                            count = n5 + 1;
                            stack[n5] = limit[j];
                        } while (j != n3);
                    }
                    t2 = mm;
                }
            }
            if (flag) {
                mp.lineTo(rdy);
                mp.lineTo(pt);
                double[] dArray = stack[--count];
                Intrinsics.checkNotNull((Object)dArray);
                rdy = dArray;
                if (count == 0) break;
                pt = stack[count - 1];
                t1 = t2;
                Intrinsics.checkNotNull((Object)pt);
                t2 = pt[n];
                continue;
            }
            if (!(t2 > m)) continue;
            stack = this.checkSpace((double[][])stack, count);
            int n6 = count;
            count = n6 + 1;
            stack[n6] = pt;
            t2 = m;
        }
        mp.lineTo(rdy);
    }

    /*
     * WARNING - void declaration
     */
    private final double[][] checkSpace(double[][] stack, int size) {
        if (size == ((Object[])stack).length) {
            void srcPos$iv;
            double[][] arr = new double[2 * size][];
            boolean bl = false;
            int dstPos$iv = 0;
            boolean $i$f$arraycopy = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            ArraysKt.copyInto((Object[])((Object[])stack), (Object[])((Object[])arr), (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + size));
            return arr;
        }
        return stack;
    }
}

