/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.curve.BinaryCurveApproximationAlgorithm;
import org.kamaeleo.geom.curve.ControlPath;
import org.kamaeleo.geom.curve.GroupIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ParametricCurve;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/kamaeleo/geom/curve/CardinalSpline;", "Lorg/kamaeleo/geom/curve/ParametricCurve;", "cp", "Lorg/kamaeleo/geom/curve/ControlPath;", "gi", "Lorg/kamaeleo/geom/curve/GroupIterator;", "(Lorg/kamaeleo/geom/curve/ControlPath;Lorg/kamaeleo/geom/curve/GroupIterator;)V", "alpha", "", "getAlpha", "()D", "setAlpha", "(D)V", "sampleLimit", "", "getSampleLimit", "()I", "appendTo", "", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "eval", "p", "", "Companion", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class CardinalSpline
extends ParametricCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double alpha = 0.5;
    public static final int $stable = 8;
    @NotNull
    private static final double[][] pt = new double[4][];

    public CardinalSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(double d) {
        this.alpha = d;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        Object object3 = this.getGi();
        Intrinsics.checkNotNull((Object)object3);
        GroupIterator groupIterator = object3;
        object3 = this.getCp();
        Intrinsics.checkNotNull((Object)object3);
        if (!groupIterator.isInRange(0, ((ControlPath)object3).numPoints())) {
            return;
        }
        object3 = this.getGi();
        Intrinsics.checkNotNull((Object)object3);
        if (((GroupIterator)object3).getGroupSize() < 4) {
            return;
        }
        object3 = this.getGi();
        Intrinsics.checkNotNull((Object)object3);
        ((GroupIterator)object3).set(0, 0);
        int n = 0;
        do {
            int i = n++;
            object2 = this.getCp();
            Intrinsics.checkNotNull((Object)object2);
            ControlPath controlPath = object2;
            object2 = this.getGi();
            Intrinsics.checkNotNull((Object)object2);
            object = controlPath.getPoint(((GroupIterator)object2).next());
            Intrinsics.checkNotNull((Object)object);
            CardinalSpline.pt[i] = object.getLocation();
        } while (n <= 3);
        double[] d = new double[mp.getDimension() + 1];
        this.eval(d);
        if (this.getConnect()) {
            mp.lineTo(d);
        } else {
            mp.moveTo(d);
        }
        GroupIterator i = this.getGi();
        Intrinsics.checkNotNull((Object)i);
        i.set(0, 0);
        while (true) {
            object = this.getGi();
            Intrinsics.checkNotNull((Object)object);
            int index_i = ((GroupIterator)object).index_i();
            object2 = this.getGi();
            Intrinsics.checkNotNull((Object)object2);
            int count_j = ((GroupIterator)object2).count_j();
            int n2 = 0;
            do {
                int i2 = n2++;
                Object object4 = this.getGi();
                Intrinsics.checkNotNull((Object)object4);
                if (!((GroupIterator)object4).hasNext()) {
                    return;
                }
                Object object5 = this.getCp();
                Intrinsics.checkNotNull((Object)object5);
                ControlPath controlPath = object5;
                object5 = this.getGi();
                Intrinsics.checkNotNull((Object)object5);
                object4 = controlPath.getPoint(((GroupIterator)object5).next());
                Intrinsics.checkNotNull((Object)object4);
                CardinalSpline.pt[i2] = object4.getLocation();
            } while (n2 <= 3);
            object2 = this.getGi();
            Intrinsics.checkNotNull((Object)object2);
            ((GroupIterator)object2).set(index_i, count_j);
            object2 = this.getGi();
            Intrinsics.checkNotNull((Object)object2);
            ((GroupIterator)object2).next();
            BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, 0.0, 1.0, mp);
        }
    }

    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        double t2 = t * t;
        double t3 = t2 * t;
        double a = (double)2 * t3 - (double)3 * t2 + 1.0;
        double b = (double)-2 * t3 + (double)3 * t2;
        double c2 = this.alpha * (t3 - (double)2 * t2 + t);
        double d = this.alpha * (t3 - t2);
        int n = p.length - 1;
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int i = n2++;
                double[] dArray = pt[1];
                Intrinsics.checkNotNull((Object)dArray);
                double d2 = a * dArray[i];
                dArray = pt[2];
                Intrinsics.checkNotNull((Object)dArray);
                double d3 = d2 + b * dArray[i];
                dArray = pt[2];
                Intrinsics.checkNotNull((Object)dArray);
                double d4 = dArray[i];
                dArray = pt[0];
                Intrinsics.checkNotNull((Object)dArray);
                double d5 = d3 + c2 * (d4 - dArray[i]);
                dArray = pt[3];
                Intrinsics.checkNotNull((Object)dArray);
                double d6 = dArray[i];
                dArray = pt[1];
                Intrinsics.checkNotNull((Object)dArray);
                p[i] = d5 + d * (d6 - dArray[i]);
            } while (n2 <= n3);
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kamaeleo/geom/curve/CardinalSpline$Companion;", "", "()V", "pt", "", "", "[[D", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

