/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.MathUtil;

@Deprecated(message="See {@link Length}, {@link Area}, {@link Distance},\n              {@link Orientation}, {@link PointLocation}")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0007J#\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0!H\u0007\u00a2\u0006\u0002\u0010\"J#\u0010#\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0!H\u0007\u00a2\u0006\u0002\u0010$J'\u0010%\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0!H\u0007\u00a2\u0006\u0002\u0010\"J\u001b\u0010'\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0!H\u0007\u00a2\u0006\u0002\u0010(J \u0010)\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0007J \u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0007J \u0010.\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0007J#\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u001a2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001a0!H\u0007\u00a2\u0006\u0002\u00100J(\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u001aH\u0007J\u001b\u00104\u001a\u00020+2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0!H\u0007\u00a2\u0006\u0002\u00105J\u0010\u00104\u001a\u00020+2\u0006\u0010 \u001a\u000206H\u0007J\u0010\u00107\u001a\u00020+2\u0006\u00108\u001a\u000206H\u0007R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\bR\u001c\u0010\u0012\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\bR\u001c\u0010\u0015\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\b\u00a8\u00069"}, d2={"Lorg/locationtech/jts/algorithm/CGAlgorithms;", "", "<init>", "()V", "CLOCKWISE", "", "getCLOCKWISE$annotations", "getCLOCKWISE", "()I", "RIGHT", "getRIGHT$annotations", "getRIGHT", "COUNTERCLOCKWISE", "getCOUNTERCLOCKWISE$annotations", "getCOUNTERCLOCKWISE", "LEFT", "getLEFT$annotations", "getLEFT", "COLLINEAR", "getCOLLINEAR$annotations", "getCOLLINEAR", "STRAIGHT", "getSTRAIGHT$annotations", "getSTRAIGHT", "orientationIndex", "p1", "Lorg/locationtech/jts/geom/Coordinate;", "p2", "q", "isPointInRing", "", "p", "ring", "", "(Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)Z", "locatePointInRing", "(Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)I", "isOnLine", "pt", "isCCW", "([Lorg/locationtech/jts/geom/Coordinate;)Z", "computeOrientation", "distancePointLine", "", "A", "B", "distancePointLinePerpendicular", "line", "(Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)D", "distanceLineLine", "C", "D", "signedArea", "([Lorg/locationtech/jts/geom/Coordinate;)D", "Lorg/locationtech/jts/geom/CoordinateSequence;", "length", "pts", "kts-core"})
public final class CGAlgorithms {
    @NotNull
    public static final CGAlgorithms INSTANCE = new CGAlgorithms();
    private static final int CLOCKWISE = -1;
    private static final int RIGHT = CLOCKWISE;
    private static final int COUNTERCLOCKWISE = 1;
    private static final int LEFT = COUNTERCLOCKWISE;
    private static final int COLLINEAR;
    private static final int STRAIGHT;

    private CGAlgorithms() {
    }

    public final int getCLOCKWISE() {
        return CLOCKWISE;
    }

    @Deprecated(message="Use {@link Orientation#CLOCKWISE} instead.")
    public static /* synthetic */ void getCLOCKWISE$annotations() {
    }

    public final int getRIGHT() {
        return RIGHT;
    }

    @Deprecated(message="Use {@link Orientation#RIGHT} instead.")
    public static /* synthetic */ void getRIGHT$annotations() {
    }

    public final int getCOUNTERCLOCKWISE() {
        return COUNTERCLOCKWISE;
    }

    @Deprecated(message="Use {@link Orientation#COUNTERCLOCKWISE} instead.")
    public static /* synthetic */ void getCOUNTERCLOCKWISE$annotations() {
    }

    public final int getLEFT() {
        return LEFT;
    }

    @Deprecated(message="Use {@link Orientation#LEFT} instead.")
    public static /* synthetic */ void getLEFT$annotations() {
    }

    public final int getCOLLINEAR() {
        return COLLINEAR;
    }

    @Deprecated(message="Use {@link Orientation#COLLINEAR} instead.")
    public static /* synthetic */ void getCOLLINEAR$annotations() {
    }

    public final int getSTRAIGHT() {
        return STRAIGHT;
    }

    @Deprecated(message="Use {@link Orientation#STRAIGHT} instead.")
    public static /* synthetic */ void getSTRAIGHT$annotations() {
    }

    @Deprecated(message="Use {@link Orientation#index(Coordinate, Coordinate, Coordinate)}\n                instead.")
    public final int orientationIndex(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return CGAlgorithmsDD.orientationIndex(p1, p2, q);
    }

    @Deprecated(message="Use {@link PointLocation#isInRing(Coordinate, Coordinate[])}\n                instead.")
    public final boolean isPointInRing(@NotNull Coordinate p, @NotNull Coordinate[] ring) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        return this.locatePointInRing(p, ring) != 2;
    }

    @Deprecated(message="Use\n                {@link PointLocation#locateInRing(Coordinate, Coordinate[])}\n                instead.")
    public final int locatePointInRing(@NotNull Coordinate p, @NotNull Coordinate[] ring) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        return RayCrossingCounter.Companion.locatePointInRing(p, ring);
    }

    @Deprecated(message="Use {@link PointLocation#isOnLine(Coordinate, Coordinate[])}\n                instead.")
    public final boolean isOnLine(@Nullable Coordinate p, @NotNull Coordinate[] pt) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        LineIntersector lineIntersector = new RobustLineIntersector();
        int n = pt.length;
        for (int i = 1; i < n; ++i) {
            Coordinate p0 = pt[i - 1];
            Coordinate p1 = pt[i];
            lineIntersector.computeIntersection(p, p0, p1);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    @Deprecated(message="Use {@link Orientation#isCCW(Coordinate[])} instead.")
    public final boolean isCCW(@NotNull Coordinate[] ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        int nPts = ring.length - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 4 points, so orientation cannot be determined");
        }
        Coordinate hiPt = ring[0];
        int hiIndex = 0;
        int i = 1;
        if (i <= nPts) {
            while (true) {
                Coordinate p = ring[i];
                if (p.y > hiPt.y) {
                    hiPt = p;
                    hiIndex = i;
                }
                if (i == nPts) break;
                ++i;
            }
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (ring[iPrev].equals2D(hiPt) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (ring[iNext = (iNext + 1) % nPts].equals2D(hiPt) && iNext != hiIndex) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals2D(hiPt) || next.equals2D(hiPt) || prev.equals2D(next)) {
            return false;
        }
        int disc = this.computeOrientation(prev, hiPt, next);
        boolean isCCW = false;
        isCCW = disc == 0 ? prev.x > next.x : disc > 0;
        return isCCW;
    }

    @Deprecated(message="Use {@link Orientation#index(Coordinate, Coordinate, Coordinate)}\n                instead.")
    public final int computeOrientation(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.orientationIndex(p1, p2, q);
    }

    @Deprecated(message="Use\n                {@link Distance#pointToSegment(Coordinate, Coordinate, Coordinate)}\n                instead.")
    public final double distancePointLine(@NotNull Coordinate p, @NotNull Coordinate A, @NotNull Coordinate B) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        if (A.x == B.x && A.y == B.y) {
            return p.distance(A);
        }
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y);
        double r = ((p.x - A.x) * (B.x - A.x) + (p.y - A.y) * (B.y - A.y)) / len2;
        if (r <= 0.0) {
            return p.distance(A);
        }
        if (r >= 1.0) {
            return p.distance(B);
        }
        double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / len2;
        return Math.INSTANCE.abs(s) * Math.INSTANCE.sqrt(len2);
    }

    @Deprecated(message="Use\n                {@link Distance#pointToLinePerpendicular(Coordinate, Coordinate, Coordinate)}\n                instead.")
    public final double distancePointLinePerpendicular(@NotNull Coordinate p, @NotNull Coordinate A, @NotNull Coordinate B) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y);
        double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / len2;
        return Math.INSTANCE.abs(s) * Math.INSTANCE.sqrt(len2);
    }

    @Deprecated(message="Use\n                {@link Distance#pointToSegmentString(Coordinate, Coordinate[])}\n                instead.")
    public final double distancePointLine(@NotNull Coordinate p, @NotNull Coordinate[] line) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p.distance(line[0]);
        int n = line.length - 1;
        for (int i = 0; i < n; ++i) {
            double dist = this.distancePointLine(p, line[i], line[i + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    @Deprecated(message="Use\n                {@link Distance#segmentToSegment(Coordinate, Coordinate, Coordinate, Coordinate)}\n                instead.")
    public final double distanceLineLine(@NotNull Coordinate A, @NotNull Coordinate B, @NotNull Coordinate C, @NotNull Coordinate D) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        Intrinsics.checkNotNullParameter((Object)C, (String)"C");
        Intrinsics.checkNotNullParameter((Object)D, (String)"D");
        if (Intrinsics.areEqual((Object)A, (Object)B)) {
            return this.distancePointLine(A, C, D);
        }
        if (Intrinsics.areEqual((Object)C, (Object)D)) {
            return this.distancePointLine(D, A, B);
        }
        boolean noIntersection = false;
        if (!Envelope.Companion.intersects(A, B, C, D)) {
            noIntersection = true;
        } else {
            double denom = (B.x - A.x) * (D.y - C.y) - (B.y - A.y) * (D.x - C.x);
            if (denom == 0.0) {
                noIntersection = true;
            } else {
                double r_num = (A.y - C.y) * (D.x - C.x) - (A.x - C.x) * (D.y - C.y);
                double s_num = (A.y - C.y) * (B.x - A.x) - (A.x - C.x) * (B.y - A.y);
                double s = s_num / denom;
                double r = r_num / denom;
                if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
                    noIntersection = true;
                }
            }
        }
        return noIntersection ? MathUtil.INSTANCE.min(this.distancePointLine(A, C, D), this.distancePointLine(B, C, D), this.distancePointLine(C, A, B), this.distancePointLine(D, A, B)) : 0.0;
    }

    @Deprecated(message="Use {@link Area#ofRing(Coordinate[])} or\n                {@link Area#ofRingSigned(Coordinate[])} instead.")
    public final double signedArea(@NotNull Coordinate[] ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        double x0 = ring[0].x;
        int n = ring.length - 1;
        for (int i = 1; i < n; ++i) {
            double x = ring[i].x - x0;
            double y1 = ring[i + 1].y;
            double y2 = ring[i - 1].y;
            sum += x * (y2 - y1);
        }
        return sum / 2.0;
    }

    @Deprecated(message="Use {@link Area#ofRing(CoordinateSequence)} or\n                {@link Area#ofRingSigned(CoordinateSequence)} instead.")
    public final double signedArea(@NotNull CoordinateSequence ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        int n = ring.size();
        if (n < 3) {
            return 0.0;
        }
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        Coordinate p2 = new Coordinate();
        ring.getCoordinate(0, p1);
        ring.getCoordinate(1, p2);
        double x0 = p1.x;
        p2.x -= x0;
        double sum = 0.0;
        int n2 = n - 1;
        for (int i = 1; i < n2; ++i) {
            p0.y = p1.y;
            p1.x = p2.x;
            p1.y = p2.y;
            ring.getCoordinate(i + 1, p2);
            p2.x -= x0;
            sum += p1.x * (p0.y - p2.y);
        }
        return sum / 2.0;
    }

    @Deprecated(message="Use {@link Length#ofLine(CoordinateSequence)} instead.")
    public final double length(@NotNull CoordinateSequence pts) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        int n = pts.size();
        if (n <= 1) {
            return 0.0;
        }
        double len = 0.0;
        Coordinate p = new Coordinate();
        pts.getCoordinate(0, p);
        double x0 = p.x;
        double y0 = p.y;
        for (int i = 1; i < n; ++i) {
            pts.getCoordinate(i, p);
            double x1 = p.x;
            double y1 = p.y;
            double dx = x1 - x0;
            double dy = y1 - y0;
            len += Math.INSTANCE.sqrt(dx * dx + dy * dy);
            x0 = x1;
            y0 = y1;
        }
        return len;
    }

    static {
        STRAIGHT = COLLINEAR;
    }
}

