/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.DD;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bJ*\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013J(\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0007J8\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000bH\u0002J*\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0007R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/locationtech/jts/algorithm/CGAlgorithmsDD;", "", "<init>", "()V", "orientationIndex", "", "p1", "Lorg/locationtech/jts/geom/Coordinate;", "p2", "q", "p1x", "", "p1y", "p2x", "p2y", "qx", "qy", "signOfDet2x2", "x1", "Lorg/locationtech/jts/math/DD;", "y1", "x2", "y2", "dx1", "dy1", "dx2", "dy2", "DP_SAFE_EPSILON", "orientationIndexFilter", "pax", "pay", "pbx", "pby", "pcx", "pcy", "signum", "x", "intersection", "q1", "q2", "kts-core"})
public final class CGAlgorithmsDD {
    @NotNull
    public static final CGAlgorithmsDD INSTANCE = new CGAlgorithmsDD();
    private static final double DP_SAFE_EPSILON = 1.0E-15;

    private CGAlgorithmsDD() {
    }

    @JvmStatic
    public static final int orientationIndex(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return INSTANCE.orientationIndex(p1.x, p1.y, p2.x, p2.y, q.x, q.y);
    }

    public final int orientationIndex(double p1x, double p1y, double p2x, double p2y, double qx, double qy) {
        int index = this.orientationIndexFilter(p1x, p1y, p2x, p2y, qx, qy);
        if (index <= 1) {
            return index;
        }
        DD dx1 = DD.Companion.valueOf(p2x).selfAdd(-p1x);
        DD dy1 = DD.Companion.valueOf(p2y).selfAdd(-p1y);
        DD dx2 = DD.Companion.valueOf(qx).selfAdd(-p2x);
        DD dy2 = DD.Companion.valueOf(qy).selfAdd(-p2y);
        return dx1.selfMultiply(dy2).selfSubtract(dy1.selfMultiply(dx2)).signum();
    }

    public final int signOfDet2x2(@NotNull DD x1, @NotNull DD y1, @Nullable DD x2, @Nullable DD y2) {
        Intrinsics.checkNotNullParameter((Object)x1, (String)"x1");
        Intrinsics.checkNotNullParameter((Object)y1, (String)"y1");
        DD dD = y2;
        Intrinsics.checkNotNull((Object)dD);
        DD dD2 = x1.multiply(dD);
        DD dD3 = x2;
        Intrinsics.checkNotNull((Object)dD3);
        DD det = dD2.selfSubtract(y1.multiply(dD3));
        return det.signum();
    }

    @JvmStatic
    public static final int signOfDet2x2(double dx1, double dy1, double dx2, double dy2) {
        DD x1 = DD.Companion.valueOf(dx1);
        DD y1 = DD.Companion.valueOf(dy1);
        DD x2 = DD.Companion.valueOf(dx2);
        DD y2 = DD.Companion.valueOf(dy2);
        DD det = x1.multiply(y2).selfSubtract(y1.multiply(x2));
        return det.signum();
    }

    private final int orientationIndexFilter(double pax, double pay, double pbx, double pby, double pcx, double pcy) {
        double d;
        double detsum = 0.0;
        double detleft = (pax - pcx) * (pby - pcy);
        double detright = (pay - pcy) * (pbx - pcx);
        double det = detleft - detright;
        if (detleft > 0.0) {
            if (detright <= 0.0) {
                return this.signum(det);
            }
            d = detleft + detright;
        } else if (detleft < 0.0) {
            if (detright >= 0.0) {
                return this.signum(det);
            }
            d = -detleft - detright;
        } else {
            return this.signum(det);
        }
        detsum = d;
        double errbound = 1.0E-15 * detsum;
        return det >= errbound || -det >= errbound ? this.signum(det) : 2;
    }

    private final int signum(double x) {
        if (x > 0.0) {
            return 1;
        }
        return x < 0.0 ? -1 : 0;
    }

    @JvmStatic
    @Nullable
    public static final Coordinate intersection(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q1, @NotNull Coordinate q2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)q1, (String)"q1");
        Intrinsics.checkNotNullParameter((Object)q2, (String)"q2");
        DD px = new DD(p1.y).selfSubtract(p2.y);
        DD py = new DD(p2.x).selfSubtract(p1.x);
        DD pw = new DD(p1.x).selfMultiply(p2.y).selfSubtract(new DD(p2.x).selfMultiply(p1.y));
        DD qx = new DD(q1.y).selfSubtract(q2.y);
        DD qy = new DD(q2.x).selfSubtract(q1.x);
        DD qw = new DD(q1.x).selfMultiply(q2.y).selfSubtract(new DD(q2.x).selfMultiply(q1.y));
        DD x = py.multiply(qw).selfSubtract(qy.multiply(pw));
        DD y = qx.multiply(pw).selfSubtract(px.multiply(qw));
        DD w = px.multiply(qy).selfSubtract(qx.multiply(py));
        double xInt = x.selfDivide(w).doubleValue();
        double yInt = y.selfDivide(w).doubleValue();
        return Math.INSTANCE.isNaN(xInt) || Math.INSTANCE.isInfinite(xInt) || Math.INSTANCE.isNaN(yInt) || Math.INSTANCE.isInfinite(yInt) ? null : new Coordinate(xInt, yInt);
    }
}

