/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.MathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0007J!\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/algorithm/Distance;", "", "<init>", "()V", "segmentToSegment", "", "A", "Lorg/locationtech/jts/geom/Coordinate;", "B", "C", "D", "pointToSegmentString", "p", "line", "", "(Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)D", "pointToSegment", "pointToLinePerpendicular", "kts-core"})
@SourceDebugExtension(value={"SMAP\nDistance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Distance.kt\norg/locationtech/jts/algorithm/Distance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
public final class Distance {
    @NotNull
    public static final Distance INSTANCE = new Distance();

    private Distance() {
    }

    @JvmStatic
    public static final double segmentToSegment(@NotNull Coordinate A, @NotNull Coordinate B, @NotNull Coordinate C, @NotNull Coordinate D) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        Intrinsics.checkNotNullParameter((Object)C, (String)"C");
        Intrinsics.checkNotNullParameter((Object)D, (String)"D");
        if (Intrinsics.areEqual((Object)A, (Object)B)) {
            return Distance.pointToSegment(A, C, D);
        }
        if (Intrinsics.areEqual((Object)C, (Object)D)) {
            return Distance.pointToSegment(D, A, B);
        }
        boolean noIntersection = false;
        if (!Envelope.Companion.intersects(A, B, C, D)) {
            noIntersection = true;
        } else {
            double denom = (B.x - A.x) * (D.y - C.y) - (B.y - A.y) * (D.x - C.x);
            if (denom == 0.0) {
                noIntersection = true;
            } else {
                double r_num = (A.y - C.y) * (D.x - C.x) - (A.x - C.x) * (D.y - C.y);
                double s_num = (A.y - C.y) * (B.x - A.x) - (A.x - C.x) * (B.y - A.y);
                double s = s_num / denom;
                double r = r_num / denom;
                if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
                    noIntersection = true;
                }
            }
        }
        return noIntersection ? MathUtil.INSTANCE.min(Distance.pointToSegment(A, C, D), Distance.pointToSegment(B, C, D), Distance.pointToSegment(C, A, B), Distance.pointToSegment(D, A, B)) : 0.0;
    }

    public final double pointToSegmentString(@NotNull Coordinate p, @NotNull Coordinate[] line) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!(!(line.length == 0))) {
            boolean bl = false;
            String string = "Line array must contain at least one vertex";
            throw new IllegalArgumentException(string.toString());
        }
        double minDistance = p.distance(line[0]);
        int n = line.length - 1;
        for (int i = 0; i < n; ++i) {
            double dist = Distance.pointToSegment(p, line[i], line[i + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    @JvmStatic
    public static final double pointToSegment(@NotNull Coordinate p, @NotNull Coordinate A, @NotNull Coordinate B) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        if (A.x == B.x && A.y == B.y) {
            return p.distance(A);
        }
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y);
        double r = ((p.x - A.x) * (B.x - A.x) + (p.y - A.y) * (B.y - A.y)) / len2;
        if (r <= 0.0) {
            return p.distance(A);
        }
        if (r >= 1.0) {
            return p.distance(B);
        }
        double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / len2;
        return Math.INSTANCE.abs(s) * Math.INSTANCE.sqrt(len2);
    }

    @JvmStatic
    public static final double pointToLinePerpendicular(@NotNull Coordinate p, @NotNull Coordinate A, @NotNull Coordinate B) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y);
        double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / len2;
        return Math.INSTANCE.abs(s) * Math.INSTANCE.sqrt(len2);
    }
}

