/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.InteriorPointArea;
import org.locationtech.jts.algorithm.InteriorPointLine;
import org.locationtech.jts.algorithm.InteriorPointPoint;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/algorithm/InteriorPoint;", "", "<init>", "()V", "getInteriorPoint", "Lorg/locationtech/jts/geom/Coordinate;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "effectiveDimension", "", "EffectiveDimensionFilter", "kts-core"})
public final class InteriorPoint {
    @NotNull
    public static final InteriorPoint INSTANCE = new InteriorPoint();

    private InteriorPoint() {
    }

    @Nullable
    public final Coordinate getInteriorPoint(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        if (geom.isEmpty()) {
            return null;
        }
        Coordinate interiorPt = null;
        int dim = this.effectiveDimension(geom);
        if (dim < 0) {
            return null;
        }
        interiorPt = switch (dim) {
            case 0 -> InteriorPointPoint.Companion.getInteriorPoint(geom);
            case 1 -> InteriorPointLine.Companion.getInteriorPoint(geom);
            default -> InteriorPointArea.Companion.getInteriorPoint(geom);
        };
        return interiorPt;
    }

    private final int effectiveDimension(Geometry geom) {
        EffectiveDimensionFilter dimFilter = new EffectiveDimensionFilter();
        geom.apply(dimFilter);
        return dimFilter.getDimension();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/algorithm/InteriorPoint$EffectiveDimensionFilter;", "Lorg/locationtech/jts/geom/GeometryFilter;", "<init>", "()V", "value", "", "dimension", "getDimension", "()I", "filter", "", "elem", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    private static final class EffectiveDimensionFilter
    implements GeometryFilter {
        private int dimension = -1;

        public final int getDimension() {
            return this.dimension;
        }

        @Override
        public void filter(@Nullable Geometry elem) {
            int elemDim;
            if (elem instanceof GeometryCollection) {
                return;
            }
            Geometry geometry = elem;
            Intrinsics.checkNotNull((Object)geometry);
            if (!geometry.isEmpty() && (elemDim = elem.getDimension()) > this.dimension) {
                this.dimension = elemDim;
            }
        }
    }
}

