/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u0002\b&\u0018\u0000 L2\u00020\u0001:\u0001LB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010+\u001a\u00020,2\b\u0010&\u001a\u0004\u0018\u00010%H\u0007J\u0018\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005J&\u00100\u001a\u00020,2\b\u00101\u001a\u0004\u0018\u00010\r2\b\u00102\u001a\u0004\u0018\u00010\r2\b\u00103\u001a\u0004\u0018\u00010\rH&J.\u00100\u001a\u00020,2\b\u00102\u001a\u0004\u0018\u00010\r2\b\u00103\u001a\u0004\u0018\u00010\r2\b\u00105\u001a\u0004\u0018\u00010\r2\b\u00106\u001a\u0004\u0018\u00010\rJ0\u00107\u001a\u00020\u00052\b\u00102\u001a\u0004\u0018\u00010\r2\b\u00103\u001a\u0004\u0018\u00010\r2\b\u00108\u001a\u0004\u0018\u00010\r2\b\u00109\u001a\u0004\u0018\u00010\rH$J\b\u0010:\u001a\u00020;H\u0016J\u0006\u0010@\u001a\u00020\u0019J\u000e\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020\u0005J\b\u0010C\u001a\u00020,H\u0004J\u0010\u0010D\u001a\u00020\u00192\b\u0010E\u001a\u0004\u0018\u00010\rJ\u000e\u0010F\u001a\u00020\u00192\u0006\u0010G\u001a\u00020\u0005J\u0018\u0010H\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005J\u0016\u0010I\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005J\u0010\u0010C\u001a\u00020,2\u0006\u0010.\u001a\u00020\u0005H\u0004J\u0016\u0010J\u001a\u00020K2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001c\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R$\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0018\u001a\u00020\u00198FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R(\u0010&\u001a\u0004\u0018\u00010%2\b\u0010\u0004\u001a\u0004\u0018\u00010%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0014\u00104\u001a\u00020\u00198DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001aR\u0014\u0010<\u001a\u00020;8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020\u00198DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u001aR\u0011\u0010F\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u001a\u00a8\u0006M"}, d2={"Lorg/locationtech/jts/algorithm/LineIntersector;", "", "<init>", "()V", "value", "", "intersectionNum", "getIntersectionNum", "()I", "setIntersectionNum", "(I)V", "inputLines", "", "Lorg/locationtech/jts/geom/Coordinate;", "[[Lorg/locationtech/jts/geom/Coordinate;", "intPt", "[Lorg/locationtech/jts/geom/Coordinate;", "intLineIndex", "", "getIntLineIndex", "()[[I", "setIntLineIndex", "([[I)V", "[[I", "isProper", "", "()Z", "setProper", "(Z)V", "pa", "getPa", "()Lorg/locationtech/jts/geom/Coordinate;", "setPa", "(Lorg/locationtech/jts/geom/Coordinate;)V", "pb", "getPb", "setPb", "Lorg/locationtech/jts/geom/PrecisionModel;", "precisionModel", "getPrecisionModel", "()Lorg/locationtech/jts/geom/PrecisionModel;", "setPrecisionModel", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "setMakePrecise", "", "getEndpoint", "segmentIndex", "ptIndex", "computeIntersection", "p", "p1", "p2", "isCollinear", "p3", "p4", "computeIntersect", "q1", "q2", "toString", "", "topologySummary", "getTopologySummary", "()Ljava/lang/String;", "isEndPoint", "hasIntersection", "getIntersection", "intIndex", "computeIntLineIndex", "isIntersection", "pt", "isInteriorIntersection", "inputLineIndex", "getIntersectionAlongSegment", "getIndexAlongSegment", "getEdgeDistance", "", "Companion", "kts-core"})
public abstract class LineIntersector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int intersectionNum;
    @JvmField
    @NotNull
    protected Coordinate[][] inputLines;
    @JvmField
    @NotNull
    protected Coordinate[] intPt;
    @Nullable
    private int[][] intLineIndex;
    private boolean isProper;
    @Nullable
    private Coordinate pa;
    @Nullable
    private Coordinate pb;
    @Nullable
    private PrecisionModel precisionModel;
    public static final int DONT_INTERSECT = 0;
    public static final int DO_INTERSECT = 1;
    public static final int COLLINEAR = 2;
    public static final int NO_INTERSECTION = 0;
    public static final int POINT_INTERSECTION = 1;
    public static final int COLLINEAR_INTERSECTION = 2;

    public LineIntersector() {
        int n = 0;
        Coordinate[][] coordinateArrayArray = new Coordinate[2][];
        LineIntersector lineIntersector = this;
        while (n < 2) {
            int n2 = n++;
            coordinateArrayArray[n2] = new Coordinate[2];
        }
        lineIntersector.inputLines = coordinateArrayArray;
        this.intPt = new Coordinate[2];
        this.intPt[0] = new Coordinate();
        this.intPt[1] = new Coordinate();
        this.pa = this.intPt[0];
        this.pb = this.intPt[1];
        this.intersectionNum = 0;
    }

    public final int getIntersectionNum() {
        return this.intersectionNum;
    }

    protected final void setIntersectionNum(int n) {
        this.intersectionNum = n;
    }

    @Nullable
    protected final int[][] getIntLineIndex() {
        return this.intLineIndex;
    }

    protected final void setIntLineIndex(@Nullable int[][] nArray) {
        this.intLineIndex = nArray;
    }

    public final boolean isProper() {
        return this.hasIntersection() && this.isProper;
    }

    public final void setProper(boolean bl) {
        this.isProper = bl;
    }

    @Nullable
    protected final Coordinate getPa() {
        return this.pa;
    }

    protected final void setPa(@Nullable Coordinate coordinate) {
        this.pa = coordinate;
    }

    @Nullable
    protected final Coordinate getPb() {
        return this.pb;
    }

    protected final void setPb(@Nullable Coordinate coordinate) {
        this.pb = coordinate;
    }

    @Nullable
    public final PrecisionModel getPrecisionModel() {
        return this.precisionModel;
    }

    public final void setPrecisionModel(@Nullable PrecisionModel value) {
        this.precisionModel = value;
    }

    @Deprecated(message="use <code>setPrecisionModel</code> instead")
    public final void setMakePrecise(@Nullable PrecisionModel precisionModel) {
        this.setPrecisionModel(precisionModel);
    }

    @Nullable
    public final Coordinate getEndpoint(int segmentIndex, int ptIndex) {
        return this.inputLines[segmentIndex][ptIndex];
    }

    public abstract void computeIntersection(@Nullable Coordinate var1, @Nullable Coordinate var2, @Nullable Coordinate var3);

    protected final boolean isCollinear() {
        return this.intersectionNum == 2;
    }

    public final void computeIntersection(@Nullable Coordinate p1, @Nullable Coordinate p2, @Nullable Coordinate p3, @Nullable Coordinate p4) {
        this.inputLines[0][0] = p1;
        this.inputLines[0][1] = p2;
        this.inputLines[1][0] = p3;
        this.inputLines[1][1] = p4;
        this.intersectionNum = this.computeIntersect(p1, p2, p3, p4);
    }

    protected abstract int computeIntersect(@Nullable Coordinate var1, @Nullable Coordinate var2, @Nullable Coordinate var3, @Nullable Coordinate var4);

    @NotNull
    public String toString() {
        Coordinate coordinate = this.inputLines[0][0];
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = this.inputLines[0][1];
        Intrinsics.checkNotNull((Object)coordinate2);
        String string = WKTWriter.Companion.toLineString(coordinate, coordinate2);
        Coordinate coordinate3 = this.inputLines[1][0];
        Intrinsics.checkNotNull((Object)coordinate3);
        Coordinate coordinate4 = this.inputLines[1][1];
        Intrinsics.checkNotNull((Object)coordinate4);
        return string + " - " + WKTWriter.Companion.toLineString(coordinate3, coordinate4) + this.getTopologySummary();
    }

    private final String getTopologySummary() {
        StringBuilder catBuilder = new StringBuilder();
        if (this.isEndPoint()) {
            catBuilder.append(" endpoint");
        }
        if (this.isProper()) {
            catBuilder.append(" proper");
        }
        if (this.isCollinear()) {
            catBuilder.append(" collinear");
        }
        String string = catBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected final boolean isEndPoint() {
        return this.hasIntersection() && !this.isProper();
    }

    public final boolean hasIntersection() {
        return this.intersectionNum != 0;
    }

    @NotNull
    public final Coordinate getIntersection(int intIndex) {
        Coordinate coordinate = this.intPt[intIndex];
        Intrinsics.checkNotNull((Object)coordinate);
        return coordinate;
    }

    protected final void computeIntLineIndex() {
        if (this.intLineIndex == null) {
            int n = 0;
            int[][] nArrayArray = new int[2][];
            LineIntersector lineIntersector = this;
            while (n < 2) {
                int n2 = n++;
                nArrayArray[n2] = new int[2];
            }
            lineIntersector.intLineIndex = nArrayArray;
            this.computeIntLineIndex(0);
            this.computeIntLineIndex(1);
        }
    }

    public final boolean isIntersection(@Nullable Coordinate pt) {
        int n = this.intersectionNum;
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate = this.intPt[i];
            Intrinsics.checkNotNull((Object)coordinate);
            Coordinate coordinate2 = pt;
            Intrinsics.checkNotNull((Object)coordinate2);
            if (!coordinate.equals2D(coordinate2)) continue;
            return true;
        }
        return false;
    }

    public final boolean isInteriorIntersection() {
        if (this.isInteriorIntersection(0)) {
            return true;
        }
        return this.isInteriorIntersection(1);
    }

    public final boolean isInteriorIntersection(int inputLineIndex) {
        int n = this.intersectionNum;
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate = this.intPt[i];
            Intrinsics.checkNotNull((Object)coordinate);
            Coordinate coordinate2 = this.inputLines[inputLineIndex][0];
            Intrinsics.checkNotNull((Object)coordinate2);
            if (coordinate.equals2D(coordinate2)) continue;
            Coordinate coordinate3 = this.intPt[i];
            Intrinsics.checkNotNull((Object)coordinate3);
            Coordinate coordinate4 = this.inputLines[inputLineIndex][1];
            Intrinsics.checkNotNull((Object)coordinate4);
            if (coordinate3.equals2D(coordinate4)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final Coordinate getIntersectionAlongSegment(int segmentIndex, int intIndex) {
        this.computeIntLineIndex();
        Intrinsics.checkNotNull((Object)this.intLineIndex);
        return this.intPt[this.intLineIndex[segmentIndex][intIndex]];
    }

    public final int getIndexAlongSegment(int segmentIndex, int intIndex) {
        this.computeIntLineIndex();
        Intrinsics.checkNotNull((Object)this.intLineIndex);
        return this.intLineIndex[segmentIndex][intIndex];
    }

    protected final void computeIntLineIndex(int segmentIndex) {
        double dist1;
        double dist0 = this.getEdgeDistance(segmentIndex, 0);
        if (dist0 > (dist1 = this.getEdgeDistance(segmentIndex, 1))) {
            Intrinsics.checkNotNull((Object)this.intLineIndex);
            this.intLineIndex[segmentIndex][0] = 0;
            Intrinsics.checkNotNull((Object)this.intLineIndex);
            this.intLineIndex[segmentIndex][1] = 1;
        } else {
            Intrinsics.checkNotNull((Object)this.intLineIndex);
            this.intLineIndex[segmentIndex][0] = 1;
            Intrinsics.checkNotNull((Object)this.intLineIndex);
            this.intLineIndex[segmentIndex][1] = 0;
        }
    }

    public final double getEdgeDistance(int segmentIndex, int intIndex) {
        return Companion.computeEdgeDistance(this.intPt[intIndex], this.inputLines[segmentIndex][0], this.inputLines[segmentIndex][1]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eJ \u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/algorithm/LineIntersector$Companion;", "", "<init>", "()V", "DONT_INTERSECT", "", "DO_INTERSECT", "COLLINEAR", "NO_INTERSECTION", "POINT_INTERSECTION", "COLLINEAR_INTERSECTION", "computeEdgeDistance", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "p0", "p1", "nonRobustComputeEdgeDistance", "p2", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final double computeEdgeDistance(@Nullable Coordinate p, @Nullable Coordinate p0, @Nullable Coordinate p1) {
            Coordinate coordinate = p1;
            Intrinsics.checkNotNull((Object)coordinate);
            double d = coordinate.x;
            Coordinate coordinate2 = p0;
            Intrinsics.checkNotNull((Object)coordinate2);
            double dx = Math.INSTANCE.abs(d - coordinate2.x);
            double dy = Math.INSTANCE.abs(p1.y - p0.y);
            double dist = -1.0;
            Coordinate coordinate3 = p;
            Intrinsics.checkNotNull((Object)coordinate3);
            if (Intrinsics.areEqual((Object)coordinate3, (Object)p0)) {
                dist = 0.0;
            } else if (Intrinsics.areEqual((Object)p, (Object)p1)) {
                dist = dx > dy ? dx : dy;
            } else {
                double pdx = Math.INSTANCE.abs(p.x - p0.x);
                double pdy = Math.INSTANCE.abs(p.y - p0.y);
                dist = dx > dy ? pdx : pdy;
                if (dist == 0.0 && !Intrinsics.areEqual((Object)p, (Object)p0)) {
                    dist = java.lang.Math.max(pdx, pdy);
                }
            }
            Assert.INSTANCE.isTrue(!(dist == 0.0) || Intrinsics.areEqual((Object)p, (Object)p0), "Bad distance calculation");
            return dist;
        }

        public final double nonRobustComputeEdgeDistance(@NotNull Coordinate p, @NotNull Coordinate p1, @Nullable Coordinate p2) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            double dx = p.x - p1.x;
            double dy = p.y - p1.y;
            double dist = Math.INSTANCE.sqrt(dx * dx + dy * dy);
            Assert.INSTANCE.isTrue(!(dist == 0.0) || Intrinsics.areEqual((Object)p, (Object)p1), "Invalid distance calculation");
            return dist;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

