/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0019\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u001a\u001a\u00020\fJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0019\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/algorithm/MinimumBoundingCircle;", "", "input", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "extremalPts", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "centre", "radius", "", "circle", "getCircle", "()Lorg/locationtech/jts/geom/Geometry;", "maximumDiameter", "getMaximumDiameter", "farthestPoints", "getFarthestPoints", "diameter", "getDiameter", "extremalPoints", "getExtremalPoints", "()[Lorg/locationtech/jts/geom/Coordinate;", "getCentre", "getRadius", "computeCentre", "", "compute", "computeCirclePoints", "Companion", "kts-core"})
public final class MinimumBoundingCircle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry input;
    @Nullable
    private Coordinate[] extremalPts;
    @Nullable
    private Coordinate centre;
    private double radius;

    public MinimumBoundingCircle(@NotNull Geometry input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
    }

    @NotNull
    public final Geometry getCircle() {
        this.compute();
        if (this.centre == null) {
            return GeometryFactory.createPolygon$default(this.input.getFactory(), null, null, 3, null);
        }
        Point centrePoint = this.input.getFactory().createPoint(this.centre);
        return this.radius == 0.0 ? (Geometry)centrePoint : centrePoint.buffer(this.radius);
    }

    @NotNull
    public final Geometry getMaximumDiameter() {
        this.compute();
        Intrinsics.checkNotNull((Object)this.extremalPts);
        return switch (this.extremalPts.length) {
            case 0 -> GeometryFactory.createLineString$default(this.input.getFactory(), null, 1, null);
            case 1 -> this.input.getFactory().createPoint(this.centre);
            case 2 -> {
                GeometryFactory v1 = this.input.getFactory();
                Coordinate[] var1_1 = new Coordinate[2];
                Intrinsics.checkNotNull((Object)this.extremalPts);
                var1_1[0] = this.extremalPts[0];
                Intrinsics.checkNotNull((Object)this.extremalPts);
                var1_1[1] = this.extremalPts[1];
                yield v1.createLineString(var1_1);
            }
            default -> {
                Intrinsics.checkNotNull((Object)this.extremalPts);
                Coordinate[] maxDiameter = MinimumBoundingCircle.Companion.farthestPoints(this.extremalPts);
                yield this.input.getFactory().createLineString(maxDiameter);
            }
        };
    }

    @Deprecated(message="use #getMaximumDiameter()")
    @NotNull
    public final Geometry getFarthestPoints() {
        return this.getMaximumDiameter();
    }

    @NotNull
    public final Geometry getDiameter() {
        this.compute();
        Intrinsics.checkNotNull((Object)this.extremalPts);
        switch (this.extremalPts.length) {
            case 0: {
                return GeometryFactory.createLineString$default(this.input.getFactory(), null, 1, null);
            }
            case 1: {
                return this.input.getFactory().createPoint(this.centre);
            }
        }
        Intrinsics.checkNotNull((Object)this.extremalPts);
        Coordinate p0 = this.extremalPts[0];
        Intrinsics.checkNotNull((Object)this.extremalPts);
        Coordinate p1 = this.extremalPts[1];
        Coordinate[] coordinateArray = new Coordinate[]{p0, p1};
        return this.input.getFactory().createLineString(coordinateArray);
    }

    @Nullable
    public final Coordinate[] getExtremalPoints() {
        this.compute();
        return this.extremalPts;
    }

    @Nullable
    public final Coordinate getCentre() {
        this.compute();
        return this.centre;
    }

    public final double getRadius() {
        this.compute();
        return this.radius;
    }

    private final void computeCentre() {
        Intrinsics.checkNotNull((Object)this.extremalPts);
        switch (this.extremalPts.length) {
            case 0: {
                this.centre = null;
                break;
            }
            case 1: {
                Intrinsics.checkNotNull((Object)this.extremalPts);
                this.centre = this.extremalPts[0];
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)this.extremalPts);
                double d = this.extremalPts[0].x;
                Intrinsics.checkNotNull((Object)this.extremalPts);
                double d2 = (d + this.extremalPts[1].x) / 2.0;
                Intrinsics.checkNotNull((Object)this.extremalPts);
                double d3 = this.extremalPts[0].y;
                Intrinsics.checkNotNull((Object)this.extremalPts);
                this.centre = new Coordinate(d2, (d3 + this.extremalPts[1].y) / 2.0);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)this.extremalPts);
                Coordinate coordinate = this.extremalPts[0];
                Intrinsics.checkNotNull((Object)this.extremalPts);
                Coordinate coordinate2 = this.extremalPts[1];
                Intrinsics.checkNotNull((Object)this.extremalPts);
                this.centre = Triangle.Companion.circumcentre(coordinate, coordinate2, this.extremalPts[2]);
            }
        }
    }

    private final void compute() {
        if (this.extremalPts != null) {
            return;
        }
        this.computeCirclePoints();
        this.computeCentre();
        if (this.centre != null) {
            Coordinate coordinate = this.centre;
            Intrinsics.checkNotNull((Object)coordinate);
            Intrinsics.checkNotNull((Object)this.extremalPts);
            this.radius = coordinate.distance(this.extremalPts[0]);
        }
    }

    private final void computeCirclePoints() {
        Coordinate[] hullPts;
        Geometry convexHull;
        if (this.input.isEmpty()) {
            this.extremalPts = new Coordinate[0];
            return;
        }
        if (this.input.getNumPoints() == 1) {
            Coordinate[] pts = this.input.getCoordinates();
            Coordinate[] coordinateArray = new Coordinate[1];
            Intrinsics.checkNotNull((Object)pts);
            coordinateArray[0] = new Coordinate(pts[0]);
            this.extremalPts = coordinateArray;
            return;
        }
        Geometry geometry = convexHull = this.input.convexHull();
        Intrinsics.checkNotNull((Object)geometry);
        Coordinate[] pts = hullPts = geometry.getCoordinates();
        Intrinsics.checkNotNull((Object)hullPts);
        if (hullPts[0].equals2D(hullPts[hullPts.length - 1])) {
            Object[] p = new Coordinate[hullPts.length - 1];
            CoordinateArrays.INSTANCE.copyDeep(hullPts, 0, (Coordinate[])p, 0, hullPts.length - 1);
            pts = (Coordinate[])ArraysKt.requireNoNulls((Object[])p);
        }
        Intrinsics.checkNotNull((Object)pts);
        if (pts.length <= 2) {
            this.extremalPts = CoordinateArrays.copyDeep(pts);
            return;
        }
        Coordinate P = MinimumBoundingCircle.Companion.lowestPoint(pts);
        Coordinate Q = MinimumBoundingCircle.Companion.pointWitMinAngleWithX(pts, P);
        int n = pts.length;
        for (int i = 0; i < n; ++i) {
            Coordinate R;
            Coordinate coordinate = R = MinimumBoundingCircle.Companion.pointWithMinAngleWithSegment(pts, P, Q);
            Intrinsics.checkNotNull((Object)coordinate);
            Coordinate coordinate2 = Q;
            Intrinsics.checkNotNull((Object)coordinate2);
            if (Angle.INSTANCE.isObtuse(P, coordinate, coordinate2)) {
                Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(P), new Coordinate(Q)};
                this.extremalPts = coordinateArray;
                return;
            }
            if (Angle.INSTANCE.isObtuse(R, P, Q)) {
                P = R;
                continue;
            }
            if (Angle.INSTANCE.isObtuse(R, Q, P)) {
                Q = R;
                continue;
            }
            Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(P), new Coordinate(Q), new Coordinate(R)};
            this.extremalPts = coordinateArray;
            return;
        }
        Assert.shouldNeverReachHere("Logic failure in Minimum Bounding Circle algorithm!");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\t\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\rJ3\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/algorithm/MinimumBoundingCircle$Companion;", "", "<init>", "()V", "farthestPoints", "", "Lorg/locationtech/jts/geom/Coordinate;", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "lowestPoint", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Coordinate;", "pointWitMinAngleWithX", "P", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Coordinate;", "pointWithMinAngleWithSegment", "Q", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Coordinate[] farthestPoints(Coordinate[] pts) {
            Coordinate[] coordinateArray;
            double dist01 = pts[0].distance(pts[1]);
            double dist12 = pts[1].distance(pts[2]);
            double dist20 = pts[2].distance(pts[0]);
            if (dist01 >= dist12 && dist01 >= dist20) {
                Coordinate[] coordinateArray2 = new Coordinate[]{pts[0], pts[1]};
                return coordinateArray2;
            }
            if (dist12 >= dist01 && dist12 >= dist20) {
                Coordinate[] coordinateArray3 = new Coordinate[]{pts[1], pts[2]};
                coordinateArray = coordinateArray3;
            } else {
                Coordinate[] coordinateArray4 = new Coordinate[]{pts[2], pts[0]};
                coordinateArray = coordinateArray4;
            }
            return coordinateArray;
        }

        private final Coordinate lowestPoint(Coordinate[] pts) {
            Coordinate min = pts[0];
            int n = pts.length;
            for (int i = 1; i < n; ++i) {
                if (!(pts[i].y < min.y)) continue;
                min = pts[i];
            }
            return min;
        }

        private final Coordinate pointWitMinAngleWithX(Coordinate[] pts, Coordinate P) {
            double minSin = Double.MAX_VALUE;
            Coordinate minAngPt = null;
            for (Coordinate p : pts) {
                double len;
                double sin;
                if (p == P) continue;
                double dx = p.x - P.x;
                double dy = p.y - P.y;
                if (dy < 0.0) {
                    dy = -dy;
                }
                if (!((sin = dy / (len = Math.INSTANCE.sqrt(dx * dx + dy * dy))) < minSin)) continue;
                minSin = sin;
                minAngPt = p;
            }
            return minAngPt;
        }

        private final Coordinate pointWithMinAngleWithSegment(Coordinate[] pts, Coordinate P, Coordinate Q) {
            double minAng = Double.MAX_VALUE;
            Coordinate minAngPt = null;
            Intrinsics.checkNotNull((Object)pts);
            for (Coordinate p : pts) {
                if (p == P || p == Q) continue;
                Coordinate coordinate = P;
                Intrinsics.checkNotNull((Object)coordinate);
                Coordinate coordinate2 = Q;
                Intrinsics.checkNotNull((Object)coordinate2);
                double ang = Angle.INSTANCE.angleBetween(coordinate, p, coordinate2);
                if (!(ang < minAng)) continue;
                minAng = ang;
                minAngPt = p;
            }
            return minAngPt;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

