/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 -2\u00020\u0001:\u0001-B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u001d\u0010#\u001a\u00020 2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010%J-\u0010&\u001a\u00020\u00102\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010*\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lorg/locationtech/jts/algorithm/MinimumDiameter;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "isConvex", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Z)V", "convexHullPts", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "minBaseSeg", "Lorg/locationtech/jts/geom/LineSegment;", "minWidthPt", "minPtIndex", "", "minWidth", "", "length", "getLength", "()D", "widthCoordinate", "getWidthCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "supportingSegment", "Lorg/locationtech/jts/geom/LineString;", "getSupportingSegment", "()Lorg/locationtech/jts/geom/LineString;", "diameter", "getDiameter", "computeMinimumDiameter", "", "computeWidthConvex", "convexGeom", "computeConvexRingMinDiameter", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)V", "findMaxPerpDistance", "seg", "startIndex", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/LineSegment;I)I", "minimumRectangle", "getMinimumRectangle", "()Lorg/locationtech/jts/geom/Geometry;", "Companion", "kts-core"})
public final class MinimumDiameter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeom;
    private final boolean isConvex;
    @Nullable
    private Coordinate[] convexHullPts;
    @Nullable
    private LineSegment minBaseSeg;
    @Nullable
    private Coordinate minWidthPt;
    private int minPtIndex;
    private double minWidth;

    @JvmOverloads
    public MinimumDiameter(@NotNull Geometry inputGeom, boolean isConvex) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this.inputGeom = inputGeom;
        this.isConvex = isConvex;
        this.minBaseSeg = new LineSegment(null, null, 3, null);
    }

    public /* synthetic */ MinimumDiameter(Geometry geometry, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(geometry, bl);
    }

    public final double getLength() {
        this.computeMinimumDiameter();
        return this.minWidth;
    }

    @Nullable
    public final Coordinate getWidthCoordinate() {
        this.computeMinimumDiameter();
        return this.minWidthPt;
    }

    @NotNull
    public final LineString getSupportingSegment() {
        this.computeMinimumDiameter();
        GeometryFactory geometryFactory = this.inputGeom.getFactory();
        Coordinate[] coordinateArray = new Coordinate[2];
        LineSegment lineSegment = this.minBaseSeg;
        Intrinsics.checkNotNull((Object)lineSegment);
        coordinateArray[0] = lineSegment.p0;
        LineSegment lineSegment2 = this.minBaseSeg;
        Intrinsics.checkNotNull((Object)lineSegment2);
        coordinateArray[1] = lineSegment2.p1;
        return geometryFactory.createLineString(coordinateArray);
    }

    @NotNull
    public final LineString getDiameter() {
        this.computeMinimumDiameter();
        if (this.minWidthPt == null) {
            return GeometryFactory.createLineString$default(this.inputGeom.getFactory(), null, 1, null);
        }
        LineSegment lineSegment = this.minBaseSeg;
        Intrinsics.checkNotNull((Object)lineSegment);
        Coordinate coordinate = this.minWidthPt;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate basePt = lineSegment.project(coordinate);
        GeometryFactory geometryFactory = this.inputGeom.getFactory();
        Coordinate[] coordinateArray = new Coordinate[2];
        coordinateArray[0] = basePt;
        Intrinsics.checkNotNull((Object)this.minWidthPt);
        return geometryFactory.createLineString(coordinateArray);
    }

    private final void computeMinimumDiameter() {
        if (this.minWidthPt != null) {
            return;
        }
        if (this.isConvex) {
            this.computeWidthConvex(this.inputGeom);
        } else {
            Geometry convexGeom = new ConvexHull(this.inputGeom).getConvexHull();
            this.computeWidthConvex(convexGeom);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void computeWidthConvex(Geometry convexGeom) {
        if (convexGeom instanceof Polygon) {
            LinearRing linearRing = ((Polygon)convexGeom).getExteriorRing();
            Intrinsics.checkNotNull((Object)linearRing);
            this.convexHullPts = linearRing.getCoordinates();
        } else {
            this.convexHullPts = convexGeom.getCoordinates();
        }
        Intrinsics.checkNotNull((Object)this.convexHullPts);
        if (this.convexHullPts.length == 0) {
            this.minWidth = 0.0;
            this.minWidthPt = null;
            this.minBaseSeg = null;
            return;
        }
        Intrinsics.checkNotNull((Object)this.convexHullPts);
        if (this.convexHullPts.length == 1) {
            this.minWidth = 0.0;
            Intrinsics.checkNotNull((Object)this.convexHullPts);
            this.minWidthPt = this.convexHullPts[0];
            Intrinsics.checkNotNull((Object)this.minBaseSeg);
            Intrinsics.checkNotNull((Object)this.convexHullPts);
            this.minBaseSeg.p0 = this.convexHullPts[0];
            Intrinsics.checkNotNull((Object)this.minBaseSeg);
            Intrinsics.checkNotNull((Object)this.convexHullPts);
            this.minBaseSeg.p1 = this.convexHullPts[0];
            return;
        }
        Intrinsics.checkNotNull((Object)this.convexHullPts);
        if (this.convexHullPts.length != 2) {
            Intrinsics.checkNotNull((Object)this.convexHullPts);
            if (this.convexHullPts.length != 3) {
                this.computeConvexRingMinDiameter(this.convexHullPts);
                return;
            }
        }
        this.minWidth = 0.0;
        Intrinsics.checkNotNull((Object)this.convexHullPts);
        this.minWidthPt = this.convexHullPts[0];
        Intrinsics.checkNotNull((Object)this.minBaseSeg);
        Intrinsics.checkNotNull((Object)this.convexHullPts);
        this.minBaseSeg.p0 = this.convexHullPts[0];
        Intrinsics.checkNotNull((Object)this.minBaseSeg);
        Intrinsics.checkNotNull((Object)this.convexHullPts);
        this.minBaseSeg.p1 = this.convexHullPts[1];
    }

    private final void computeConvexRingMinDiameter(Coordinate[] pts) {
        this.minWidth = Double.MAX_VALUE;
        int currMaxIndex = 1;
        LineSegment seg = new LineSegment(null, null, 3, null);
        Intrinsics.checkNotNull((Object)pts);
        int n = pts.length - 1;
        for (int i = 0; i < n; ++i) {
            seg.p0 = pts[i];
            seg.p1 = pts[i + 1];
            currMaxIndex = this.findMaxPerpDistance(pts, seg, currMaxIndex);
        }
    }

    private final int findMaxPerpDistance(Coordinate[] pts, LineSegment seg, int startIndex) {
        int maxIndex;
        double maxPerpDistance;
        Intrinsics.checkNotNull((Object)pts);
        double nextPerpDistance = maxPerpDistance = seg.distancePerpendicular(pts[startIndex]);
        int nextIndex = maxIndex = startIndex;
        while (nextPerpDistance >= maxPerpDistance) {
            maxPerpDistance = nextPerpDistance;
            maxIndex = nextIndex;
            if ((nextIndex = MinimumDiameter.Companion.nextIndex(pts, maxIndex)) == startIndex) break;
            nextPerpDistance = seg.distancePerpendicular(pts[nextIndex]);
        }
        if (maxPerpDistance < this.minWidth) {
            this.minPtIndex = maxIndex;
            this.minWidth = maxPerpDistance;
            this.minWidthPt = pts[this.minPtIndex];
            this.minBaseSeg = new LineSegment(seg);
        }
        return maxIndex;
    }

    @NotNull
    public final Geometry getMinimumRectangle() {
        this.computeMinimumDiameter();
        if (this.minWidth == 0.0) {
            Geometry geometry;
            LineSegment lineSegment = this.minBaseSeg;
            Intrinsics.checkNotNull((Object)lineSegment);
            Coordinate coordinate = lineSegment.p0;
            LineSegment lineSegment2 = this.minBaseSeg;
            Intrinsics.checkNotNull((Object)lineSegment2);
            if (coordinate.equals2D(lineSegment2.p1)) {
                GeometryFactory geometryFactory = this.inputGeom.getFactory();
                LineSegment lineSegment3 = this.minBaseSeg;
                Intrinsics.checkNotNull((Object)lineSegment3);
                geometry = geometryFactory.createPoint(lineSegment3.p0);
            } else {
                geometry = MinimumDiameter.Companion.computeMaximumLine(this.convexHullPts, this.inputGeom.getFactory());
            }
            return geometry;
        }
        LineSegment lineSegment = this.minBaseSeg;
        Intrinsics.checkNotNull((Object)lineSegment);
        double d = lineSegment.p1.x;
        LineSegment lineSegment4 = this.minBaseSeg;
        Intrinsics.checkNotNull((Object)lineSegment4);
        double dx = d - lineSegment4.p0.x;
        LineSegment lineSegment5 = this.minBaseSeg;
        Intrinsics.checkNotNull((Object)lineSegment5);
        double d2 = lineSegment5.p1.y;
        LineSegment lineSegment6 = this.minBaseSeg;
        Intrinsics.checkNotNull((Object)lineSegment6);
        double dy = d2 - lineSegment6.p0.y;
        double minPara = Double.MAX_VALUE;
        double maxPara = -1.7976931348623157E308;
        double minPerp = Double.MAX_VALUE;
        double maxPerp = -1.7976931348623157E308;
        Intrinsics.checkNotNull((Object)this.convexHullPts);
        int n = this.convexHullPts.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.convexHullPts);
            double paraC = MinimumDiameter.Companion.computeC(dx, dy, this.convexHullPts[i]);
            if (paraC > maxPara) {
                maxPara = paraC;
            }
            if (paraC < minPara) {
                minPara = paraC;
            }
            double d3 = -dy;
            Intrinsics.checkNotNull((Object)this.convexHullPts);
            double perpC = MinimumDiameter.Companion.computeC(d3, dx, this.convexHullPts[i]);
            if (perpC > maxPerp) {
                maxPerp = perpC;
            }
            if (!(perpC < minPerp)) continue;
            minPerp = perpC;
        }
        LineSegment maxPerpLine = MinimumDiameter.Companion.computeSegmentForLine(-dx, -dy, maxPerp);
        LineSegment minPerpLine = MinimumDiameter.Companion.computeSegmentForLine(-dx, -dy, minPerp);
        LineSegment maxParaLine = MinimumDiameter.Companion.computeSegmentForLine(-dy, dx, maxPara);
        LineSegment minParaLine = MinimumDiameter.Companion.computeSegmentForLine(-dy, dx, minPara);
        Coordinate p0 = maxParaLine.lineIntersection(maxPerpLine);
        Coordinate p1 = minParaLine.lineIntersection(maxPerpLine);
        Coordinate p2 = minParaLine.lineIntersection(minPerpLine);
        Coordinate p3 = maxParaLine.lineIntersection(minPerpLine);
        Coordinate[] coordinateArray = new Coordinate[]{p0, p1, p2, p3, p0};
        LinearRing shell = this.inputGeom.getFactory().createLinearRing(coordinateArray);
        return GeometryFactory.createPolygon$default(this.inputGeom.getFactory(), shell, null, 2, null);
    }

    @JvmOverloads
    public MinimumDiameter(@NotNull Geometry inputGeom) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this(inputGeom, false, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Geometry getMinimumRectangle(@NotNull Geometry geom) {
        return Companion.getMinimumRectangle(geom);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J%\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u00020\u00102\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/algorithm/MinimumDiameter$Companion;", "", "<init>", "()V", "getMinimumRectangle", "Lorg/locationtech/jts/geom/Geometry;", "geom", "getMinimumDiameter", "nextIndex", "", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "index", "([Lorg/locationtech/jts/geom/Coordinate;I)I", "computeMaximumLine", "Lorg/locationtech/jts/geom/LineString;", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/GeometryFactory;)Lorg/locationtech/jts/geom/LineString;", "computeC", "", "a", "b", "p", "computeSegmentForLine", "Lorg/locationtech/jts/geom/LineSegment;", "c", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geometry getMinimumRectangle(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            return new MinimumDiameter(geom, false, 2, null).getMinimumRectangle();
        }

        @NotNull
        public final Geometry getMinimumDiameter(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            return new MinimumDiameter(geom, false, 2, null).getDiameter();
        }

        private final int nextIndex(Coordinate[] pts, int index) {
            int index2 = index;
            Intrinsics.checkNotNull((Object)pts);
            if (++index2 >= pts.length) {
                index2 = 0;
            }
            return index2;
        }

        private final LineString computeMaximumLine(Coordinate[] pts, GeometryFactory factory) {
            Coordinate ptMinX = null;
            Coordinate ptMaxX = null;
            Coordinate ptMinY = null;
            Coordinate ptMaxY = null;
            Intrinsics.checkNotNull((Object)pts);
            for (Coordinate p : pts) {
                if (ptMinX == null || p.x < ptMinX.x) {
                    ptMinX = p;
                }
                if (ptMaxX == null || p.x > ptMaxX.x) {
                    ptMaxX = p;
                }
                if (ptMinY == null || p.y < ptMinY.y) {
                    ptMinY = p;
                }
                if (ptMaxY != null && !(p.y > ptMaxY.y)) continue;
                ptMaxY = p;
            }
            Coordinate p0 = ptMinX;
            Coordinate p1 = ptMaxX;
            Coordinate coordinate = p0;
            Intrinsics.checkNotNull(coordinate);
            double d = coordinate.x;
            Coordinate coordinate2 = p1;
            Intrinsics.checkNotNull(coordinate2);
            if (d == coordinate2.x) {
                p0 = ptMinY;
                p1 = ptMaxY;
            }
            Coordinate[] coordinateArray = new Coordinate[2];
            Coordinate coordinate3 = p0;
            Intrinsics.checkNotNull((Object)coordinate3);
            coordinateArray[0] = coordinate3.copy();
            Coordinate coordinate4 = p1;
            Intrinsics.checkNotNull((Object)coordinate4);
            coordinateArray[1] = coordinate4.copy();
            return factory.createLineString(coordinateArray);
        }

        private final double computeC(double a, double b, Coordinate p) {
            Coordinate coordinate = p;
            Intrinsics.checkNotNull((Object)coordinate);
            return a * coordinate.y - b * p.x;
        }

        private final LineSegment computeSegmentForLine(double a, double b, double c) {
            Coordinate p0 = null;
            Coordinate p1 = null;
            if (Math.abs(b) > Math.abs(a)) {
                p0 = new Coordinate(0.0, c / b);
                p1 = new Coordinate(1.0, c / b - a / b);
            } else {
                p0 = new Coordinate(c / a, 0.0);
                p1 = new Coordinate(c / a - b / a, 1.0);
            }
            return new LineSegment(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

