/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0007J\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0007J\u001b\u0010\u0016\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/algorithm/Orientation;", "", "<init>", "()V", "CLOCKWISE", "", "RIGHT", "COUNTERCLOCKWISE", "LEFT", "COLLINEAR", "STRAIGHT", "index", "p1", "Lorg/locationtech/jts/geom/Coordinate;", "p2", "q", "isCCW", "", "ring", "", "([Lorg/locationtech/jts/geom/Coordinate;)Z", "Lorg/locationtech/jts/geom/CoordinateSequence;", "isCCWArea", "kts-core"})
public final class Orientation {
    @NotNull
    public static final Orientation INSTANCE = new Orientation();
    public static final int CLOCKWISE = -1;
    public static final int RIGHT = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int LEFT = 1;
    public static final int COLLINEAR = 0;
    public static final int STRAIGHT = 0;

    private Orientation() {
    }

    @JvmStatic
    public static final int index(@Nullable Coordinate p1, @Nullable Coordinate p2, @Nullable Coordinate q) {
        Coordinate coordinate = p1;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = p2;
        Intrinsics.checkNotNull((Object)coordinate2);
        Coordinate coordinate3 = q;
        Intrinsics.checkNotNull((Object)coordinate3);
        return CGAlgorithmsDD.orientationIndex(coordinate, coordinate2, coordinate3);
    }

    @JvmStatic
    public static final boolean isCCW(@NotNull Coordinate[] ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        return Orientation.isCCW(new CoordinateArraySequence(ring, 2, 0));
    }

    @JvmStatic
    public static final boolean isCCW(@NotNull CoordinateSequence ring) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        int nPts = ring.size() - 1;
        if (nPts < 3) {
            return false;
        }
        Coordinate upHiPt = ring.getCoordinate(0);
        double prevY = upHiPt.y;
        Coordinate upLowPt = null;
        int iUpHi = 0;
        int i = 1;
        if (i <= nPts) {
            while (true) {
                double py;
                if ((py = ring.getOrdinate(i, 1)) > prevY && py >= upHiPt.y) {
                    upHiPt = ring.getCoordinate(i);
                    iUpHi = i;
                    upLowPt = ring.getCoordinate(i - 1);
                }
                prevY = py;
                if (i == nPts) break;
                ++i;
            }
        }
        if (iUpHi == 0) {
            return false;
        }
        int iDownLow = iUpHi;
        while ((iDownLow = (iDownLow + 1) % nPts) != iUpHi && ring.getOrdinate(iDownLow, 1) == upHiPt.y) {
        }
        Coordinate downLowPt = ring.getCoordinate(iDownLow);
        int iDownHi = iDownLow > 0 ? iDownLow - 1 : nPts - 1;
        Coordinate downHiPt = ring.getCoordinate(iDownHi);
        if (upHiPt.equals2D(downHiPt)) {
            Coordinate coordinate = upLowPt;
            Intrinsics.checkNotNull((Object)coordinate);
            if (coordinate.equals2D(upHiPt) || downLowPt.equals2D(upHiPt) || upLowPt.equals2D(downLowPt)) {
                return false;
            }
            int index = Orientation.index(upLowPt, upHiPt, downLowPt);
            bl = index == 1;
        } else {
            double delX = downHiPt.x - upHiPt.x;
            bl = delX < 0.0;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isCCWArea(@NotNull Coordinate[] ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        return Area.ofRingSigned(ring) < 0.0;
    }
}

