/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0007J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0007\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/algorithm/RobustDeterminant;", "", "<init>", "()V", "signOfDet2x2", "", "x1", "", "y1", "x2", "y2", "orientationIndex", "p1", "Lorg/locationtech/jts/geom/Coordinate;", "p2", "q", "kts-core"})
public final class RobustDeterminant {
    @NotNull
    public static final RobustDeterminant INSTANCE = new RobustDeterminant();

    private RobustDeterminant() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final int signOfDet2x2(double x1, double y1, double x2, double y2) {
        double x12 = x1;
        double y12 = y1;
        double x22 = x2;
        double y22 = y2;
        int sign = 0;
        double swap = 0.0;
        double k = 0.0;
        long count = 0L;
        sign = 1;
        if (x12 == 0.0 || y22 == 0.0) {
            if (y12 == 0.0) {
                return 0;
            }
            boolean bl = false;
            if (bl) return 0;
            if (x22 == 0.0) {
                return 0;
            }
            boolean bl2 = false;
            if (bl2) {
                return 0;
            }
            int n = y12 > 0.0 ? (x22 > 0.0 ? -sign : sign) : (x22 > 0.0 ? sign : -sign);
            return n;
        }
        if (y12 == 0.0 || x22 == 0.0) {
            return y22 > 0.0 ? (x12 > 0.0 ? sign : -sign) : (x12 > 0.0 ? -sign : sign);
        }
        if (0.0 < y12) {
            if (0.0 < y22) {
                if (!(y12 <= y22)) {
                    sign = -sign;
                    swap = x12;
                    x12 = x22;
                    x22 = swap;
                    swap = y12;
                    y12 = y22;
                    y22 = swap;
                }
            } else if (y12 <= -y22) {
                sign = -sign;
                x22 = -x22;
                y22 = -y22;
            } else {
                swap = x12;
                x12 = -x22;
                x22 = swap;
                swap = y12;
                y12 = -y22;
                y22 = swap;
            }
        } else if (0.0 < y22) {
            if (-y12 <= y22) {
                sign = -sign;
                x12 = -x12;
                y12 = -y12;
            } else {
                swap = -x12;
                x12 = x22;
                x22 = swap;
                swap = -y12;
                y12 = y22;
                y22 = swap;
            }
        } else if (y12 >= y22) {
            x12 = -x12;
            y12 = -y12;
            x22 = -x22;
            y22 = -y22;
        } else {
            sign = -sign;
            swap = -x12;
            x12 = -x22;
            x22 = swap;
            swap = -y12;
            y12 = -y22;
            y22 = swap;
        }
        if (0.0 < x12) {
            if (!(0.0 < x22)) return sign;
            if (!(x12 <= x22)) {
                return sign;
            }
        } else {
            if (0.0 < x22) {
                return -sign;
            }
            if (!(x12 >= x22)) return -sign;
            sign = -sign;
            x12 = -x12;
            x22 = -x22;
        }
        do {
            ++count;
            k = Math.INSTANCE.floor(x22 / x12);
            x22 -= k * x12;
            if ((y22 -= k * y12) < 0.0) {
                return -sign;
            }
            if (y22 > y12) {
                return sign;
            }
            if (x12 > x22 + x22) {
                if (y12 < y22 + y22) {
                    return sign;
                }
            } else {
                if (y12 > y22 + y22) {
                    return -sign;
                }
                x22 = x12 - x22;
                y22 = y12 - y22;
                sign = -sign;
            }
            if (y22 == 0.0) {
                if (x22 == 0.0) {
                    return 0;
                }
                boolean bl = false;
                if (bl) {
                    return 0;
                }
                int n = -sign;
                return n;
            }
            if (x22 == 0.0) {
                return sign;
            }
            k = Math.INSTANCE.floor(x12 / x22);
            x12 -= k * x22;
            if ((y12 -= k * y22) < 0.0) {
                return sign;
            }
            if (y12 > y22) {
                return -sign;
            }
            if (x22 > x12 + x12) {
                if (y22 < y12 + y12) {
                    return -sign;
                }
            } else {
                if (y22 > y12 + y12) {
                    return sign;
                }
                x12 = x22 - x12;
                y12 = y22 - y12;
                sign = -sign;
            }
            if (!(y12 == 0.0)) continue;
            if (x12 == 0.0) {
                return 0;
            }
            boolean bl = false;
            if (bl) {
                return 0;
            }
            int n = sign;
            return n;
        } while (!(x12 == 0.0));
        return -sign;
    }

    @JvmStatic
    public static final int orientationIndex(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        double dx1 = p2.x - p1.x;
        double dy1 = p2.y - p1.y;
        double dx2 = q.x - p2.x;
        double dy2 = q.y - p2.y;
        return RobustDeterminant.signOfDet2x2(dx1, dy1, dx2, dy2);
    }
}

