/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.construct;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.legacy.queue.PriorityQueue;
import org.locationtech.jts.operation.distance.IndexedFacetDistance;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 /2\u00020\u0001:\u0002./B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0015H\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J\b\u0010#\u001a\u00020$H\u0002J\u001e\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100)H\u0002J \u0010*\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00060"}, d2={"Lorg/locationtech/jts/algorithm/construct/MaximumInscribedCircle;", "", "polygonal", "Lorg/locationtech/jts/geom/Geometry;", "tolerance", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;D)V", "inputGeom", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "ptLocater", "Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator;", "indexedDistance", "Lorg/locationtech/jts/operation/distance/IndexedFacetDistance;", "centerCell", "Lorg/locationtech/jts/algorithm/construct/MaximumInscribedCircle$Cell;", "centerPt", "Lorg/locationtech/jts/geom/Coordinate;", "radiusPt", "centerPoint", "Lorg/locationtech/jts/geom/Point;", "radiusPoint", "center", "getCenter", "()Lorg/locationtech/jts/geom/Point;", "getRadiusPoint", "radiusLine", "Lorg/locationtech/jts/geom/LineString;", "getRadiusLine", "()Lorg/locationtech/jts/geom/LineString;", "distanceToBoundary", "p", "x", "y", "compute", "", "createInitialGrid", "env", "Lorg/locationtech/jts/geom/Envelope;", "cellQueue", "Lorg/locationtech/jts/legacy/queue/PriorityQueue;", "createCell", "hSide", "createCentroidCell", "geom", "Cell", "Companion", "kts-core"})
public final class MaximumInscribedCircle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeom;
    private final double tolerance;
    @NotNull
    private final GeometryFactory factory;
    @NotNull
    private final IndexedPointInAreaLocator ptLocater;
    @NotNull
    private final IndexedFacetDistance indexedDistance;
    @Nullable
    private Cell centerCell;
    @Nullable
    private Coordinate centerPt;
    @Nullable
    private Coordinate radiusPt;
    @Nullable
    private Point centerPoint;
    @Nullable
    private Point radiusPoint;

    public MaximumInscribedCircle(@NotNull Geometry polygonal, double tolerance) {
        Intrinsics.checkNotNullParameter((Object)polygonal, (String)"polygonal");
        if (tolerance <= 0.0) {
            throw new IllegalArgumentException("Tolerance must be positive");
        }
        if (!(polygonal instanceof Polygon) && !(polygonal instanceof MultiPolygon)) {
            throw new IllegalArgumentException("Input geometry must be a Polygon or MultiPolygon");
        }
        if (polygonal.isEmpty()) {
            throw new IllegalArgumentException("Empty input geometry is not supported");
        }
        this.inputGeom = polygonal;
        this.factory = polygonal.getFactory();
        this.tolerance = tolerance;
        this.ptLocater = new IndexedPointInAreaLocator(polygonal);
        Geometry geometry = polygonal.getBoundary();
        Intrinsics.checkNotNull((Object)geometry);
        this.indexedDistance = new IndexedFacetDistance(geometry);
    }

    @Nullable
    public final Point getCenter() {
        this.compute();
        return this.centerPoint;
    }

    @Nullable
    public final Point getRadiusPoint() {
        this.compute();
        return this.radiusPoint;
    }

    @NotNull
    public final LineString getRadiusLine() {
        this.compute();
        Coordinate[] coordinateArray = new Coordinate[2];
        Coordinate coordinate = this.centerPt;
        Intrinsics.checkNotNull((Object)coordinate);
        coordinateArray[0] = coordinate.copy();
        Coordinate coordinate2 = this.radiusPt;
        Intrinsics.checkNotNull((Object)coordinate2);
        coordinateArray[1] = coordinate2.copy();
        return this.factory.createLineString(coordinateArray);
    }

    private final double distanceToBoundary(Point p) {
        double dist = this.indexedDistance.distance(p);
        Coordinate coordinate = p.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        boolean isOutide = 2 == this.ptLocater.locate(coordinate);
        return isOutide ? -dist : dist;
    }

    private final double distanceToBoundary(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        Point pt = this.factory.createPoint(coord);
        return this.distanceToBoundary(pt);
    }

    private final void compute() {
        if (this.centerCell != null) {
            return;
        }
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>(0, null, 3, null);
        this.createInitialGrid(this.inputGeom.getEnvelopeInternal(), cellQueue);
        Cell farthestCell = this.createCentroidCell(this.inputGeom);
        while (!cellQueue.isEmpty()) {
            double potentialIncrease;
            Cell cell;
            Cell cell2 = cell = (Cell)cellQueue.remove();
            Intrinsics.checkNotNull((Object)cell2);
            if (cell2.getDistance() > farthestCell.getDistance()) {
                farthestCell = cell;
            }
            if (!((potentialIncrease = cell.getMaxDistance() - farthestCell.getDistance()) > this.tolerance)) continue;
            double h2 = cell.getHSide() / (double)2;
            cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() - h2, h2));
            cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() - h2, h2));
            cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() + h2, h2));
            cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() + h2, h2));
        }
        Cell cell = this.centerCell = farthestCell;
        Intrinsics.checkNotNull((Object)cell);
        double d = cell.getX();
        Cell cell3 = this.centerCell;
        Intrinsics.checkNotNull((Object)cell3);
        this.centerPt = new Coordinate(d, cell3.getY());
        this.centerPoint = this.factory.createPoint(this.centerPt);
        Coordinate[] nearestPts = this.indexedDistance.nearestPoints(this.centerPoint);
        Intrinsics.checkNotNull((Object)nearestPts);
        this.radiusPt = nearestPts[0].copy();
        this.radiusPoint = this.factory.createPoint(this.radiusPt);
    }

    private final void createInitialGrid(Envelope env, PriorityQueue<Cell> cellQueue) {
        double height;
        double minX = env.getMinX();
        double maxX = env.getMaxX();
        double minY = env.getMinY();
        double maxY = env.getMaxY();
        double width = env.getWidth();
        double cellSize = Math.INSTANCE.min(width, height = env.getHeight());
        if (cellSize == 0.0) {
            return;
        }
        double hSide = cellSize / 2.0;
        for (double x = minX; x < maxX; x += cellSize) {
            for (double y = minY; y < maxY; y += cellSize) {
                cellQueue.add(this.createCell(x + hSide, y + hSide, hSide));
            }
        }
    }

    private final Cell createCell(double x, double y, double hSide) {
        return new Cell(x, y, hSide, this.distanceToBoundary(x, y));
    }

    private final Cell createCentroidCell(Geometry geom) {
        Point p = geom.getCentroid();
        return new Cell(p.getX(), p.getY(), 0.0, this.distanceToBoundary(p));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00172\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001:\u0001\u0017B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/algorithm/construct/MaximumInscribedCircle$Cell;", "", "x", "", "y", "hSide", "distance", "<init>", "(DDDD)V", "getX", "()D", "getY", "getHSide", "getDistance", "maxDistance", "getMaxDistance", "envelope", "Lorg/locationtech/jts/geom/Envelope;", "getEnvelope", "()Lorg/locationtech/jts/geom/Envelope;", "compareTo", "", "o", "Companion", "kts-core"})
    private static final class Cell
    implements Comparable<Cell> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double x;
        private final double y;
        private final double hSide;
        private final double distance;
        private final double maxDistance;
        private static final double SQRT2 = 1.4142135623730951;

        public Cell(double x, double y, double hSide, double distance) {
            this.x = x;
            this.y = y;
            this.hSide = hSide;
            this.distance = distance;
            this.maxDistance = this.distance + this.hSide * 1.4142135623730951;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getHSide() {
            return this.hSide;
        }

        public final double getDistance() {
            return this.distance;
        }

        public final double getMaxDistance() {
            return this.maxDistance;
        }

        @NotNull
        public final Envelope getEnvelope() {
            return new Envelope(this.x - this.hSide, this.x + this.hSide, this.y - this.hSide, this.y + this.hSide);
        }

        @Override
        public int compareTo(@Nullable Cell o) {
            Cell cell = o;
            Intrinsics.checkNotNull((Object)cell);
            return (int)(cell.maxDistance - this.maxDistance);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/algorithm/construct/MaximumInscribedCircle$Cell$Companion;", "", "<init>", "()V", "SQRT2", "", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/algorithm/construct/MaximumInscribedCircle$Companion;", "", "<init>", "()V", "getCenter", "Lorg/locationtech/jts/geom/Point;", "polygonal", "Lorg/locationtech/jts/geom/Geometry;", "tolerance", "", "getRadiusLine", "Lorg/locationtech/jts/geom/LineString;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Point getCenter(@NotNull Geometry polygonal, double tolerance) {
            Intrinsics.checkNotNullParameter((Object)polygonal, (String)"polygonal");
            MaximumInscribedCircle mic = new MaximumInscribedCircle(polygonal, tolerance);
            return mic.getCenter();
        }

        @NotNull
        public final LineString getRadiusLine(@NotNull Geometry polygonal, double tolerance) {
            Intrinsics.checkNotNullParameter((Object)polygonal, (String)"polygonal");
            MaximumInscribedCircle mic = new MaximumInscribedCircle(polygonal, tolerance);
            return mic.getRadiusLine();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

