/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.distance;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/algorithm/distance/DistanceToPoint;", "", "<init>", "()V", "computeDistance", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "ptDist", "Lorg/locationtech/jts/algorithm/distance/PointPairDistance;", "line", "Lorg/locationtech/jts/geom/LineString;", "segment", "Lorg/locationtech/jts/geom/LineSegment;", "poly", "Lorg/locationtech/jts/geom/Polygon;", "kts-core"})
public final class DistanceToPoint {
    @NotNull
    public static final DistanceToPoint INSTANCE = new DistanceToPoint();

    private DistanceToPoint() {
    }

    public final void computeDistance(@NotNull Geometry geom, @NotNull Coordinate pt, @NotNull PointPairDistance ptDist) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        Intrinsics.checkNotNullParameter((Object)ptDist, (String)"ptDist");
        if (geom instanceof LineString) {
            this.computeDistance((LineString)geom, pt, ptDist);
        } else if (geom instanceof Polygon) {
            DistanceToPoint.computeDistance((Polygon)geom, pt, ptDist);
        } else if (geom instanceof GeometryCollection) {
            Geometry gc = geom;
            int n = ((GeometryCollection)gc).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry g = ((GeometryCollection)gc).getGeometryN(i);
                this.computeDistance(g, pt, ptDist);
            }
        } else {
            Coordinate coordinate = geom.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            ptDist.setMinimum(coordinate, pt);
        }
    }

    public final void computeDistance(@NotNull LineString line, @NotNull Coordinate pt, @NotNull PointPairDistance ptDist) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        Intrinsics.checkNotNullParameter((Object)ptDist, (String)"ptDist");
        LineSegment tempSegment = new LineSegment(null, null, 3, null);
        Coordinate[] coords = line.getCoordinates();
        int n = coords.length - 1;
        for (int i = 0; i < n; ++i) {
            tempSegment.setCoordinates(coords[i], coords[i + 1]);
            Coordinate closestPt = tempSegment.closestPoint(pt);
            ptDist.setMinimum(closestPt, pt);
        }
    }

    public final void computeDistance(@NotNull LineSegment segment, @NotNull Coordinate pt, @NotNull PointPairDistance ptDist) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        Intrinsics.checkNotNullParameter((Object)ptDist, (String)"ptDist");
        Coordinate closestPt = segment.closestPoint(pt);
        ptDist.setMinimum(closestPt, pt);
    }

    @JvmStatic
    public static final void computeDistance(@NotNull Polygon poly, @NotNull Coordinate pt, @NotNull PointPairDistance ptDist) {
        Intrinsics.checkNotNullParameter((Object)poly, (String)"poly");
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        Intrinsics.checkNotNullParameter((Object)ptDist, (String)"ptDist");
        LinearRing linearRing = poly.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        INSTANCE.computeDistance(linearRing, pt, ptDist);
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            INSTANCE.computeDistance(poly.getInteriorRingN(i), pt, ptDist);
        }
    }
}

