/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.distance;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.WKTWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0000J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0000J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/algorithm/distance/PointPairDistance;", "", "<init>", "()V", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "value", "", "distance", "getDistance", "()D", "isNull", "", "initialize", "", "p0", "p1", "getCoordinate", "i", "", "setMaximum", "ptDist", "setMinimum", "toString", "", "kts-core"})
public final class PointPairDistance {
    @NotNull
    private final Coordinate[] coordinates;
    private double distance;
    private boolean isNull;

    public PointPairDistance() {
        Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(), new Coordinate()};
        this.coordinates = coordinateArray;
        this.distance = Double.NaN;
        this.isNull = true;
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        return this.coordinates;
    }

    public final double getDistance() {
        return this.distance;
    }

    public final void initialize() {
        this.isNull = true;
    }

    public final void initialize(@NotNull Coordinate p0, @Nullable Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Coordinate coordinate = p1;
        Intrinsics.checkNotNull((Object)coordinate);
        this.initialize(p0, p1, p0.distance(coordinate));
    }

    public final void initialize(@Nullable Coordinate p0, @Nullable Coordinate p1, double distance) {
        Coordinate coordinate = this.coordinates[0];
        Coordinate coordinate2 = p0;
        Intrinsics.checkNotNull((Object)coordinate2);
        coordinate.setCoordinate(coordinate2);
        Coordinate coordinate3 = this.coordinates[1];
        Coordinate coordinate4 = p1;
        Intrinsics.checkNotNull((Object)coordinate4);
        coordinate3.setCoordinate(coordinate4);
        this.distance = distance;
        this.isNull = false;
    }

    @NotNull
    public final Coordinate getCoordinate(int i) {
        return this.coordinates[i];
    }

    public final void setMaximum(@NotNull PointPairDistance ptDist) {
        Intrinsics.checkNotNullParameter((Object)ptDist, (String)"ptDist");
        this.setMaximum(ptDist.coordinates[0], ptDist.coordinates[1]);
    }

    public final void setMaximum(@NotNull Coordinate p0, @Nullable Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        if (this.isNull) {
            this.initialize(p0, p1);
            return;
        }
        Coordinate coordinate = p1;
        Intrinsics.checkNotNull((Object)coordinate);
        double dist = p0.distance(coordinate);
        if (dist > this.distance) {
            this.initialize(p0, p1, dist);
        }
    }

    public final void setMinimum(@NotNull PointPairDistance ptDist) {
        Intrinsics.checkNotNullParameter((Object)ptDist, (String)"ptDist");
        this.setMinimum(ptDist.coordinates[0], ptDist.coordinates[1]);
    }

    public final void setMinimum(@NotNull Coordinate p0, @Nullable Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        if (this.isNull) {
            this.initialize(p0, p1);
            return;
        }
        Coordinate coordinate = p1;
        Intrinsics.checkNotNull((Object)coordinate);
        double dist = p0.distance(coordinate);
        if (dist < this.distance) {
            this.initialize(p0, p1, dist);
        }
    }

    @NotNull
    public String toString() {
        return WKTWriter.Companion.toLineString(this.coordinates[0], this.coordinates[1]);
    }
}

