/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.hull;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.legacy.StackKt;
import org.locationtech.jts.operation.overlayng.CoverageUnion;
import org.locationtech.jts.triangulate.polygon.ConstrainedDelaunayTriangulator;
import org.locationtech.jts.triangulate.tri.Tri;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\r\u0018\u0000 >2\u00020\u0001:\u0001>B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010'\u001a\u00020\u0003H\u0002J\b\u0010(\u001a\u00020\u001cH\u0002J/\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0010H\u0002\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\u001cH\u0002J\b\u00100\u001a\u00020\u001cH\u0002J\u001a\u00101\u001a\u0004\u0018\u00010\u00152\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u000102H\u0002J\u0010\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u00105\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u00106\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u00107\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u00108\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0018\u00109\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u001aH\u0002J\u0010\u0010;\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u0015H\u0002J \u0010<\u001a\u00020\u00032\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u0001022\u0006\u0010=\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$\u00a8\u0006?"}, d2={"Lorg/locationtech/jts/algorithm/hull/ConcaveHullOfPolygons;", "", "polygons", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "inputPolygons", "maxEdgeLength", "", "maxEdgeLengthRatio", "isHolesAllowed", "", "isTight", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "polygonRings", "", "Lorg/locationtech/jts/geom/LinearRing;", "[Lorg/locationtech/jts/geom/LinearRing;", "hullTris", "", "Lorg/locationtech/jts/triangulate/tri/Tri;", "borderTriQue", "Lkotlin/collections/ArrayDeque;", "borderEdgeMap", "", "", "setMaximumEdgeLength", "", "edgeLength", "setMaximumEdgeLengthRatio", "edgeLengthRatio", "setHolesAllowed", "setTight", "hull", "getHull", "()Lorg/locationtech/jts/geom/Geometry;", "fill", "getFill", "createEmptyHull", "buildHullTris", "removeFrameCornerTris", "tris", "", "frameCorners", "Lorg/locationtech/jts/geom/Coordinate;", "(Ljava/util/List;[Lorg/locationtech/jts/geom/Coordinate;)Ljava/util/Set;", "removeBorderTris", "removeHoleTris", "findHoleSeedTri", "", "isHoleSeedTri", "tri", "isBorderTri", "isRemovable", "isTouchingSinglePolygon", "addBorderTris", "addBorderTri", "index", "removeBorderTri", "createHullGeometry", "isIncludeInput", "Companion", "kts-core"})
public final class ConcaveHullOfPolygons {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputPolygons;
    private double maxEdgeLength;
    private double maxEdgeLengthRatio = -1.0;
    private boolean isHolesAllowed;
    private boolean isTight;
    @NotNull
    private final GeometryFactory geomFactory;
    @Nullable
    private LinearRing[] polygonRings;
    @Nullable
    private Set<Tri> hullTris;
    @Nullable
    private ArrayDeque<Tri> borderTriQue;
    @NotNull
    private final Map<Tri, Integer> borderEdgeMap = new HashMap();
    private static final int FRAME_EXPAND_FACTOR = 4;
    private static final int NOT_SPECIFIED = -1;
    private static final int NOT_FOUND = -1;

    public ConcaveHullOfPolygons(@Nullable Geometry polygons) {
        if (!(polygons instanceof Polygon) && !(polygons instanceof MultiPolygon)) {
            throw new IllegalArgumentException("Input must be polygonal");
        }
        this.inputPolygons = polygons;
        this.geomFactory = this.inputPolygons.getFactory();
    }

    public final void setMaximumEdgeLength(double edgeLength) {
        if (edgeLength < 0.0) {
            throw new IllegalArgumentException("Edge length must be non-negative");
        }
        this.maxEdgeLength = edgeLength;
        this.maxEdgeLengthRatio = -1.0;
    }

    public final void setMaximumEdgeLengthRatio(double edgeLengthRatio) {
        if (edgeLengthRatio < 0.0 || edgeLengthRatio > 1.0) {
            throw new IllegalArgumentException("Edge length ratio must be in range [0,1]");
        }
        this.maxEdgeLengthRatio = edgeLengthRatio;
    }

    public final void setHolesAllowed(boolean isHolesAllowed) {
        this.isHolesAllowed = isHolesAllowed;
    }

    public final void setTight(boolean isTight) {
        this.isTight = isTight;
    }

    @NotNull
    public final Geometry getHull() {
        if (this.inputPolygons.isEmpty()) {
            return this.createEmptyHull();
        }
        this.buildHullTris();
        return this.createHullGeometry(this.hullTris, true);
    }

    @NotNull
    public final Geometry getFill() {
        this.isTight = true;
        if (this.inputPolygons.isEmpty()) {
            return this.createEmptyHull();
        }
        this.buildHullTris();
        return this.createHullGeometry(this.hullTris, false);
    }

    private final Geometry createEmptyHull() {
        return GeometryFactory.createPolygon$default(this.geomFactory, null, null, 3, null);
    }

    private final void buildHullTris() {
        this.polygonRings = ConcaveHullOfPolygons.Companion.extractShellRings(this.inputPolygons);
        Envelope envelope = this.inputPolygons.getEnvelopeInternal();
        Intrinsics.checkNotNull((Object)this.polygonRings);
        Polygon frame = ConcaveHullOfPolygons.Companion.createFrame(envelope, this.polygonRings, this.geomFactory);
        ConstrainedDelaunayTriangulator cdt = new ConstrainedDelaunayTriangulator(frame);
        List<Tri> list = cdt.getTriangles();
        Intrinsics.checkNotNull(list);
        List<Tri> tris = list;
        LinearRing linearRing = frame.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        Coordinate[] framePts = linearRing.getCoordinates();
        if (this.maxEdgeLengthRatio >= 0.0) {
            this.maxEdgeLength = ConcaveHullOfPolygons.Companion.computeTargetEdgeLength(tris, framePts, this.maxEdgeLengthRatio);
        }
        this.hullTris = this.removeFrameCornerTris(tris, framePts);
        this.removeBorderTris();
        if (this.isHolesAllowed) {
            this.removeHoleTris();
        }
    }

    private final Set<Tri> removeFrameCornerTris(List<? extends Tri> tris, Coordinate[] frameCorners) {
        Set hullTris = new HashSet();
        this.borderTriQue = new ArrayDeque();
        for (Tri tri : tris) {
            boolean isFrameTri;
            int index = ConcaveHullOfPolygons.Companion.vertexIndex(tri, frameCorners);
            boolean bl = isFrameTri = index != -1;
            if (isFrameTri) {
                boolean isBorderTri;
                int oppIndex = Tri.Companion.oppEdge(index);
                Tri oppTri = tri.getAdjacent(oppIndex);
                boolean bl2 = isBorderTri = oppTri != null && !ConcaveHullOfPolygons.Companion.isFrameTri(oppTri, frameCorners);
                if (isBorderTri) {
                    this.addBorderTri(tri, oppIndex);
                }
                tri.remove();
                continue;
            }
            hullTris.add(tri);
        }
        return hullTris;
    }

    private final void removeBorderTris() {
        while (true) {
            ArrayDeque<Tri> arrayDeque = this.borderTriQue;
            Intrinsics.checkNotNull(arrayDeque);
            if (arrayDeque.isEmpty()) break;
            ArrayDeque<Tri> arrayDeque2 = this.borderTriQue;
            Intrinsics.checkNotNull(arrayDeque2);
            Object t = StackKt.pop((List)arrayDeque2);
            Intrinsics.checkNotNull(t);
            Tri tri = (Tri)t;
            Set<Tri> set = this.hullTris;
            Intrinsics.checkNotNull(set);
            if (!set.contains(tri) || !this.isRemovable(tri)) continue;
            this.addBorderTris(tri);
            this.removeBorderTri(tri);
        }
    }

    private final void removeHoleTris() {
        while (this.findHoleSeedTri(this.hullTris) != null) {
            Tri holeTri;
            this.addBorderTris(holeTri);
            this.removeBorderTri(holeTri);
            this.removeBorderTris();
        }
        return;
    }

    private final Tri findHoleSeedTri(Set<? extends Tri> tris) {
        Set<? extends Tri> set = tris;
        Intrinsics.checkNotNull(set);
        for (Tri tri : set) {
            if (!this.isHoleSeedTri(tri)) continue;
            return tri;
        }
        return null;
    }

    private final boolean isHoleSeedTri(Tri tri) {
        if (this.isBorderTri(tri)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (!tri.hasAdjacent(i) || !(tri.getLength(i) > this.maxEdgeLength)) continue;
            return true;
        }
        return false;
    }

    private final boolean isBorderTri(Tri tri) {
        for (int i = 0; i < 3; ++i) {
            if (tri.hasAdjacent(i)) continue;
            return true;
        }
        return false;
    }

    private final boolean isRemovable(Tri tri) {
        if (this.isTight && this.isTouchingSinglePolygon(tri)) {
            return true;
        }
        if (this.borderEdgeMap.containsKey(tri)) {
            Integer n = this.borderEdgeMap.get(tri);
            Intrinsics.checkNotNull((Object)n);
            int borderEdgeIndex = ((Number)n).intValue();
            double edgeLen = tri.getLength(borderEdgeIndex);
            if (edgeLen > this.maxEdgeLength) {
                return true;
            }
        }
        return false;
    }

    private final boolean isTouchingSinglePolygon(Tri tri) {
        Envelope envTri = ConcaveHullOfPolygons.Companion.envelope(tri);
        Intrinsics.checkNotNull((Object)this.polygonRings);
        for (LinearRing ring : this.polygonRings) {
            if (!ring.getEnvelopeInternal().intersects(envTri) || !ConcaveHullOfPolygons.Companion.hasAllVertices(ring, tri)) continue;
            return true;
        }
        return false;
    }

    private final void addBorderTris(Tri tri) {
        this.addBorderTri(tri, 0);
        this.addBorderTri(tri, 1);
        this.addBorderTri(tri, 2);
    }

    private final void addBorderTri(Tri tri, int index) {
        Tri tri2 = tri.getAdjacent(index);
        if (tri2 == null) {
            return;
        }
        Tri adj = tri2;
        ArrayDeque<Tri> arrayDeque = this.borderTriQue;
        Intrinsics.checkNotNull(arrayDeque);
        arrayDeque.add((Object)adj);
        int borderEdgeIndex = adj.getIndex(tri);
        this.borderEdgeMap.put(adj, borderEdgeIndex);
    }

    private final void removeBorderTri(Tri tri) {
        tri.remove();
        Set<Tri> set = this.hullTris;
        Intrinsics.checkNotNull(set);
        set.remove(tri);
        this.borderEdgeMap.remove(tri);
    }

    private final Geometry createHullGeometry(Set<? extends Tri> hullTris, boolean isIncludeInput) {
        if (!isIncludeInput) {
            Set<? extends Tri> set = hullTris;
            Intrinsics.checkNotNull(set);
            if (set.isEmpty()) {
                return this.createEmptyHull();
            }
        }
        Set<? extends Tri> set = hullTris;
        Intrinsics.checkNotNull(set);
        Geometry triCoverage = Tri.Companion.toGeometry((Collection<? extends Tri>)set, this.geomFactory);
        Geometry geometry = CoverageUnion.union(triCoverage);
        Intrinsics.checkNotNull((Object)geometry);
        Geometry fillGeometry = geometry;
        if (!isIncludeInput) {
            return fillGeometry;
        }
        if (fillGeometry.isEmpty()) {
            return this.inputPolygons.copy();
        }
        Geometry[] geometryArray = new Geometry[]{fillGeometry, this.inputPolygons};
        Geometry[] geoms = geometryArray;
        GeometryCollection geomColl = this.geomFactory.createGeometryCollection(geoms);
        Geometry geometry2 = CoverageUnion.union(geomColl);
        Intrinsics.checkNotNull((Object)geometry2);
        return geometry2;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry concaveHullByLength(@Nullable Geometry polygons, double maxLength, boolean isTight, boolean isHolesAllowed) {
        return Companion.concaveHullByLength(polygons, maxLength, isTight, isHolesAllowed);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry concaveHullByLengthRatio(@Nullable Geometry polygons, double lengthRatio, boolean isTight, boolean isHolesAllowed) {
        return Companion.concaveHullByLengthRatio(polygons, lengthRatio, isTight, isHolesAllowed);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry concaveHullByLength(@Nullable Geometry polygons, double maxLength, boolean isTight) {
        return Companion.concaveHullByLength(polygons, maxLength, isTight);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry concaveHullByLength(@Nullable Geometry polygons, double maxLength) {
        return Companion.concaveHullByLength(polygons, maxLength);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry concaveHullByLengthRatio(@Nullable Geometry polygons, double lengthRatio, boolean isTight) {
        return Companion.concaveHullByLengthRatio(polygons, lengthRatio, isTight);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry concaveHullByLengthRatio(@Nullable Geometry polygons, double lengthRatio) {
        return Companion.concaveHullByLengthRatio(polygons, lengthRatio);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007J.\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\bJ1\u0010\u0014\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0002\u0010\u001fJ#\u0010 \u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0018\u0010&\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020\u001aH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J+\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020%0\u00192\u0006\u0010.\u001a\u00020/H\u0002\u00a2\u0006\u0002\u00100J\u001b\u00101\u001a\b\u0012\u0004\u0012\u00020%0\u00192\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u00102R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/locationtech/jts/algorithm/hull/ConcaveHullOfPolygons$Companion;", "", "<init>", "()V", "concaveHullByLength", "Lorg/locationtech/jts/geom/Geometry;", "polygons", "maxLength", "", "isTight", "", "isHolesAllowed", "concaveHullByLengthRatio", "lengthRatio", "concaveFillByLength", "concaveFillByLengthRatio", "FRAME_EXPAND_FACTOR", "", "NOT_SPECIFIED", "NOT_FOUND", "computeTargetEdgeLength", "triList", "", "Lorg/locationtech/jts/triangulate/tri/Tri;", "frameCorners", "", "Lorg/locationtech/jts/geom/Coordinate;", "edgeLengthRatio", "(Ljava/util/List;[Lorg/locationtech/jts/geom/Coordinate;D)D", "isFrameTri", "tri", "(Lorg/locationtech/jts/triangulate/tri/Tri;[Lorg/locationtech/jts/geom/Coordinate;)Z", "vertexIndex", "pts", "(Lorg/locationtech/jts/triangulate/tri/Tri;[Lorg/locationtech/jts/geom/Coordinate;)I", "hasAllVertices", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "hasVertex", "v", "envelope", "Lorg/locationtech/jts/geom/Envelope;", "createFrame", "Lorg/locationtech/jts/geom/Polygon;", "polygonsEnv", "polygonRings", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "(Lorg/locationtech/jts/geom/Envelope;[Lorg/locationtech/jts/geom/LinearRing;Lorg/locationtech/jts/geom/GeometryFactory;)Lorg/locationtech/jts/geom/Polygon;", "extractShellRings", "(Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/LinearRing;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry concaveHullByLength(@Nullable Geometry polygons, double maxLength, boolean isTight, boolean isHolesAllowed) {
            ConcaveHullOfPolygons hull = new ConcaveHullOfPolygons(polygons);
            hull.setMaximumEdgeLength(maxLength);
            hull.setHolesAllowed(isHolesAllowed);
            hull.setTight(isTight);
            return hull.getHull();
        }

        public static /* synthetic */ Geometry concaveHullByLength$default(Companion companion, Geometry geometry, double d, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            return companion.concaveHullByLength(geometry, d, bl, bl2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry concaveHullByLengthRatio(@Nullable Geometry polygons, double lengthRatio, boolean isTight, boolean isHolesAllowed) {
            ConcaveHullOfPolygons hull = new ConcaveHullOfPolygons(polygons);
            hull.setMaximumEdgeLengthRatio(lengthRatio);
            hull.setHolesAllowed(isHolesAllowed);
            hull.setTight(isTight);
            return hull.getHull();
        }

        public static /* synthetic */ Geometry concaveHullByLengthRatio$default(Companion companion, Geometry geometry, double d, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            return companion.concaveHullByLengthRatio(geometry, d, bl, bl2);
        }

        @NotNull
        public final Geometry concaveFillByLength(@Nullable Geometry polygons, double maxLength) {
            ConcaveHullOfPolygons hull = new ConcaveHullOfPolygons(polygons);
            hull.setMaximumEdgeLength(maxLength);
            return hull.getFill();
        }

        @NotNull
        public final Geometry concaveFillByLengthRatio(@Nullable Geometry polygons, double lengthRatio) {
            ConcaveHullOfPolygons hull = new ConcaveHullOfPolygons(polygons);
            hull.setMaximumEdgeLengthRatio(lengthRatio);
            return hull.getFill();
        }

        private final double computeTargetEdgeLength(List<? extends Tri> triList, Coordinate[] frameCorners, double edgeLengthRatio) {
            if (edgeLengthRatio == 0.0) {
                return 0.0;
            }
            double maxEdgeLen = -1.0;
            double minEdgeLen = -1.0;
            for (Tri tri : triList) {
                if (this.isFrameTri(tri, frameCorners)) continue;
                for (int i = 0; i < 3; ++i) {
                    if (!tri.hasAdjacent(i)) continue;
                    double len = tri.getLength(i);
                    if (len > maxEdgeLen) {
                        maxEdgeLen = len;
                    }
                    if (!(minEdgeLen < 0.0) && !(len < minEdgeLen)) continue;
                    minEdgeLen = len;
                }
            }
            return edgeLengthRatio == 1.0 ? (double)2 * maxEdgeLen : edgeLengthRatio * (maxEdgeLen - minEdgeLen) + minEdgeLen;
        }

        private final boolean isFrameTri(Tri tri, Coordinate[] frameCorners) {
            int index = this.vertexIndex(tri, frameCorners);
            return index >= 0;
        }

        private final int vertexIndex(Tri tri, Coordinate[] pts) {
            for (Coordinate p : pts) {
                int index = tri.getIndex(p);
                if (index < 0) continue;
                return index;
            }
            return -1;
        }

        private final boolean hasAllVertices(LinearRing ring, Tri tri) {
            for (int i = 0; i < 3; ++i) {
                Coordinate v = tri.getCoordinate(i);
                if (this.hasVertex(ring, v)) continue;
                return false;
            }
            return true;
        }

        private final boolean hasVertex(LinearRing ring, Coordinate v) {
            int n = ring.getNumPoints();
            for (int i = 1; i < n; ++i) {
                if (!v.equals2D(ring.getCoordinateN(i))) continue;
                return true;
            }
            return false;
        }

        private final Envelope envelope(Tri tri) {
            Envelope env = new Envelope(tri.getCoordinate(0), tri.getCoordinate(1));
            env.expandToInclude(tri.getCoordinate(2));
            return env;
        }

        private final Polygon createFrame(Envelope polygonsEnv, LinearRing[] polygonRings, GeometryFactory geomFactory) {
            double diam = polygonsEnv.getDiameter();
            Envelope envFrame = polygonsEnv.copy();
            envFrame.expandBy((double)4 * diam);
            Geometry geometry = geomFactory.toGeometry(envFrame);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            Polygon frameOuter = (Polygon)geometry;
            LinearRing linearRing = frameOuter.getExteriorRing();
            Intrinsics.checkNotNull((Object)linearRing);
            Geometry geometry2 = linearRing.copy();
            Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
            LinearRing shell = (LinearRing)geometry2;
            return geomFactory.createPolygon(shell, polygonRings);
        }

        private final LinearRing[] extractShellRings(Geometry polygons) {
            Object[] rings = new LinearRing[polygons.getNumGeometries()];
            int n = polygons.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry geometry = polygons.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                Polygon consPoly = (Polygon)geometry;
                LinearRing linearRing = consPoly.getExteriorRing();
                Intrinsics.checkNotNull((Object)linearRing);
                Intrinsics.checkNotNull((Object)linearRing.copy(), (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
            }
            return (LinearRing[])ArraysKt.requireNoNulls((Object[])rings);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry concaveHullByLength(@Nullable Geometry polygons, double maxLength, boolean isTight) {
            return org.locationtech.jts.algorithm.hull.ConcaveHullOfPolygons$Companion.concaveHullByLength$default(this, polygons, maxLength, isTight, false, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry concaveHullByLength(@Nullable Geometry polygons, double maxLength) {
            return org.locationtech.jts.algorithm.hull.ConcaveHullOfPolygons$Companion.concaveHullByLength$default(this, polygons, maxLength, false, false, 12, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry concaveHullByLengthRatio(@Nullable Geometry polygons, double lengthRatio, boolean isTight) {
            return org.locationtech.jts.algorithm.hull.ConcaveHullOfPolygons$Companion.concaveHullByLengthRatio$default(this, polygons, lengthRatio, isTight, false, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry concaveHullByLengthRatio(@Nullable Geometry polygons, double lengthRatio) {
            return org.locationtech.jts.algorithm.hull.ConcaveHullOfPolygons$Companion.concaveHullByLengthRatio$default(this, polygons, lengthRatio, false, false, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

