/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.hull;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.hull.HullTri;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.operation.overlayng.CoverageUnion;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.TriangleVisitor;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.locationtech.jts.triangulate.tri.Tri;
import org.locationtech.jts.triangulate.tri.TriangulationBuilder;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\b2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/algorithm/hull/HullTriangulation;", "", "<init>", "()V", "createDelaunayTriangulation", "", "Lorg/locationtech/jts/algorithm/hull/HullTri;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "toTris", "subdiv", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "union", "triList", "", "Lorg/locationtech/jts/triangulate/tri/Tri;", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "traceBoundaryPolygon", "traceBoundary", "", "Lorg/locationtech/jts/geom/Coordinate;", "(Ljava/util/List;)[Lorg/locationtech/jts/geom/Coordinate;", "findBorderTri", "nextBorderTri", "triStart", "HullTriVisitor", "kts-core"})
public final class HullTriangulation {
    @NotNull
    public static final HullTriangulation INSTANCE = new HullTriangulation();

    private HullTriangulation() {
    }

    @NotNull
    public final List<HullTri> createDelaunayTriangulation(@Nullable Geometry geom) {
        DelaunayTriangulationBuilder dt = new DelaunayTriangulationBuilder();
        dt.setSites(geom);
        QuadEdgeSubdivision quadEdgeSubdivision = dt.getSubdivision();
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision);
        QuadEdgeSubdivision subdiv = quadEdgeSubdivision;
        return this.toTris(subdiv);
    }

    private final List<HullTri> toTris(QuadEdgeSubdivision subdiv) {
        HullTriVisitor visitor = new HullTriVisitor();
        subdiv.visitTriangles(visitor, false);
        List<HullTri> triList = visitor.getTriangles();
        TriangulationBuilder.Companion.build(triList);
        return triList;
    }

    @NotNull
    public final Geometry union(@NotNull List<? extends Tri> triList, @NotNull GeometryFactory geomFactory) {
        Intrinsics.checkNotNullParameter(triList, (String)"triList");
        Intrinsics.checkNotNullParameter((Object)geomFactory, (String)"geomFactory");
        List polys = new ArrayList();
        Iterator<? extends Tri> iterator2 = triList.iterator();
        while (iterator2.hasNext()) {
            Tri tri;
            Tri tri2 = tri = iterator2.next();
            Intrinsics.checkNotNull((Object)tri2);
            Polygon poly = tri2.toPolygon(geomFactory);
            polys.add(poly);
        }
        Geometry geometry = CoverageUnion.union(geomFactory.buildGeometry(polys));
        Intrinsics.checkNotNull((Object)geometry);
        return geometry;
    }

    @NotNull
    public final Geometry traceBoundaryPolygon(@NotNull List<HullTri> triList, @NotNull GeometryFactory geomFactory) {
        Intrinsics.checkNotNullParameter(triList, (String)"triList");
        Intrinsics.checkNotNullParameter((Object)geomFactory, (String)"geomFactory");
        if (triList.size() == 1) {
            Tri tri = triList.get(0);
            return tri.toPolygon(geomFactory);
        }
        Coordinate[] pts = this.traceBoundary(triList);
        return geomFactory.createPolygon(pts);
    }

    private final Coordinate[] traceBoundary(List<HullTri> triList) {
        HullTri triStart = this.findBorderTri(triList);
        CoordinateList coordList = new CoordinateList();
        HullTri tri = triStart;
        do {
            HullTri hullTri = tri;
            Intrinsics.checkNotNull((Object)hullTri);
            int boundaryIndex = hullTri.boundaryIndexCCW();
            coordList.add(tri.getCoordinate(boundaryIndex).copy(), false);
            int nextIndex = Tri.Companion.next(boundaryIndex);
            if (!tri.isBoundary(nextIndex)) continue;
            coordList.add(tri.getCoordinate(nextIndex).copy(), false);
            boundaryIndex = nextIndex;
        } while ((tri = this.nextBorderTri(tri)) != triStart);
        coordList.closeRing();
        return coordList.toCoordinateArray();
    }

    private final HullTri findBorderTri(List<HullTri> triList) {
        for (HullTri tri : triList) {
            if (!tri.isBorder()) continue;
            return tri;
        }
        Assert.shouldNeverReachHere("No border triangles found");
        return null;
    }

    @NotNull
    public final HullTri nextBorderTri(@Nullable HullTri triStart) {
        HullTri adjTri;
        HullTri tri;
        HullTri hullTri = tri = triStart;
        Intrinsics.checkNotNull((Object)hullTri);
        int index = Tri.Companion.next(hullTri.boundaryIndexCW());
        do {
            Tri tri2 = tri.getAdjacent(index);
            Intrinsics.checkNotNull((Object)tri2, (String)"null cannot be cast to non-null type org.locationtech.jts.algorithm.hull.HullTri");
            adjTri = (HullTri)tri2;
            if (adjTri != tri) continue;
            throw new IllegalStateException("No outgoing border edge found");
        } while (!(tri = adjTri).isBoundary(index = Tri.Companion.next(adjTri.getIndex(tri))));
        return tri;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/algorithm/hull/HullTriangulation$HullTriVisitor;", "Lorg/locationtech/jts/triangulate/quadedge/TriangleVisitor;", "<init>", "()V", "triList", "", "Lorg/locationtech/jts/algorithm/hull/HullTri;", "visit", "", "triEdges", "", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "([Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;)V", "triangles", "getTriangles", "()Ljava/util/List;", "kts-core"})
    private static final class HullTriVisitor
    implements TriangleVisitor {
        @NotNull
        private final List<HullTri> triList = new ArrayList();

        @Override
        public void visit(@NotNull QuadEdge[] triEdges) {
            Intrinsics.checkNotNullParameter((Object)triEdges, (String)"triEdges");
            Vertex vertex = triEdges[0].orig();
            Intrinsics.checkNotNull((Object)vertex);
            Coordinate p0 = vertex.getCoordinate();
            Vertex vertex2 = triEdges[1].orig();
            Intrinsics.checkNotNull((Object)vertex2);
            Coordinate p1 = vertex2.getCoordinate();
            Vertex vertex3 = triEdges[2].orig();
            Intrinsics.checkNotNull((Object)vertex3);
            Coordinate p2 = vertex3.getCoordinate();
            HullTri tri = null;
            tri = Triangle.Companion.isCCW(p0, p2, p1) ? new HullTri(p0, p2, p1) : new HullTri(p0, p1, p2);
            this.triList.add(tri);
        }

        @NotNull
        public final List<HullTri> getTriangles() {
            return this.triList;
        }
    }
}

