/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.locate;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.index.ArrayListVisitor;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.intervalrtree.SortedPackedIntervalRTree;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator;", "Lorg/locationtech/jts/algorithm/locate/PointOnGeometryLocator;", "g", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "geom", "index", "Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator$IntervalIndexedGeometry;", "locate", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "createIndex", "", "SegmentVisitor", "IntervalIndexedGeometry", "kts-core"})
public final class IndexedPointInAreaLocator
implements PointOnGeometryLocator {
    @Nullable
    private Geometry geom;
    @Nullable
    private volatile IntervalIndexedGeometry index;

    public IndexedPointInAreaLocator(@Nullable Geometry g) {
        if (!(g instanceof Polygonal) && !(g instanceof LinearRing)) {
            throw new IllegalArgumentException("Argument must be Polygonal or LinearRing");
        }
        this.geom = g;
    }

    @Override
    public int locate(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (this.index == null) {
            this.createIndex();
        }
        RayCrossingCounter rcc = new RayCrossingCounter(p);
        SegmentVisitor visitor = new SegmentVisitor(rcc);
        IntervalIndexedGeometry intervalIndexedGeometry = this.index;
        Intrinsics.checkNotNull((Object)intervalIndexedGeometry);
        intervalIndexedGeometry.query(p.y, p.y, visitor);
        return rcc.getLocation();
    }

    private final void createIndex() {
        if (this.index == null) {
            this.index = new IntervalIndexedGeometry(this.geom);
            this.geom = null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u001b\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator$IntervalIndexedGeometry;", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "isEmpty", "", "index", "Lorg/locationtech/jts/index/intervalrtree/SortedPackedIntervalRTree;", "init", "", "addLine", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)V", "query", "", "min", "", "max", "visitor", "Lorg/locationtech/jts/index/ItemVisitor;", "kts-core"})
    private static final class IntervalIndexedGeometry {
        private boolean isEmpty;
        @NotNull
        private final SortedPackedIntervalRTree index = new SortedPackedIntervalRTree();

        public IntervalIndexedGeometry(@Nullable Geometry geom) {
            Geometry geometry = geom;
            Intrinsics.checkNotNull((Object)geometry);
            if (geometry.isEmpty()) {
                this.isEmpty = true;
            } else {
                this.isEmpty = false;
                this.init(geom);
            }
        }

        private final void init(Geometry geom) {
            Geometry geometry = geom;
            Intrinsics.checkNotNull((Object)geometry);
            List<Geometry> lines = LinearComponentExtracter.Companion.getLines(geometry);
            for (Geometry geometry2 : lines) {
                Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                LineString line = (LineString)geometry2;
                Coordinate[] pts = line.getCoordinates();
                this.addLine(pts);
            }
        }

        private final void addLine(Coordinate[] pts) {
            int n = pts.length;
            for (int i = 1; i < n; ++i) {
                LineSegment seg = new LineSegment(pts[i - 1], pts[i]);
                double min = Math.min(seg.p0.y, seg.p1.y);
                double max = Math.max(seg.p0.y, seg.p1.y);
                this.index.insert(min, max, seg);
            }
        }

        @NotNull
        public final List<?> query(double min, double max) {
            if (this.isEmpty) {
                return new ArrayList();
            }
            ArrayListVisitor visitor = new ArrayListVisitor();
            this.index.query(min, max, visitor);
            return visitor.getItems();
        }

        public final void query(double min, double max, @Nullable ItemVisitor visitor) {
            if (this.isEmpty) {
                return;
            }
            this.index.query(min, max, visitor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator$SegmentVisitor;", "Lorg/locationtech/jts/index/ItemVisitor;", "counter", "Lorg/locationtech/jts/algorithm/RayCrossingCounter;", "<init>", "(Lorg/locationtech/jts/algorithm/RayCrossingCounter;)V", "visitItem", "", "item", "", "kts-core"})
    private static final class SegmentVisitor
    implements ItemVisitor {
        @NotNull
        private final RayCrossingCounter counter;

        public SegmentVisitor(@NotNull RayCrossingCounter counter) {
            Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
            this.counter = counter;
        }

        @Override
        public void visitItem(@Nullable Object item) {
            LineSegment seg;
            LineSegment lineSegment = seg = (LineSegment)item;
            Intrinsics.checkNotNull((Object)lineSegment);
            this.counter.countSegment(lineSegment.getCoordinate(0), seg.getCoordinate(1));
        }
    }
}

