/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.locate;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryCollectionIterator;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/algorithm/locate/SimplePointInAreaLocator;", "Lorg/locationtech/jts/algorithm/locate/PointOnGeometryLocator;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "locate", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "Companion", "kts-core"})
public final class SimplePointInAreaLocator
implements PointOnGeometryLocator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry geom;

    public SimplePointInAreaLocator(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        this.geom = geom;
    }

    @Override
    public int locate(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return Companion.locate(p, this.geom);
    }

    @JvmStatic
    public static final boolean containsPointInPolygon(@NotNull Coordinate p, @NotNull Polygon poly) {
        return Companion.containsPointInPolygon(p, poly);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001a\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/algorithm/locate/SimplePointInAreaLocator$Companion;", "", "<init>", "()V", "locate", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "isContained", "", "locateInGeometry", "locatePointInPolygon", "poly", "Lorg/locationtech/jts/geom/Polygon;", "containsPointInPolygon", "locatePointInRing", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int locate(@NotNull Coordinate p, @NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            if (geom.isEmpty()) {
                return 2;
            }
            return !geom.getEnvelopeInternal().intersects(p) ? 2 : this.locateInGeometry(p, geom);
        }

        public final boolean isContained(@NotNull Coordinate p, @NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            return 2 != this.locate(p, geom);
        }

        private final int locateInGeometry(Coordinate p, Geometry geom) {
            if (geom instanceof Polygon) {
                return this.locatePointInPolygon(p, (Polygon)geom);
            }
            if (geom instanceof GeometryCollection) {
                Iterator geomi = new GeometryCollectionIterator(geom);
                while (geomi.hasNext()) {
                    int loc;
                    Object e = geomi.next();
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
                    Geometry g2 = (Geometry)e;
                    if (g2 == geom || (loc = this.locateInGeometry(p, g2)) == 2) continue;
                    return loc;
                }
            }
            return 2;
        }

        public final int locatePointInPolygon(@NotNull Coordinate p, @NotNull Polygon poly) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)poly, (String)"poly");
            if (poly.isEmpty()) {
                return 2;
            }
            LinearRing shell = poly.getExteriorRing();
            int shellLoc = this.locatePointInRing(p, shell);
            if (shellLoc != 0) {
                return shellLoc;
            }
            int n = poly.getNumInteriorRing();
            for (int i = 0; i < n; ++i) {
                LinearRing hole = poly.getInteriorRingN(i);
                int holeLoc = this.locatePointInRing(p, hole);
                if (holeLoc == 1) {
                    return 1;
                }
                if (holeLoc != 0) continue;
                return 2;
            }
            return 0;
        }

        @JvmStatic
        public final boolean containsPointInPolygon(@NotNull Coordinate p, @NotNull Polygon poly) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)poly, (String)"poly");
            return 2 != this.locatePointInPolygon(p, poly);
        }

        private final int locatePointInRing(Coordinate p, LinearRing ring) {
            LinearRing linearRing = ring;
            Intrinsics.checkNotNull((Object)linearRing);
            return !linearRing.getEnvelopeInternal().intersects(p) ? 2 : PointLocation.locateInRing(p, ring.getCoordinates());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

