/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.match;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.distance.DiscreteFrechetDistance;
import org.locationtech.jts.algorithm.match.HausdorffSimilarityMeasure;
import org.locationtech.jts.algorithm.match.SimilarityMeasure;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/algorithm/match/FrechetSimilarityMeasure;", "Lorg/locationtech/jts/algorithm/match/SimilarityMeasure;", "<init>", "()V", "measure", "", "g1", "Lorg/locationtech/jts/geom/Geometry;", "g2", "kts-core"})
public final class FrechetSimilarityMeasure
implements SimilarityMeasure {
    @Override
    public double measure(@NotNull Geometry g1, @NotNull Geometry g2) {
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        if (!Intrinsics.areEqual((Object)g1.getGeometryType(), (Object)g2.getGeometryType())) {
            throw new IllegalArgumentException("g1 and g2 are of different type");
        }
        double frechetDistance = DiscreteFrechetDistance.Companion.distance(g1, g2);
        if (frechetDistance == 0.0) {
            return 1.0;
        }
        Envelope env = new Envelope(g1.getEnvelopeInternal());
        env.expandToInclude(g2.getEnvelopeInternal());
        double envDiagSize = HausdorffSimilarityMeasure.Companion.diagonalSize(env);
        return 1.0 - frechetDistance / envDiagSize;
    }
}

