/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.match;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.distance.DiscreteHausdorffDistance;
import org.locationtech.jts.algorithm.match.SimilarityMeasure;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/algorithm/match/HausdorffSimilarityMeasure;", "Lorg/locationtech/jts/algorithm/match/SimilarityMeasure;", "<init>", "()V", "measure", "", "g1", "Lorg/locationtech/jts/geom/Geometry;", "g2", "Companion", "kts-core"})
public final class HausdorffSimilarityMeasure
implements SimilarityMeasure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double DENSIFY_FRACTION = 0.25;

    @Override
    public double measure(@NotNull Geometry g1, @NotNull Geometry g2) {
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        double distance = DiscreteHausdorffDistance.Companion.distance(g1, g2, 0.25);
        if (distance == 0.0) {
            return 1.0;
        }
        Envelope env = new Envelope(g1.getEnvelopeInternal());
        env.expandToInclude(g2.getEnvelopeInternal());
        double envSize = Companion.diagonalSize(env);
        return 1.0 - distance / envSize;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/algorithm/match/HausdorffSimilarityMeasure$Companion;", "", "<init>", "()V", "DENSIFY_FRACTION", "", "diagonalSize", "env", "Lorg/locationtech/jts/geom/Envelope;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final double diagonalSize(@NotNull Envelope env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (env.isNull()) {
                return 0.0;
            }
            double width = env.getWidth();
            double hgt = env.getHeight();
            return Math.INSTANCE.sqrt(width * width + hgt * hgt);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

