/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u001a\f\u0010\b\u001a\u00020\t*\u00020\tH\u0002\u001a\f\u0010\b\u001a\u00020\n*\u00020\nH\u0002\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0006\u001a\f\u0010\b\u001a\u00020\u000b*\u00020\u000bH\u0002\u001a\f\u0010\b\u001a\u00020\f*\u00020\fH\u0002\u001a\f\u0010\b\u001a\u00020\r*\u00020\rH\u0002\u001a\n\u0010\b\u001a\u00020\u000e*\u00020\u000e\u00a8\u0006\u000f"}, d2={"removeDuplicatePoints", "", "Lorg/locationtech/jts/geom/Coordinate;", "coord", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "cleanPolygon", "Lorg/locationtech/jts/geom/Polygon;", "poly", "clean", "Lorg/locationtech/jts/geom/LinearRing;", "Lorg/locationtech/jts/geom/LineString;", "Lorg/locationtech/jts/geom/MultiPolygon;", "Lorg/locationtech/jts/geom/MultiLineString;", "Lorg/locationtech/jts/geom/GeometryCollection;", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
@SourceDebugExtension(value={"SMAP\nCleanDuplicatePoints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanDuplicatePoints.kt\norg/locationtech/jts/clean/CleanDuplicatePointsKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,99:1\n37#2,2:100\n*S KotlinDebug\n*F\n+ 1 CleanDuplicatePoints.kt\norg/locationtech/jts/clean/CleanDuplicatePointsKt\n*L\n14#1:100,2\n*E\n"})
public final class CleanDuplicatePointsKt {
    @NotNull
    public static final Coordinate[] removeDuplicatePoints(@NotNull Coordinate[] coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        List uniqueCoords = new ArrayList();
        Coordinate lastPt = null;
        int n = coord.length;
        for (int i = 0; i < n; ++i) {
            if (lastPt != null && Intrinsics.areEqual((Object)lastPt, (Object)coord[i])) continue;
            lastPt = coord[i];
            uniqueCoords.add(new Coordinate(lastPt));
        }
        Collection $this$toTypedArray$iv = uniqueCoords;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Coordinate[0]);
    }

    @Nullable
    public static final Polygon cleanPolygon(@Nullable Polygon poly) {
        if (poly != null) {
            return CleanDuplicatePointsKt.clean(poly);
        }
        return null;
    }

    private static final LinearRing clean(LinearRing $this$clean) {
        GeometryFactory fact = $this$clean.getFactory();
        Coordinate[] coords = CleanDuplicatePointsKt.removeDuplicatePoints($this$clean.getCoordinates());
        return fact.createLinearRing(coords);
    }

    private static final LineString clean(LineString $this$clean) {
        GeometryFactory fact = $this$clean.getFactory();
        Coordinate[] coords = CleanDuplicatePointsKt.removeDuplicatePoints($this$clean.getCoordinates());
        return fact.createLineString(coords);
    }

    @NotNull
    public static final Polygon clean(@NotNull Polygon $this$clean) {
        Intrinsics.checkNotNullParameter((Object)$this$clean, (String)"<this>");
        GeometryFactory fact = $this$clean.getFactory();
        LinearRing linearRing = $this$clean.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        Coordinate[] shellCoords = CleanDuplicatePointsKt.removeDuplicatePoints(linearRing.getCoordinates());
        LinearRing shell = fact.createLinearRing(shellCoords);
        List holes = new ArrayList();
        int n = $this$clean.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            Coordinate[] holeCoords = CleanDuplicatePointsKt.removeDuplicatePoints($this$clean.getInteriorRingN(i).getCoordinates());
            holes.add(fact.createLinearRing(holeCoords));
        }
        return fact.createPolygon(shell, GeometryFactory.Companion.toLinearRingArray(holes));
    }

    private static final MultiPolygon clean(MultiPolygon $this$clean) {
        GeometryFactory fact = $this$clean.getFactory();
        List polys = new ArrayList();
        int n = $this$clean.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = $this$clean.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            Polygon poly = (Polygon)geometry;
            polys.add(CleanDuplicatePointsKt.clean(poly));
        }
        return fact.createMultiPolygon(GeometryFactory.Companion.toPolygonArray(polys));
    }

    private static final MultiLineString clean(MultiLineString $this$clean) {
        GeometryFactory fact = $this$clean.getFactory();
        List lines = new ArrayList();
        int n = $this$clean.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = $this$clean.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line = (LineString)geometry;
            lines.add(CleanDuplicatePointsKt.clean(line));
        }
        return fact.createMultiLineString(GeometryFactory.Companion.toLineStringArray(lines));
    }

    private static final GeometryCollection clean(GeometryCollection $this$clean) {
        GeometryFactory fact = $this$clean.getFactory();
        List geoms = new ArrayList();
        int n = $this$clean.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geom = $this$clean.getGeometryN(i);
            geoms.add(CleanDuplicatePointsKt.clean(geom));
        }
        return fact.createGeometryCollection(GeometryFactory.Companion.toGeometryArray(geoms));
    }

    @NotNull
    public static final Geometry clean(@NotNull Geometry $this$clean) {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)$this$clean, (String)"<this>");
        GeometryFactory fact = $this$clean.getFactory();
        if ($this$clean.isEmpty()) {
            return $this$clean;
        }
        if ($this$clean instanceof Point) {
            geometry = $this$clean;
        } else if ($this$clean instanceof MultiPoint) {
            geometry = $this$clean;
        } else if ($this$clean instanceof LinearRing) {
            geometry = CleanDuplicatePointsKt.clean((LinearRing)$this$clean);
        } else if ($this$clean instanceof LineString) {
            geometry = CleanDuplicatePointsKt.clean((LineString)$this$clean);
        } else if ($this$clean instanceof Polygon) {
            geometry = CleanDuplicatePointsKt.clean((Polygon)$this$clean);
        } else if ($this$clean instanceof MultiLineString) {
            geometry = CleanDuplicatePointsKt.clean((MultiLineString)$this$clean);
        } else if ($this$clean instanceof MultiPolygon) {
            geometry = CleanDuplicatePointsKt.clean((MultiPolygon)$this$clean);
        } else if ($this$clean instanceof GeometryCollection) {
            geometry = CleanDuplicatePointsKt.clean((GeometryCollection)$this$clean);
        } else {
            throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass($this$clean.getClass()).getSimpleName());
        }
        return geometry;
    }
}

