/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.edgegraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.edgegraph.HalfEdge;
import org.locationtech.jts.geom.Coordinate;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0014J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\"\u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/edgegraph/EdgeGraph;", "", "<init>", "()V", "vertexMap", "", "Lorg/locationtech/jts/geom/Coordinate;", "Lorg/locationtech/jts/edgegraph/HalfEdge;", "createEdge", "orig", "create", "p0", "p1", "addEdge", "dest", "insert", "eAdj", "vertexEdges", "", "getVertexEdges", "()Ljava/util/Collection;", "findEdge", "Companion", "kts-core"})
public class EdgeGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Coordinate, HalfEdge> vertexMap = new HashMap();

    @NotNull
    protected HalfEdge createEdge(@NotNull Coordinate orig) {
        Intrinsics.checkNotNullParameter((Object)orig, (String)"orig");
        return new HalfEdge(orig);
    }

    private final HalfEdge create(Coordinate p0, Coordinate p1) {
        HalfEdge e0 = this.createEdge(p0);
        HalfEdge e1 = this.createEdge(p1);
        e0.link(e1);
        return e0;
    }

    @Nullable
    public final HalfEdge addEdge(@NotNull Coordinate orig, @NotNull Coordinate dest) {
        HalfEdge halfEdge;
        Intrinsics.checkNotNullParameter((Object)orig, (String)"orig");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!Companion.isValidEdge(orig, dest)) {
            return null;
        }
        HalfEdge eAdj = this.vertexMap.get(orig);
        HalfEdge eSame = null;
        if (eAdj != null) {
            eSame = eAdj.find(dest);
        }
        if ((halfEdge = eSame) == null) {
            halfEdge = this.insert(orig, dest, eAdj);
        }
        return halfEdge;
    }

    private final HalfEdge insert(Coordinate orig, Coordinate dest, HalfEdge eAdj) {
        HalfEdge e = this.create(orig, dest);
        if (eAdj != null) {
            eAdj.insert(e);
        } else {
            this.vertexMap.put(orig, e);
        }
        HalfEdge eAdjDest = this.vertexMap.get(dest);
        if (eAdjDest != null) {
            eAdjDest.insert(e.sym());
        } else {
            HalfEdge halfEdge = e.sym();
            Intrinsics.checkNotNull((Object)halfEdge);
            this.vertexMap.put(dest, halfEdge);
        }
        return e;
    }

    @NotNull
    public final Collection<HalfEdge> getVertexEdges() {
        return this.vertexMap.values();
    }

    @Nullable
    public final HalfEdge findEdge(@Nullable Coordinate orig, @Nullable Coordinate dest) {
        HalfEdge halfEdge = this.vertexMap.get(orig);
        if (halfEdge == null) {
            return null;
        }
        HalfEdge e = halfEdge;
        return e.find(dest);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/edgegraph/EdgeGraph$Companion;", "", "<init>", "()V", "isValidEdge", "", "orig", "Lorg/locationtech/jts/geom/Coordinate;", "dest", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValidEdge(@Nullable Coordinate orig, @NotNull Coordinate dest) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            int cmp = dest.compareTo(orig);
            return cmp != 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

