/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.edgegraph;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.edgegraph.EdgeGraph;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\b\u001a\u00020\t2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/edgegraph/EdgeGraphBuilder;", "", "<init>", "()V", "graph", "Lorg/locationtech/jts/edgegraph/EdgeGraph;", "getGraph", "()Lorg/locationtech/jts/edgegraph/EdgeGraph;", "add", "", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "geometries", "", "lineString", "Lorg/locationtech/jts/geom/LineString;", "Companion", "kts-core"})
public final class EdgeGraphBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EdgeGraph graph = new EdgeGraph();

    @NotNull
    public final EdgeGraph getGraph() {
        return this.graph;
    }

    public final void add(@NotNull Geometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        geometry.apply(new GeometryComponentFilter(this){
            final /* synthetic */ EdgeGraphBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            public void filter(Geometry component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                if (component instanceof LineString) {
                    EdgeGraphBuilder.access$add(this.this$0, (LineString)component);
                }
            }
        });
    }

    public final void add(@NotNull Collection<?> geometries) {
        Intrinsics.checkNotNullParameter(geometries, (String)"geometries");
        for (Object obj : geometries) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry geometry = (Geometry)obj;
            this.add(geometry);
        }
    }

    private final void add(LineString lineString) {
        CoordinateSequence seq = lineString.getCoordinateSequence();
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size();
        for (int i = 1; i < n; ++i) {
            this.graph.addEdge(seq.getCoordinate(i - 1), seq.getCoordinate(i));
        }
    }

    @JvmStatic
    @NotNull
    public static final EdgeGraph build(@NotNull Collection<?> geoms) {
        return Companion.build(geoms);
    }

    public static final /* synthetic */ void access$add(EdgeGraphBuilder $this, LineString lineString) {
        $this.add(lineString);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/edgegraph/EdgeGraphBuilder$Companion;", "", "<init>", "()V", "build", "Lorg/locationtech/jts/edgegraph/EdgeGraph;", "geoms", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EdgeGraph build(@NotNull Collection<?> geoms) {
            Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
            EdgeGraphBuilder builder = new EdgeGraphBuilder();
            builder.add(geoms);
            return builder.getGraph();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

