/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Cloneable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0010\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001=B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0017\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u001f\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0012J3\u0010\u0015\u001a\u00020\n2\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0015\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u0015\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u0015\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u001e\u001a\u00020\n2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020 2\u0006\u0010\t\u001a\u00020\nJ\b\u0010!\u001a\u00020\u0010H\u0016J\u0011\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010#J\u0019\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010$\u001a\u00020\n\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u001dH\u0016J\u0011\u0010\u0015\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0002H\u0096\u0001J\u0019\u0010\u0015\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0002H\u0096\u0001J\u0017\u0010\u001e\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0096\u0001J\u001f\u0010\u001e\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0096\u0001J\t\u0010*\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010+\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0002H\u0096\u0003J\u0017\u0010,\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0096\u0001J\u0011\u0010-\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0012H\u0096\u0003J\u0011\u0010.\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0002H\u0096\u0001J\t\u0010/\u001a\u00020\nH\u0096\u0001J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000201H\u0096\u0003J\u0011\u00102\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0002H\u0096\u0001J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000204H\u0096\u0001J\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020\u0002042\u0006\u0010(\u001a\u00020\u0012H\u0096\u0001J\u0011\u00105\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0002H\u0096\u0001J\u0017\u00106\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0096\u0001J\u0011\u00107\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0012H\u0096\u0001J\u0017\u00108\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0096\u0001J\u0019\u00109\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0002H\u0096\u0003J\u001f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u0012H\u0096\u0001R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\t\u0010\u0011\u001a\u00020\u0012X\u0096\u0005\u00a8\u0006>"}, d2={"Lorg/locationtech/jts/geom/CoordinateList;", "", "Lorg/locationtech/jts/geom/Coordinate;", "Lorg/locationtech/jts/legacy/Cloneable;", "<init>", "()V", "coord", "", "([Lorg/locationtech/jts/geom/Coordinate;)V", "allowRepeated", "", "([Lorg/locationtech/jts/geom/Coordinate;Z)V", "coordArrayType", "coordArrayType$1", "[Lorg/locationtech/jts/geom/Coordinate;", "ensureCapacity", "", "size", "", "getCoordinate", "i", "add", "start", "end", "([Lorg/locationtech/jts/geom/Coordinate;ZII)Z", "direction", "([Lorg/locationtech/jts/geom/Coordinate;ZZ)Z", "([Lorg/locationtech/jts/geom/Coordinate;Z)Z", "obj", "", "addAll", "coll", "", "closeRing", "toCoordinateArray", "()[Lorg/locationtech/jts/geom/Coordinate;", "isForward", "(Z)[Lorg/locationtech/jts/geom/Coordinate;", "clone", "element", "index", "elements", "clear", "contains", "containsAll", "get", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "subList", "fromIndex", "toIndex", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nCoordinateList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordinateList.kt\norg/locationtech/jts/geom/CoordinateList\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,238:1\n37#2,2:239\n37#2,2:241\n37#2,2:243\n*S KotlinDebug\n*F\n+ 1 CoordinateList.kt\norg/locationtech/jts/geom/CoordinateList\n*L\n196#1:239,2\n210#1:241,2\n223#1:243,2\n*E\n"})
public final class CoordinateList
implements List<Coordinate>,
Cloneable,
KMutableList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ ArrayList<Coordinate> $$delegate_0;
    @NotNull
    private final Coordinate[] coordArrayType$1;
    private static final long serialVersionUID = -1626110935756089896L;
    @NotNull
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public CoordinateList() {
        this.$$delegate_0 = new ArrayList();
        this.coordArrayType$1 = new Coordinate[0];
    }

    public CoordinateList(@NotNull Coordinate[] coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        this();
        this.ensureCapacity(coord.length);
        this.add(coord, true);
    }

    public CoordinateList(@NotNull Coordinate[] coord, boolean allowRepeated) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        this();
        this.ensureCapacity(coord.length);
        this.add(coord, allowRepeated);
    }

    private final void ensureCapacity(int size) {
    }

    @NotNull
    public final Coordinate getCoordinate(int i) {
        return this.get(i);
    }

    public final boolean add(@NotNull Coordinate[] coord, boolean allowRepeated, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        int inc = 1;
        if (start > end) {
            inc = -1;
        }
        for (int i = start; i != end; i += inc) {
            this.add((Object)coord[i], allowRepeated);
        }
        return true;
    }

    public final boolean add(@NotNull Coordinate[] coord, boolean allowRepeated, boolean direction) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        if (direction) {
            int n = coord.length;
            for (int i = 0; i < n; ++i) {
                this.add(coord[i], allowRepeated);
            }
        } else {
            int n = coord.length + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    this.add(coord[i], allowRepeated);
                } while (0 <= n);
            }
        }
        return true;
    }

    public final boolean add(@NotNull Coordinate[] coord, boolean allowRepeated) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        this.add(coord, allowRepeated, true);
        return true;
    }

    public final boolean add(@Nullable Object obj, boolean allowRepeated) {
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
        this.add((Coordinate)obj, allowRepeated);
        return true;
    }

    public final void add(@NotNull Coordinate coord, boolean allowRepeated) {
        Coordinate last;
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        if (!allowRepeated && this.size() >= 1 && (last = this.get(this.size() - 1)).equals2D(coord)) {
            return;
        }
        this.add(coord);
    }

    public final void add(int i, @NotNull Coordinate coord, boolean allowRepeated) {
        int size;
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        if (!allowRepeated && (size = this.size()) > 0) {
            Coordinate next;
            Coordinate prev;
            if (i > 0 && (prev = this.get(i - 1)).equals2D(coord)) {
                return;
            }
            if (i < size && (next = this.get(i)).equals2D(coord)) {
                return;
            }
        }
        this.add(i, coord);
    }

    public final boolean addAll(@NotNull Collection<? extends Coordinate> coll, boolean allowRepeated) {
        Intrinsics.checkNotNullParameter(coll, (String)"coll");
        boolean isChanged = false;
        Iterator<? extends Coordinate> i = coll.iterator();
        while (i.hasNext()) {
            this.add((Object)i.next(), allowRepeated);
            isChanged = true;
        }
        return isChanged;
    }

    public void closeRing() {
        if (this.size() > 0) {
            Coordinate duplicate = this.get(0).copy();
            this.add(duplicate, false);
        }
    }

    @NotNull
    public final Coordinate[] toCoordinateArray() {
        Collection $this$toTypedArray$iv = this;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Coordinate[] coordinateArray = thisCollection$iv.toArray(new Coordinate[0]);
        Coordinate[] coordinateArray2 = Arrays.copyOf(coordinateArray, coordinateArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)coordinateArray2, (String)"copyOf(...)");
        return coordinateArray2;
    }

    @NotNull
    public final Coordinate[] toCoordinateArray(boolean isForward) {
        if (isForward) {
            Coordinate[] $this$toTypedArray$iv = (Coordinate[])this;
            boolean $i$f$toTypedArray = false;
            Coordinate[] thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = thisCollection$iv.toArray(new Coordinate[0]);
            Coordinate[] coordinateArray = Arrays.copyOf($this$toTypedArray$iv, $this$toTypedArray$iv.length);
            Intrinsics.checkNotNullExpressionValue((Object)coordinateArray, (String)"copyOf(...)");
            return coordinateArray;
        }
        int size = this.size();
        int n = 0;
        Coordinate[] coordinateArray = new Coordinate[size];
        while (n < size) {
            int n2 = n++;
            coordinateArray[n2] = this.get(size - n2 - 1);
        }
        return coordinateArray;
    }

    @Override
    @NotNull
    public Object clone() {
        Collection $this$toTypedArray$iv = this;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new CoordinateList(thisCollection$iv.toArray(new Coordinate[0]), true);
    }

    @Override
    public boolean add(@NotNull Coordinate element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.$$delegate_0.add(element);
    }

    @Override
    public void add(int index, @NotNull Coordinate element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.$$delegate_0.add(index, element);
    }

    public boolean remove(@NotNull Coordinate element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.$$delegate_0.remove(element);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Coordinate> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.$$delegate_0.addAll(elements);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends Coordinate> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.$$delegate_0.addAll(index, elements);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.$$delegate_0.removeAll(elements);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.$$delegate_0.retainAll(elements);
    }

    @Override
    public void clear() {
        this.$$delegate_0.clear();
    }

    @Override
    @NotNull
    public Coordinate set(int index, @NotNull Coordinate element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Coordinate coordinate = this.$$delegate_0.set(index, element);
        Intrinsics.checkNotNullExpressionValue((Object)coordinate, (String)"set(...)");
        return coordinate;
    }

    @NotNull
    public Coordinate removeAt(int index) {
        Coordinate coordinate = this.$$delegate_0.remove(index);
        Intrinsics.checkNotNullExpressionValue((Object)coordinate, (String)"removeAt(...)");
        return coordinate;
    }

    @Override
    @NotNull
    public ListIterator<Coordinate> listIterator() {
        ListIterator<Coordinate> listIterator = this.$$delegate_0.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"listIterator(...)");
        return listIterator;
    }

    @Override
    @NotNull
    public ListIterator<Coordinate> listIterator(int index) {
        ListIterator<Coordinate> listIterator = this.$$delegate_0.listIterator(index);
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"listIterator(...)");
        return listIterator;
    }

    @Override
    @NotNull
    public List<Coordinate> subList(int fromIndex, int toIndex) {
        List<Coordinate> list = this.$$delegate_0.subList(fromIndex, toIndex);
        Intrinsics.checkNotNullExpressionValue(list, (String)"subList(...)");
        return list;
    }

    public int getSize() {
        return this.$$delegate_0.size();
    }

    @Override
    public boolean isEmpty() {
        return this.$$delegate_0.isEmpty();
    }

    public boolean contains(@NotNull Coordinate element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.$$delegate_0.contains(element);
    }

    @Override
    @NotNull
    public Iterator<Coordinate> iterator() {
        Iterator<Coordinate> iterator2 = this.$$delegate_0.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        return iterator2;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.$$delegate_0.containsAll(elements);
    }

    @Override
    @NotNull
    public Coordinate get(int index) {
        Coordinate coordinate = this.$$delegate_0.get(index);
        Intrinsics.checkNotNullExpressionValue((Object)coordinate, (String)"get(...)");
        return coordinate;
    }

    public int indexOf(@NotNull Coordinate element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.$$delegate_0.indexOf(element);
    }

    public int lastIndexOf(@NotNull Coordinate element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.$$delegate_0.lastIndexOf(element);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/geom/CoordinateList$Companion;", "", "<init>", "()V", "serialVersionUID", "", "coordArrayType", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

