/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.util.GeometryCollectionMapper;
import org.locationtech.jts.geom.util.GeometryMapper;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.locationtech.jts.operation.union.UnaryUnionOp;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0007J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J\u0016\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/geom/GeometryOverlay;", "", "<init>", "()V", "OVERLAY_PROPERTY_NAME", "", "OVERLAY_PROPERTY_VALUE_NG", "OVERLAY_PROPERTY_VALUE_OLD", "OVERLAY_NG_DEFAULT", "", "getOVERLAY_NG_DEFAULT", "()Z", "setOVERLAY_NG_DEFAULT", "(Z)V", "isOverlayNG", "setOverlayImpl", "", "overlayImplCode", "overlay", "Lorg/locationtech/jts/geom/Geometry;", "a", "b", "opCode", "", "difference", "intersection", "symDifference", "union", "kts-core"})
public final class GeometryOverlay {
    @NotNull
    public static final GeometryOverlay INSTANCE = new GeometryOverlay();
    @JvmField
    @NotNull
    public static String OVERLAY_PROPERTY_NAME = "jts.overlay";
    @JvmField
    @NotNull
    public static String OVERLAY_PROPERTY_VALUE_NG = "ng";
    @JvmField
    @NotNull
    public static String OVERLAY_PROPERTY_VALUE_OLD = "old";
    private static boolean OVERLAY_NG_DEFAULT;
    private static boolean isOverlayNG;

    private GeometryOverlay() {
    }

    public final boolean getOVERLAY_NG_DEFAULT() {
        return OVERLAY_NG_DEFAULT;
    }

    public final void setOVERLAY_NG_DEFAULT(boolean bl) {
        OVERLAY_NG_DEFAULT = bl;
    }

    @JvmStatic
    public static final void setOverlayImpl(@Nullable String overlayImplCode) {
        if (overlayImplCode == null) {
            return;
        }
        isOverlayNG = OVERLAY_NG_DEFAULT;
        if (StringsKt.equals((String)OVERLAY_PROPERTY_VALUE_NG, (String)overlayImplCode, (boolean)true)) {
            isOverlayNG = true;
        }
    }

    private final Geometry overlay(Geometry a, Geometry b, int opCode) {
        Geometry geometry;
        if (isOverlayNG) {
            Geometry geometry2 = OverlayNGRobust.overlay(a, b, opCode);
            geometry = geometry2;
            Intrinsics.checkNotNull((Object)geometry2);
        } else {
            geometry = SnapIfNeededOverlayOp.Companion.overlayOp(a, b, opCode);
        }
        return geometry;
    }

    @NotNull
    public final Geometry difference(@NotNull Geometry a, @NotNull Geometry b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a.isEmpty()) {
            return OverlayOp.Companion.createEmptyResult(3, a, b, a.getFactory());
        }
        if (b.isEmpty()) {
            return a.copy();
        }
        Geometry.Companion.checkNotGeometryCollection(a);
        Geometry.Companion.checkNotGeometryCollection(b);
        return this.overlay(a, b, 3);
    }

    @NotNull
    public final Geometry intersection(@NotNull Geometry a, @NotNull Geometry b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a.isEmpty() || b.isEmpty()) {
            return OverlayOp.Companion.createEmptyResult(1, a, b, a.getFactory());
        }
        if (a.isGeometryCollection()) {
            Geometry g2 = b;
            return GeometryCollectionMapper.Companion.map((GeometryCollection)a, new GeometryMapper.MapOp(g2){
                final /* synthetic */ Geometry $g2;
                {
                    this.$g2 = $g2;
                }

                public Geometry map(Geometry g) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    return g.intersection(this.$g2);
                }
            });
        }
        return this.overlay(a, b, 1);
    }

    @NotNull
    public final Geometry symDifference(@NotNull Geometry a, @NotNull Geometry b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a.isEmpty() || b.isEmpty()) {
            if (a.isEmpty() && b.isEmpty()) {
                return OverlayOp.Companion.createEmptyResult(4, a, b, a.getFactory());
            }
            if (a.isEmpty()) {
                return b.copy();
            }
            if (b.isEmpty()) {
                return a.copy();
            }
        }
        Geometry.Companion.checkNotGeometryCollection(a);
        Geometry.Companion.checkNotGeometryCollection(b);
        return this.overlay(a, b, 4);
    }

    @NotNull
    public final Geometry union(@NotNull Geometry a, @NotNull Geometry b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a.isEmpty() || b.isEmpty()) {
            if (a.isEmpty() && b.isEmpty()) {
                return OverlayOp.Companion.createEmptyResult(2, a, b, a.getFactory());
            }
            if (a.isEmpty()) {
                return b.copy();
            }
            if (b.isEmpty()) {
                return a.copy();
            }
        }
        Geometry.Companion.checkNotGeometryCollection(a);
        Geometry.Companion.checkNotGeometryCollection(b);
        return this.overlay(a, b, 2);
    }

    @Nullable
    public final Geometry union(@NotNull Geometry a) {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (isOverlayNG) {
            geometry = OverlayNGRobust.union(a);
        } else {
            Geometry geometry2 = UnaryUnionOp.Companion.union(a);
            geometry = geometry2;
            Intrinsics.checkNotNull((Object)geometry2);
        }
        return geometry;
    }

    static {
        isOverlayNG = OVERLAY_NG_DEFAULT;
    }
}

