/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 42\u00060\u0001j\u0002`\u00022\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003:\u000234B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB!\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0011J\u0006\u0010\u001e\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\u000bJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0007J\u0012\u0010$\u001a\u00020&2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\u0012\u0010(\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010&H\u0007J\u0018\u0010(\u001a\u00020 2\u0006\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020&H\u0007J\u000e\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bJ\u000e\u0010)\u001a\u00020 2\u0006\u0010+\u001a\u00020&J\b\u0010,\u001a\u00020-H\u0016J\u0013\u0010.\u001a\u00020\u00182\b\u0010/\u001a\u0004\u0018\u00010\u0004H\u0096\u0002J\b\u00100\u001a\u00020\u001bH\u0016J\u0013\u00101\u001a\u00020\u001b2\b\u00102\u001a\u0004\u0018\u00010\u0004H\u0096\u0002R\u001e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\r\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b#\u0010\"\u00a8\u00065"}, d2={"Lorg/locationtech/jts/geom/PrecisionModel;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "", "", "<init>", "()V", "modelType", "Lorg/locationtech/jts/geom/PrecisionModel$Type;", "(Lorg/locationtech/jts/geom/PrecisionModel$Type;)V", "scale", "", "offsetX", "offsetY", "(DDD)V", "(D)V", "pm", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "value", "type", "getType", "()Lorg/locationtech/jts/geom/PrecisionModel$Type;", "gridSize", "isFloating", "", "()Z", "maximumSignificantDigits", "", "getMaximumSignificantDigits", "()I", "getScale", "setScale", "", "getOffsetX", "()D", "getOffsetY", "toInternal", "external", "Lorg/locationtech/jts/geom/Coordinate;", "internal", "toExternal", "makePrecise", "val", "coord", "toString", "", "equals", "other", "hashCode", "compareTo", "o", "Type", "Companion", "kts-core"})
public final class PrecisionModel
implements Serializable,
Comparable<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Type type;
    private double scale;
    private double gridSize;
    private static final long serialVersionUID = 7777263578777803835L;
    @JvmField
    @NotNull
    public static final Type FIXED = new Type("FIXED");
    @JvmField
    @NotNull
    public static final Type FLOATING = new Type("FLOATING");
    @JvmField
    @NotNull
    public static final Type FLOATING_SINGLE = new Type("FLOATING SINGLE");
    public static final double maximumPreciseValue = 9.007199254740992E15;

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public PrecisionModel() {
        this.type = FLOATING;
    }

    public PrecisionModel(@NotNull Type modelType) {
        Intrinsics.checkNotNullParameter((Object)modelType, (String)"modelType");
        this.type = modelType;
        if (Intrinsics.areEqual((Object)modelType, (Object)FIXED)) {
            this.setScale(1.0);
        }
    }

    @Deprecated(message="offsets are no longer supported, since internal representation is rounded floating point")
    public PrecisionModel(double scale, double offsetX, double offsetY) {
        this.type = FIXED;
        this.setScale(scale);
    }

    public PrecisionModel(double scale) {
        this.type = FIXED;
        this.setScale(scale);
    }

    public PrecisionModel(@NotNull PrecisionModel pm) {
        Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
        this.type = pm.type;
        this.scale = pm.scale;
        this.gridSize = pm.gridSize;
    }

    public final boolean isFloating() {
        return Intrinsics.areEqual((Object)this.type, (Object)FLOATING) || Intrinsics.areEqual((Object)this.type, (Object)FLOATING_SINGLE);
    }

    public final int getMaximumSignificantDigits() {
        int maxSigDigits = 16;
        if (Intrinsics.areEqual((Object)this.type, (Object)FLOATING)) {
            maxSigDigits = 16;
        } else if (Intrinsics.areEqual((Object)this.type, (Object)FLOATING_SINGLE)) {
            maxSigDigits = 6;
        } else if (Intrinsics.areEqual((Object)this.type, (Object)FIXED)) {
            maxSigDigits = 1 + (int)Math.INSTANCE.ceil(Math.INSTANCE.log(this.getScale()) / Math.INSTANCE.log(10.0));
        }
        return maxSigDigits;
    }

    public final double getScale() {
        return this.scale;
    }

    public final double gridSize() {
        if (this.isFloating()) {
            return Double.NaN;
        }
        return !(this.gridSize == 0.0) ? this.gridSize : 1.0 / this.scale;
    }

    private final void setScale(double scale) {
        if (scale < 0.0) {
            this.gridSize = Math.INSTANCE.abs(scale);
            this.scale = 1.0 / this.gridSize;
        } else {
            this.scale = Math.INSTANCE.abs(scale);
            this.gridSize = 0.0;
        }
    }

    @Deprecated(message="Offsets are no longer used")
    public final double getOffsetX() {
        return 0.0;
    }

    @Deprecated(message="Offsets are no longer used")
    public final double getOffsetY() {
        return 0.0;
    }

    @Deprecated(message="use makePrecise instead")
    public final void toInternal(@NotNull Coordinate external, @NotNull Coordinate internal) {
        Intrinsics.checkNotNullParameter((Object)external, (String)"external");
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        if (this.isFloating()) {
            internal.x = external.x;
            internal.y = external.y;
        } else {
            internal.x = this.makePrecise(external.x);
            internal.y = this.makePrecise(external.y);
        }
        internal.setZ(external.getZ());
    }

    @Deprecated(message="use makePrecise instead")
    @NotNull
    public final Coordinate toInternal(@Nullable Coordinate external) {
        Coordinate coordinate = external;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate internal = new Coordinate(coordinate);
        this.makePrecise(internal);
        return internal;
    }

    @Deprecated(message="no longer needed, since internal representation is same as external representation")
    @NotNull
    public final Coordinate toExternal(@Nullable Coordinate internal) {
        Coordinate coordinate = internal;
        Intrinsics.checkNotNull((Object)coordinate);
        return new Coordinate(coordinate);
    }

    @Deprecated(message="no longer needed, since internal representation is same as external representation")
    public final void toExternal(@NotNull Coordinate internal, @NotNull Coordinate external) {
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        Intrinsics.checkNotNullParameter((Object)external, (String)"external");
        external.x = internal.x;
        external.y = internal.y;
    }

    public final double makePrecise(double val) {
        if (Math.INSTANCE.isNaN(val)) {
            return val;
        }
        if (Intrinsics.areEqual((Object)this.type, (Object)FLOATING_SINGLE)) {
            float floatSingleVal = (float)val;
            return floatSingleVal;
        }
        return Intrinsics.areEqual((Object)this.type, (Object)FIXED) ? (this.gridSize > 0.0 ? (double)Math.INSTANCE.round(val / this.gridSize) * this.gridSize : (double)Math.INSTANCE.round(val * this.scale) / this.scale) : val;
    }

    public final void makePrecise(@NotNull Coordinate coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        if (Intrinsics.areEqual((Object)this.type, (Object)FLOATING)) {
            return;
        }
        coord.x = this.makePrecise(coord.x);
        coord.y = this.makePrecise(coord.y);
    }

    @NotNull
    public String toString() {
        Object description = "UNKNOWN";
        if (Intrinsics.areEqual((Object)this.type, (Object)FLOATING)) {
            description = "Floating";
        } else if (Intrinsics.areEqual((Object)this.type, (Object)FLOATING_SINGLE)) {
            description = "Floating-Single";
        } else if (Intrinsics.areEqual((Object)this.type, (Object)FIXED)) {
            description = "Fixed (Scale=" + this.getScale() + ")";
        }
        return description;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof PrecisionModel)) {
            return false;
        }
        Object otherPrecisionModel = other;
        return Intrinsics.areEqual((Object)this.type, (Object)((PrecisionModel)otherPrecisionModel).type) && this.scale == ((PrecisionModel)otherPrecisionModel).scale;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = prime * result2 + (this.type == null ? 0 : this.type.hashCode());
        long temp = Math.INSTANCE.doubleToLongBits(this.scale);
        result2 = prime * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    @Override
    public int compareTo(@Nullable Object o) {
        PrecisionModel other = (PrecisionModel)o;
        int sigDigits = this.getMaximumSignificantDigits();
        PrecisionModel precisionModel = other;
        Intrinsics.checkNotNull((Object)precisionModel);
        int otherSigDigits = precisionModel.getMaximumSignificantDigits();
        return Math.INSTANCE.compare(sigDigits, otherSigDigits);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/geom/PrecisionModel$Companion;", "", "<init>", "()V", "mostPrecise", "Lorg/locationtech/jts/geom/PrecisionModel;", "pm1", "pm2", "serialVersionUID", "", "FIXED", "Lorg/locationtech/jts/geom/PrecisionModel$Type;", "FLOATING", "FLOATING_SINGLE", "maximumPreciseValue", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PrecisionModel mostPrecise(@NotNull PrecisionModel pm1, @Nullable PrecisionModel pm2) {
            Intrinsics.checkNotNullParameter((Object)pm1, (String)"pm1");
            return pm1.compareTo(pm2) >= 0 ? pm1 : pm2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \n2\u00060\u0001j\u0002`\u0002:\u0001\nB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/geom/PrecisionModel$Type;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "name", "", "<init>", "(Ljava/lang/String;)V", "toString", "readResolve", "", "Companion", "kts-core"})
    public static final class Type
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        private static final long serialVersionUID = -5528602631731589822L;
        @NotNull
        private static final Map<String, Type> nameToTypeMap = new HashMap();

        public Type(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            nameToTypeMap.put(this.name, this);
        }

        @NotNull
        public String toString() {
            return this.name;
        }

        private final Object readResolve() {
            return nameToTypeMap.get(this.name);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/geom/PrecisionModel$Type$Companion;", "", "<init>", "()V", "serialVersionUID", "", "nameToTypeMap", "", "", "Lorg/locationtech/jts/geom/PrecisionModel$Type;", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

