/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/geom/Quadrant;", "", "<init>", "()V", "NE", "", "NW", "SW", "SE", "quadrant", "dx", "", "dy", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "isOpposite", "", "quad1", "quad2", "commonHalfPlane", "isInHalfPlane", "quad", "halfPlane", "isNorthern", "kts-core"})
public final class Quadrant {
    @NotNull
    public static final Quadrant INSTANCE = new Quadrant();
    public static final int NE = 0;
    public static final int NW = 1;
    public static final int SW = 2;
    public static final int SE = 3;

    private Quadrant() {
    }

    public final int quadrant(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            throw new IllegalArgumentException("Cannot compute the quadrant for point ( " + dx + ", " + dy + " )");
        }
        return dx >= 0.0 ? (dy >= 0.0 ? 0 : 3) : (dy >= 0.0 ? 1 : 2);
    }

    public final int quadrant(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        if (p1.x == p0.x && p1.y == p0.y) {
            throw new IllegalArgumentException("Cannot compute the quadrant for two identical points " + p0);
        }
        return p1.x >= p0.x ? (p1.y >= p0.y ? 0 : 3) : (p1.y >= p0.y ? 1 : 2);
    }

    public final boolean isOpposite(int quad1, int quad2) {
        if (quad1 == quad2) {
            return false;
        }
        int diff = (quad1 - quad2 + 4) % 4;
        return diff == 2;
    }

    public final int commonHalfPlane(int quad1, int quad2) {
        if (quad1 == quad2) {
            return quad1;
        }
        int diff = (quad1 - quad2 + 4) % 4;
        if (diff == 2) {
            return -1;
        }
        int min = quad1 < quad2 ? quad1 : quad2;
        int max = quad1 > quad2 ? quad1 : quad2;
        return min == 0 && max == 3 ? 3 : min;
    }

    public final boolean isInHalfPlane(int quad, int halfPlane) {
        return halfPlane == 3 ? quad == 3 || quad == 2 : quad == halfPlane || quad == halfPlane + 1;
    }

    public final boolean isNorthern(int quad) {
        return quad == 0 || quad == 1;
    }
}

