/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.util.ComponentCoordinateExtracter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0004J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0004J\u0013\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\u0012\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0012\u0010\u001b\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u001c\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u001d\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/geom/prep/BasicPreparedGeometry;", "Lorg/locationtech/jts/geom/prep/PreparedGeometry;", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "getGeometry", "()Lorg/locationtech/jts/geom/Geometry;", "representativePts", "", "Lorg/locationtech/jts/geom/Coordinate;", "representativePoints", "getRepresentativePoints", "()Ljava/util/List;", "isAnyTargetComponentInTest", "", "testGeom", "envelopesIntersect", "g", "envelopeCovers", "contains", "containsProperly", "coveredBy", "covers", "crosses", "disjoint", "intersects", "overlaps", "touches", "within", "toString", "", "kts-core"})
public class BasicPreparedGeometry
implements PreparedGeometry {
    @NotNull
    private final Geometry geometry;
    @NotNull
    private final List<Coordinate> representativePts;

    public BasicPreparedGeometry(@NotNull Geometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        this.geometry = geometry;
        this.representativePts = ComponentCoordinateExtracter.Companion.getCoordinates(this.geometry);
    }

    @Override
    @NotNull
    public final Geometry getGeometry() {
        return this.geometry;
    }

    @NotNull
    public final List<Coordinate> getRepresentativePoints() {
        return this.representativePts;
    }

    public final boolean isAnyTargetComponentInTest(@Nullable Geometry testGeom) {
        PointLocator locator = new PointLocator();
        Iterator<Coordinate> i = this.representativePts.iterator();
        while (i.hasNext()) {
            Coordinate p;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
            Geometry geometry = testGeom;
            Intrinsics.checkNotNull((Object)geometry);
            if (!locator.intersects(p, geometry)) continue;
            return true;
        }
        return false;
    }

    protected final boolean envelopesIntersect(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return this.geometry.getEnvelopeInternal().intersects(g.getEnvelopeInternal());
    }

    protected final boolean envelopeCovers(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return this.geometry.getEnvelopeInternal().covers(g.getEnvelopeInternal());
    }

    @Override
    public boolean contains(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        return this.geometry.contains(geometry);
    }

    @Override
    public boolean containsProperly(@Nullable Geometry g) {
        Envelope envelope = this.geometry.getEnvelopeInternal();
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        return !envelope.contains(geometry.getEnvelopeInternal()) ? false : this.geometry.relate(g, "T**FF*FF*");
    }

    @Override
    public boolean coveredBy(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        return this.geometry.coveredBy(geometry);
    }

    @Override
    public boolean covers(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        return this.geometry.covers(geometry);
    }

    @Override
    public boolean crosses(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        return this.geometry.crosses(geometry);
    }

    @Override
    public boolean disjoint(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return !this.intersects(g);
    }

    @Override
    public boolean intersects(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return this.geometry.intersects(g);
    }

    @Override
    public boolean overlaps(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        return this.geometry.overlaps(geometry);
    }

    @Override
    public boolean touches(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        return this.geometry.touches(geometry);
    }

    @Override
    public boolean within(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        return this.geometry.within(geometry);
    }

    @NotNull
    public String toString() {
        return this.geometry.toString();
    }
}

