/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedLineString;
import org.locationtech.jts.geom.util.ComponentCoordinateExtracter;
import org.locationtech.jts.noding.FastSegmentSetIntersectionFinder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.SegmentStringUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/geom/prep/PreparedLineStringIntersects;", "", "prepLine", "Lorg/locationtech/jts/geom/prep/PreparedLineString;", "<init>", "(Lorg/locationtech/jts/geom/prep/PreparedLineString;)V", "getPrepLine", "()Lorg/locationtech/jts/geom/prep/PreparedLineString;", "setPrepLine", "intersects", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "isAnyTestPointInTarget", "testGeom", "Companion", "kts-core"})
public final class PreparedLineStringIntersects {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PreparedLineString prepLine;

    public PreparedLineStringIntersects(@NotNull PreparedLineString prepLine) {
        Intrinsics.checkNotNullParameter((Object)prepLine, (String)"prepLine");
        this.prepLine = prepLine;
    }

    @NotNull
    protected final PreparedLineString getPrepLine() {
        return this.prepLine;
    }

    protected final void setPrepLine(@NotNull PreparedLineString preparedLineString) {
        Intrinsics.checkNotNullParameter((Object)preparedLineString, (String)"<set-?>");
        this.prepLine = preparedLineString;
    }

    public final boolean intersects(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        List<SegmentString> lineSegStr = SegmentStringUtil.extractSegmentStrings(geom);
        if (lineSegStr.size() > 0) {
            FastSegmentSetIntersectionFinder fastSegmentSetIntersectionFinder = this.prepLine.getIntersectionFinder();
            Intrinsics.checkNotNull((Object)fastSegmentSetIntersectionFinder);
            boolean segsIntersect = fastSegmentSetIntersectionFinder.intersects((Collection)lineSegStr);
            if (segsIntersect) {
                return true;
            }
        }
        if (geom.getDimension() == 1) {
            return false;
        }
        if (geom.getDimension() == 2 && this.prepLine.isAnyTargetComponentInTest(geom)) {
            return true;
        }
        return geom.getDimension() == 0 ? this.isAnyTestPointInTarget(geom) : false;
    }

    protected final boolean isAnyTestPointInTarget(@Nullable Geometry testGeom) {
        PointLocator locator = new PointLocator();
        Geometry geometry = testGeom;
        Intrinsics.checkNotNull((Object)geometry);
        List<Coordinate> coords = ComponentCoordinateExtracter.Companion.getCoordinates(geometry);
        Iterator<Coordinate> i = coords.iterator();
        while (i.hasNext()) {
            Coordinate p;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
            if (!locator.intersects(p, this.prepLine.getGeometry())) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/geom/prep/PreparedLineStringIntersects$Companion;", "", "<init>", "()V", "intersects", "", "prep", "Lorg/locationtech/jts/geom/prep/PreparedLineString;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean intersects(@NotNull PreparedLineString prep, @NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)prep, (String)"prep");
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            PreparedLineStringIntersects op = new PreparedLineStringIntersects(prep);
            return op.intersects(geom);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

