/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.geom.prep.PreparedPolygonPredicate;
import org.locationtech.jts.noding.FastSegmentSetIntersectionFinder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.SegmentStringUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/geom/prep/PreparedPolygonIntersects;", "Lorg/locationtech/jts/geom/prep/PreparedPolygonPredicate;", "prepPoly", "Lorg/locationtech/jts/geom/prep/PreparedPolygon;", "<init>", "(Lorg/locationtech/jts/geom/prep/PreparedPolygon;)V", "intersects", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "Companion", "kts-core"})
public final class PreparedPolygonIntersects
extends PreparedPolygonPredicate {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public PreparedPolygonIntersects(@NotNull PreparedPolygon prepPoly) {
        Intrinsics.checkNotNullParameter((Object)prepPoly, (String)"prepPoly");
        super(prepPoly);
    }

    public final boolean intersects(@NotNull Geometry geom) {
        boolean isPrepGeomInArea;
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        boolean isInPrepGeomArea = this.isAnyTestComponentInTarget(geom);
        if (isInPrepGeomArea) {
            return true;
        }
        if (geom.getDimension() == 0) {
            return false;
        }
        List<SegmentString> lineSegStr = SegmentStringUtil.extractSegmentStrings(geom);
        if (lineSegStr.size() > 0) {
            FastSegmentSetIntersectionFinder fastSegmentSetIntersectionFinder = this.getPrepPoly().getIntersectionFinder();
            Intrinsics.checkNotNull((Object)fastSegmentSetIntersectionFinder);
            boolean segsIntersect = fastSegmentSetIntersectionFinder.intersects((Collection)lineSegStr);
            if (segsIntersect) {
                return true;
            }
        }
        return geom.getDimension() == 2 && (isPrepGeomInArea = this.isAnyTargetComponentInAreaTest(geom, this.getPrepPoly().getRepresentativePoints()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/geom/prep/PreparedPolygonIntersects$Companion;", "", "<init>", "()V", "intersects", "", "prep", "Lorg/locationtech/jts/geom/prep/PreparedPolygon;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean intersects(@NotNull PreparedPolygon prep, @NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)prep, (String)"prep");
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            PreparedPolygonIntersects polyInt = new PreparedPolygonIntersects(prep);
            return polyInt.intersects(geom);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

