/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.geom.util.ComponentCoordinateExtracter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0004J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0004J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0004J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J \u0010\u0013\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/geom/prep/PreparedPolygonPredicate;", "", "prepPoly", "Lorg/locationtech/jts/geom/prep/PreparedPolygon;", "<init>", "(Lorg/locationtech/jts/geom/prep/PreparedPolygon;)V", "getPrepPoly", "()Lorg/locationtech/jts/geom/prep/PreparedPolygon;", "setPrepPoly", "targetPointLocator", "Lorg/locationtech/jts/algorithm/locate/PointOnGeometryLocator;", "isAllTestComponentsInTarget", "", "testGeom", "Lorg/locationtech/jts/geom/Geometry;", "isAllTestComponentsInTargetInterior", "isAnyTestComponentInTarget", "isAllTestPointsInTarget", "isAnyTestPointInTargetInterior", "isAnyTargetComponentInAreaTest", "targetRepPts", "", "Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
public abstract class PreparedPolygonPredicate {
    @NotNull
    private PreparedPolygon prepPoly;
    @NotNull
    private final PointOnGeometryLocator targetPointLocator;

    public PreparedPolygonPredicate(@NotNull PreparedPolygon prepPoly) {
        Intrinsics.checkNotNullParameter((Object)prepPoly, (String)"prepPoly");
        this.prepPoly = prepPoly;
        this.targetPointLocator = prepPoly.getPointLocator();
    }

    @NotNull
    protected final PreparedPolygon getPrepPoly() {
        return this.prepPoly;
    }

    protected final void setPrepPoly(@NotNull PreparedPolygon preparedPolygon) {
        Intrinsics.checkNotNullParameter((Object)preparedPolygon, (String)"<set-?>");
        this.prepPoly = preparedPolygon;
    }

    protected final boolean isAllTestComponentsInTarget(@Nullable Geometry testGeom) {
        Geometry geometry = testGeom;
        Intrinsics.checkNotNull((Object)geometry);
        List<Coordinate> coords = ComponentCoordinateExtracter.Companion.getCoordinates(geometry);
        Iterator<Coordinate> i = coords.iterator();
        while (i.hasNext()) {
            Coordinate p;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
            int loc = this.targetPointLocator.locate(p);
            if (loc != 2) continue;
            return false;
        }
        return true;
    }

    protected final boolean isAllTestComponentsInTargetInterior(@Nullable Geometry testGeom) {
        Geometry geometry = testGeom;
        Intrinsics.checkNotNull((Object)geometry);
        List<Coordinate> coords = ComponentCoordinateExtracter.Companion.getCoordinates(geometry);
        Iterator<Coordinate> i = coords.iterator();
        while (i.hasNext()) {
            Coordinate p;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
            int loc = this.targetPointLocator.locate(p);
            if (loc == 0) continue;
            return false;
        }
        return true;
    }

    protected final boolean isAnyTestComponentInTarget(@Nullable Geometry testGeom) {
        Geometry geometry = testGeom;
        Intrinsics.checkNotNull((Object)geometry);
        List<Coordinate> coords = ComponentCoordinateExtracter.Companion.getCoordinates(geometry);
        Iterator<Coordinate> i = coords.iterator();
        while (i.hasNext()) {
            Coordinate p;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
            int loc = this.targetPointLocator.locate(p);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }

    protected final boolean isAllTestPointsInTarget(@NotNull Geometry testGeom) {
        Intrinsics.checkNotNullParameter((Object)testGeom, (String)"testGeom");
        int n = testGeom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Coordinate p;
            Geometry geometry = testGeom.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            Point pt = (Point)geometry;
            Coordinate coordinate = p = pt.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            int loc = this.targetPointLocator.locate(coordinate);
            if (loc != 2) continue;
            return false;
        }
        return true;
    }

    protected final boolean isAnyTestPointInTargetInterior(@NotNull Geometry testGeom) {
        Intrinsics.checkNotNullParameter((Object)testGeom, (String)"testGeom");
        int n = testGeom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Coordinate p;
            Geometry geometry = testGeom.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            Point pt = (Point)geometry;
            Coordinate coordinate = p = pt.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            int loc = this.targetPointLocator.locate(coordinate);
            if (loc != 0) continue;
            return true;
        }
        return false;
    }

    protected final boolean isAnyTargetComponentInAreaTest(@Nullable Geometry testGeom, @NotNull List<Coordinate> targetRepPts) {
        Intrinsics.checkNotNullParameter(targetRepPts, (String)"targetRepPts");
        Geometry geometry = testGeom;
        Intrinsics.checkNotNull((Object)geometry);
        PointOnGeometryLocator piaLoc = new SimplePointInAreaLocator(geometry);
        Iterator<Coordinate> i = targetRepPts.iterator();
        while (i.hasNext()) {
            Coordinate p;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
            int loc = piaLoc.locate(p);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }
}

