/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.geom.util.AffineTransformationBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0007J)\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/geom/util/AffineTransformationFactory;", "", "<init>", "()V", "createFromControlVectors", "Lorg/locationtech/jts/geom/util/AffineTransformation;", "src0", "Lorg/locationtech/jts/geom/Coordinate;", "src1", "src2", "dest0", "dest1", "dest2", "src", "", "dest", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/util/AffineTransformation;", "createFromBaseLines", "kts-core"})
@SourceDebugExtension(value={"SMAP\nAffineTransformationFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AffineTransformationFactory.kt\norg/locationtech/jts/geom/util/AffineTransformationFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class AffineTransformationFactory {
    @NotNull
    public static final AffineTransformationFactory INSTANCE = new AffineTransformationFactory();

    private AffineTransformationFactory() {
    }

    @Nullable
    public final AffineTransformation createFromControlVectors(@NotNull Coordinate src0, @NotNull Coordinate src1, @NotNull Coordinate src2, @NotNull Coordinate dest0, @NotNull Coordinate dest1, @NotNull Coordinate dest2) {
        Intrinsics.checkNotNullParameter((Object)src0, (String)"src0");
        Intrinsics.checkNotNullParameter((Object)src1, (String)"src1");
        Intrinsics.checkNotNullParameter((Object)src2, (String)"src2");
        Intrinsics.checkNotNullParameter((Object)dest0, (String)"dest0");
        Intrinsics.checkNotNullParameter((Object)dest1, (String)"dest1");
        Intrinsics.checkNotNullParameter((Object)dest2, (String)"dest2");
        AffineTransformationBuilder builder = new AffineTransformationBuilder(src0, src1, src2, dest0, dest1, dest2);
        return builder.getTransformation();
    }

    @JvmStatic
    @Nullable
    public static final AffineTransformation createFromControlVectors(@NotNull Coordinate src0, @NotNull Coordinate src1, @NotNull Coordinate dest0, @NotNull Coordinate dest1) {
        Intrinsics.checkNotNullParameter((Object)src0, (String)"src0");
        Intrinsics.checkNotNullParameter((Object)src1, (String)"src1");
        Intrinsics.checkNotNullParameter((Object)dest0, (String)"dest0");
        Intrinsics.checkNotNullParameter((Object)dest1, (String)"dest1");
        Coordinate rotPt = new Coordinate(dest1.x - dest0.x, dest1.y - dest0.y);
        double ang = Angle.INSTANCE.angleBetweenOriented(src1, src0, rotPt);
        double srcDist = src1.distance(src0);
        double destDist = dest1.distance(dest0);
        if (srcDist == 0.0) {
            return null;
        }
        double scale = destDist / srcDist;
        AffineTransformation trans = AffineTransformation.Companion.translationInstance(-src0.x, -src0.y);
        trans.rotate(ang);
        trans.scale(scale, scale);
        trans.translate(dest0.x, dest0.y);
        return trans;
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation createFromControlVectors(@NotNull Coordinate src0, @NotNull Coordinate dest0) {
        Intrinsics.checkNotNullParameter((Object)src0, (String)"src0");
        Intrinsics.checkNotNullParameter((Object)dest0, (String)"dest0");
        double dx = dest0.x - src0.x;
        double dy = dest0.y - src0.y;
        return AffineTransformation.Companion.translationInstance(dx, dy);
    }

    @Nullable
    public final AffineTransformation createFromControlVectors(@NotNull Coordinate[] src, @NotNull Coordinate[] dest) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!(src.length == dest.length)) {
            boolean $i$a$-require-AffineTransformationFactory$createFromControlVectors$42 = false;
            String $i$a$-require-AffineTransformationFactory$createFromControlVectors$42 = "Src and Dest arrays are not the same length";
            throw new IllegalArgumentException($i$a$-require-AffineTransformationFactory$createFromControlVectors$42.toString());
        }
        if (!(!(src.length == 0))) {
            boolean $i$a$-require-AffineTransformationFactory$createFromControlVectors$52 = false;
            String $i$a$-require-AffineTransformationFactory$createFromControlVectors$52 = "Too few control points";
            throw new IllegalArgumentException($i$a$-require-AffineTransformationFactory$createFromControlVectors$52.toString());
        }
        if (!(src.length <= 3)) {
            boolean bl = false;
            String string = "Too many control points";
            throw new IllegalArgumentException(string.toString());
        }
        if (src.length == 1) {
            return AffineTransformationFactory.createFromControlVectors(src[0], dest[0]);
        }
        return src.length == 2 ? AffineTransformationFactory.createFromControlVectors(src[0], src[1], dest[0], dest[1]) : this.createFromControlVectors(src[0], src[1], src[2], dest[0], dest[1], dest[2]);
    }

    @NotNull
    public final AffineTransformation createFromBaseLines(@NotNull Coordinate src0, @NotNull Coordinate src1, @NotNull Coordinate dest0, @NotNull Coordinate dest1) {
        Intrinsics.checkNotNullParameter((Object)src0, (String)"src0");
        Intrinsics.checkNotNullParameter((Object)src1, (String)"src1");
        Intrinsics.checkNotNullParameter((Object)dest0, (String)"dest0");
        Intrinsics.checkNotNullParameter((Object)dest1, (String)"dest1");
        Coordinate rotPt = new Coordinate(src0.x + dest1.x - dest0.x, src0.y + dest1.y - dest0.y);
        double ang = Angle.INSTANCE.angleBetweenOriented(src1, src0, rotPt);
        double srcDist = src1.distance(src0);
        double destDist = dest1.distance(dest0);
        if (srcDist == 0.0) {
            return new AffineTransformation();
        }
        double scale = destDist / srcDist;
        AffineTransformation trans = AffineTransformation.Companion.translationInstance(-src0.x, -src0.y);
        trans.rotate(ang);
        trans.scale(scale, scale);
        trans.translate(dest0.x, dest0.y);
        return trans;
    }
}

