/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ \u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/geom/util/GeometryCombiner;", "", "geoms", "", "<init>", "(Ljava/util/Collection;)V", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "skipEmpty", "", "inputGeoms", "combine", "Lorg/locationtech/jts/geom/Geometry;", "extractElements", "", "geom", "elems", "", "Companion", "kts-core"})
public final class GeometryCombiner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final GeometryFactory geomFactory;
    private final boolean skipEmpty;
    @NotNull
    private final Collection<?> inputGeoms;

    public GeometryCombiner(@NotNull Collection<?> geoms) {
        Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
        this.geomFactory = Companion.extractFactory(geoms);
        this.inputGeoms = geoms;
    }

    @Nullable
    public final Geometry combine() {
        Geometry geometry;
        List elems = new ArrayList();
        for (Object obj : this.inputGeoms) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry g = (Geometry)obj;
            this.extractElements(g, elems);
        }
        if (elems.size() == 0) {
            GeometryFactory geometryFactory = this.geomFactory;
            geometry = geometryFactory != null ? geometryFactory.createGeometryCollection() : null;
        } else {
            GeometryFactory geometryFactory = this.geomFactory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.buildGeometry(elems);
        }
        return geometry;
    }

    private final void extractElements(Geometry geom, List<Geometry> elems) {
        if (geom == null) {
            return;
        }
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry elemGeom = geom.getGeometryN(i);
            if (this.skipEmpty && elemGeom.isEmpty()) continue;
            elems.add(elemGeom);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/geom/util/GeometryCombiner$Companion;", "", "<init>", "()V", "combine", "Lorg/locationtech/jts/geom/Geometry;", "geoms", "", "g0", "g1", "g2", "createList", "", "obj0", "obj1", "obj2", "extractFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Geometry combine(@NotNull Collection<? extends Geometry> geoms) {
            Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
            GeometryCombiner combiner = new GeometryCombiner(geoms);
            return combiner.combine();
        }

        @Nullable
        public final Geometry combine(@NotNull Geometry g0, @NotNull Geometry g1) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            GeometryCombiner combiner = new GeometryCombiner((Collection)this.createList(g0, g1));
            return combiner.combine();
        }

        @Nullable
        public final Geometry combine(@NotNull Geometry g0, @NotNull Geometry g1, @NotNull Geometry g2) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
            GeometryCombiner combiner = new GeometryCombiner((Collection)this.createList(g0, g1, g2));
            return combiner.combine();
        }

        private final List<Geometry> createList(Geometry obj0, Geometry obj1) {
            List list = new ArrayList();
            list.add(obj0);
            list.add(obj1);
            return list;
        }

        private final List<Geometry> createList(Geometry obj0, Geometry obj1, Geometry obj2) {
            List list = new ArrayList();
            list.add(obj0);
            list.add(obj1);
            list.add(obj2);
            return list;
        }

        @Nullable
        public final GeometryFactory extractFactory(@NotNull Collection<?> geoms) {
            GeometryFactory geometryFactory;
            Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
            if (geoms.isEmpty()) {
                geometryFactory = null;
            } else {
                Object obj = geoms.iterator().next();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
                geometryFactory = ((Geometry)obj).getFactory();
            }
            return geometryFactory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

