/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/locationtech/jts/geom/util/GeometryEditor;", "", "<init>", "()V", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "getFactory", "()Lorg/locationtech/jts/geom/GeometryFactory;", "setFactory", "isUserDataCopied", "", "setCopyUserData", "", "edit", "Lorg/locationtech/jts/geom/Geometry;", "geometry", "operation", "Lorg/locationtech/jts/geom/util/GeometryEditor$GeometryEditorOperation;", "editInternal", "editPolygon", "Lorg/locationtech/jts/geom/Polygon;", "polygon", "editGeometryCollection", "Lorg/locationtech/jts/geom/GeometryCollection;", "collection", "GeometryEditorOperation", "NoOpGeometryOperation", "CoordinateOperation", "CoordinateSequenceOperation", "kts-core"})
@SourceDebugExtension(value={"SMAP\nGeometryEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeometryEditor.kt\norg/locationtech/jts/geom/util/GeometryEditor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,334:1\n37#2,2:335\n37#2,2:341\n37#2,2:347\n37#2,2:353\n37#2,2:359\n1563#3:337\n1634#3,3:338\n1563#3:343\n1634#3,3:344\n1563#3:349\n1634#3,3:350\n1563#3:355\n1634#3,3:356\n*S KotlinDebug\n*F\n+ 1 GeometryEditor.kt\norg/locationtech/jts/geom/util/GeometryEditor\n*L\n167#1:335,2\n191#1:341,2\n194#1:347,2\n197#1:353,2\n198#1:359,2\n191#1:337\n191#1:338,3\n194#1:343\n194#1:344,3\n197#1:349\n197#1:350,3\n198#1:355\n198#1:356,3\n*E\n"})
public final class GeometryEditor {
    @Nullable
    private GeometryFactory factory;
    private boolean isUserDataCopied;

    @Nullable
    public final GeometryFactory getFactory() {
        return this.factory;
    }

    public final void setFactory(@Nullable GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
    }

    public GeometryEditor() {
    }

    public GeometryEditor(@Nullable GeometryFactory factory) {
        this.factory = factory;
    }

    public final void setCopyUserData(boolean isUserDataCopied) {
        this.isUserDataCopied = isUserDataCopied;
    }

    @Nullable
    public final Geometry edit(@Nullable Geometry geometry, @NotNull GeometryEditorOperation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (geometry == null) {
            return null;
        }
        Geometry result2 = this.editInternal(geometry, operation);
        if (this.isUserDataCopied) {
            Geometry geometry2 = result2;
            Intrinsics.checkNotNull((Object)geometry2);
            geometry2.setUserData(geometry.getUserData());
        }
        return result2;
    }

    private final Geometry editInternal(Geometry geometry, GeometryEditorOperation operation) {
        if (this.factory == null) {
            this.factory = geometry.getFactory();
        }
        if (geometry instanceof GeometryCollection) {
            return this.editGeometryCollection((GeometryCollection)geometry, operation);
        }
        if (geometry instanceof Polygon) {
            return this.editPolygon((Polygon)geometry, operation);
        }
        if (geometry instanceof Point) {
            return operation.edit(geometry, this.factory);
        }
        if (geometry instanceof LineString) {
            return operation.edit(geometry, this.factory);
        }
        Assert.shouldNeverReachHere("Unsupported Geometry class: " + Reflection.getOrCreateKotlinClass(geometry.getClass()));
        return null;
    }

    private final Polygon editPolygon(Polygon polygon, GeometryEditorOperation operation) {
        Geometry geometry = operation.edit(polygon, this.factory);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        Polygon newPolygon = (Polygon)geometry;
        if (newPolygon.isEmpty()) {
            return newPolygon;
        }
        LinearRing shell = (LinearRing)this.edit(newPolygon.getExteriorRing(), operation);
        if (shell == null || shell.isEmpty()) {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            return GeometryFactory.createPolygon$default(geometryFactory, null, null, 3, null);
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        int n = newPolygon.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            LinearRing hole = (LinearRing)this.edit(newPolygon.getInteriorRingN(i), operation);
            if (hole == null || hole.isEmpty()) continue;
            holes.add(hole);
        }
        GeometryFactory geometryFactory = this.factory;
        Intrinsics.checkNotNull((Object)geometryFactory);
        Collection $this$toTypedArray$iv = holes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return geometryFactory.createPolygon(shell, thisCollection$iv.toArray(new LinearRing[0]));
    }

    /*
     * WARNING - void declaration
     */
    private final GeometryCollection editGeometryCollection(GeometryCollection collection, GeometryEditorOperation operation) {
        GeometryCollection geometryCollection;
        Iterable thisCollection$iv;
        boolean $i$f$toTypedArray;
        void $this$mapTo$iv$iv;
        boolean $i$f$map;
        Geometry geometry;
        Geometry geometry2 = operation.edit(collection, this.factory);
        Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.GeometryCollection");
        GeometryCollection collectionForType = (GeometryCollection)geometry2;
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        int n = collectionForType.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            geometry = this.edit(collectionForType.getGeometryN(i), operation);
            if (geometry == null || geometry.isEmpty()) continue;
            geometries.add(geometry);
        }
        if (collectionForType.getClass() == MultiPoint.class) {
            void $this$toTypedArray$iv;
            Collection $this$map$iv;
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            Iterable i = geometries;
            GeometryFactory geometryFactory2 = geometryFactory;
            $i$f$map = false;
            geometry = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
                collection2.add((Point)it);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            return geometryFactory2.createMultiPoint(thisCollection$iv.toArray(new Point[0]));
        }
        if (collectionForType.getClass() == MultiLineString.class) {
            Collection $this$map$iv;
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            Iterable $this$toTypedArray$iv = geometries;
            GeometryFactory geometryFactory3 = geometryFactory;
            $i$f$map = false;
            thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object item$iv$iv;
                Object it = item$iv$iv = iterator3.next();
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                collection3.add((LineString)it);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            return geometryFactory3.createMultiLineString(thisCollection$iv.toArray(new LineString[0]));
        }
        if (collectionForType.getClass() == MultiPolygon.class) {
            Collection $this$map$iv;
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            Iterable $this$toTypedArray$iv = geometries;
            GeometryFactory geometryFactory4 = geometryFactory;
            $i$f$map = false;
            thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator4 = $this$mapTo$iv$iv.iterator();
            while (iterator4.hasNext()) {
                Object item$iv$iv;
                Object it = item$iv$iv = iterator4.next();
                Collection collection4 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                collection4.add((Polygon)it);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            geometryCollection = geometryFactory4.createMultiPolygon(thisCollection$iv.toArray(new Polygon[0]));
        } else {
            Collection $this$map$iv;
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            Iterable $this$toTypedArray$iv = geometries;
            GeometryFactory geometryFactory5 = geometryFactory;
            $i$f$map = false;
            thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator5 = $this$mapTo$iv$iv.iterator();
            while (iterator5.hasNext()) {
                Object item$iv$iv;
                Object it = item$iv$iv = iterator5.next();
                Collection collection5 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
                collection5.add((Geometry)it);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            geometryCollection = geometryFactory5.createGeometryCollection(thisCollection$iv.toArray(new Geometry[0]));
        }
        return geometryCollection;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/geom/util/GeometryEditor$CoordinateOperation;", "Lorg/locationtech/jts/geom/util/GeometryEditor$GeometryEditorOperation;", "<init>", "()V", "edit", "Lorg/locationtech/jts/geom/Geometry;", "geometry", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "", "Lorg/locationtech/jts/geom/Coordinate;", "coordinates", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static abstract class CoordinateOperation
    implements GeometryEditorOperation {
        @Override
        @NotNull
        public Geometry edit(@NotNull Geometry geometry, @Nullable GeometryFactory factory) {
            Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
            if (geometry instanceof LinearRing) {
                GeometryFactory geometryFactory = factory;
                Intrinsics.checkNotNull((Object)geometryFactory);
                return geometryFactory.createLinearRing(this.edit(((LinearRing)geometry).getCoordinates(), geometry));
            }
            if (geometry instanceof LineString) {
                GeometryFactory geometryFactory = factory;
                Intrinsics.checkNotNull((Object)geometryFactory);
                return geometryFactory.createLineString(this.edit(((LineString)geometry).getCoordinates(), geometry));
            }
            if (geometry instanceof Point) {
                Coordinate[] newCoordinates = this.edit(((Point)geometry).getCoordinates(), geometry);
                GeometryFactory geometryFactory = factory;
                Intrinsics.checkNotNull((Object)geometryFactory);
                Intrinsics.checkNotNull((Object)newCoordinates);
                return geometryFactory.createPoint(!(newCoordinates.length == 0) ? newCoordinates[0] : null);
            }
            return geometry;
        }

        @Nullable
        public abstract Coordinate[] edit(@Nullable Coordinate[] var1, @NotNull Geometry var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/geom/util/GeometryEditor$CoordinateSequenceOperation;", "Lorg/locationtech/jts/geom/util/GeometryEditor$GeometryEditorOperation;", "<init>", "()V", "edit", "Lorg/locationtech/jts/geom/Geometry;", "geometry", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "Lorg/locationtech/jts/geom/CoordinateSequence;", "coordSeq", "kts-core"})
    public static abstract class CoordinateSequenceOperation
    implements GeometryEditorOperation {
        @Override
        @NotNull
        public Geometry edit(@NotNull Geometry geometry, @Nullable GeometryFactory factory) {
            Geometry geometry2;
            Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
            if (geometry instanceof LinearRing) {
                GeometryFactory geometryFactory = factory;
                Intrinsics.checkNotNull((Object)geometryFactory);
                return geometryFactory.createLinearRing(this.edit(((LinearRing)geometry).getCoordinateSequence(), geometry));
            }
            if (geometry instanceof LineString) {
                GeometryFactory geometryFactory = factory;
                Intrinsics.checkNotNull((Object)geometryFactory);
                return geometryFactory.createLineString(this.edit(((LineString)geometry).getCoordinateSequence(), geometry));
            }
            if (geometry instanceof Point) {
                GeometryFactory geometryFactory = factory;
                Intrinsics.checkNotNull((Object)geometryFactory);
                geometry2 = geometryFactory.createPoint(this.edit(((Point)geometry).getCoordinateSequence(), geometry));
            } else {
                geometry2 = geometry;
            }
            return geometry2;
        }

        @Nullable
        public abstract CoordinateSequence edit(@Nullable CoordinateSequence var1, @Nullable Geometry var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lorg/locationtech/jts/geom/util/GeometryEditor$GeometryEditorOperation;", "", "edit", "Lorg/locationtech/jts/geom/Geometry;", "geometry", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "kts-core"})
    public static interface GeometryEditorOperation {
        @NotNull
        public Geometry edit(@NotNull Geometry var1, @Nullable GeometryFactory var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/geom/util/GeometryEditor$NoOpGeometryOperation;", "Lorg/locationtech/jts/geom/util/GeometryEditor$GeometryEditorOperation;", "<init>", "()V", "edit", "Lorg/locationtech/jts/geom/Geometry;", "geometry", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "kts-core"})
    public static final class NoOpGeometryOperation
    implements GeometryEditorOperation {
        @Override
        @NotNull
        public Geometry edit(@NotNull Geometry geometry, @Nullable GeometryFactory factory) {
            Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
            return geometry;
        }
    }
}

