/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005J\u001d\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0004\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0004J\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0014J\u001a\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0004J\u001a\u0010#\u001a\u00020\u00052\u0006\u0010!\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0004J\u001e\u0010%\u001a\u0004\u0018\u00010\u00052\b\u0010!\u001a\u0004\u0018\u00010&2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0014J\u001a\u0010'\u001a\u00020\u00052\u0006\u0010!\u001a\u00020(2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0004J\u001a\u0010)\u001a\u00020\u00052\u0006\u0010!\u001a\u00020*2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0004J\u001c\u0010+\u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020,2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0014J\u001a\u0010-\u001a\u00020\u00052\u0006\u0010!\u001a\u00020.2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0014J\u001a\u0010/\u001a\u00020\u00052\u0006\u0010!\u001a\u0002002\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0004R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/locationtech/jts/geom/util/GeometryTransformer;", "", "<init>", "()V", "value", "Lorg/locationtech/jts/geom/Geometry;", "inputGeometry", "getInputGeometry", "()Lorg/locationtech/jts/geom/Geometry;", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "getFactory", "()Lorg/locationtech/jts/geom/GeometryFactory;", "setFactory", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "pruneEmptyGeometry", "", "preserveGeometryCollectionType", "preserveCollections", "preserveType", "transform", "inputGeom", "createCoordinateSequence", "Lorg/locationtech/jts/geom/CoordinateSequence;", "coords", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/CoordinateSequence;", "copy", "seq", "transformCoordinates", "parent", "transformPoint", "geom", "Lorg/locationtech/jts/geom/Point;", "transformMultiPoint", "Lorg/locationtech/jts/geom/MultiPoint;", "transformLinearRing", "Lorg/locationtech/jts/geom/LinearRing;", "transformLineString", "Lorg/locationtech/jts/geom/LineString;", "transformMultiLineString", "Lorg/locationtech/jts/geom/MultiLineString;", "transformPolygon", "Lorg/locationtech/jts/geom/Polygon;", "transformMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "transformGeometryCollection", "Lorg/locationtech/jts/geom/GeometryCollection;", "kts-core"})
@SourceDebugExtension(value={"SMAP\nGeometryTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeometryTransformer.kt\norg/locationtech/jts/geom/util/GeometryTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,260:1\n1563#2:261\n1634#2,3:262\n37#3,2:265\n*S KotlinDebug\n*F\n+ 1 GeometryTransformer.kt\norg/locationtech/jts/geom/util/GeometryTransformer\n*L\n225#1:261\n225#1:262,3\n225#1:265,2\n*E\n"})
public class GeometryTransformer {
    @Nullable
    private Geometry inputGeometry;
    @Nullable
    private GeometryFactory factory;
    private final boolean pruneEmptyGeometry;
    private final boolean preserveGeometryCollectionType;
    private final boolean preserveCollections;
    private final boolean preserveType;

    public GeometryTransformer() {
        this.pruneEmptyGeometry = true;
        this.preserveGeometryCollectionType = true;
    }

    @Nullable
    public final Geometry getInputGeometry() {
        return this.inputGeometry;
    }

    @Nullable
    protected final GeometryFactory getFactory() {
        return this.factory;
    }

    protected final void setFactory(@Nullable GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
    }

    @NotNull
    public final Geometry transform(@NotNull Geometry inputGeom) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this.inputGeometry = inputGeom;
        this.factory = inputGeom.getFactory();
        if (inputGeom instanceof Point) {
            return this.transformPoint((Point)inputGeom, null);
        }
        if (inputGeom instanceof MultiPoint) {
            return this.transformMultiPoint((MultiPoint)inputGeom, null);
        }
        if (inputGeom instanceof LinearRing) {
            Geometry geometry = this.transformLinearRing((LinearRing)inputGeom, null);
            Intrinsics.checkNotNull((Object)geometry);
            return geometry;
        }
        if (inputGeom instanceof LineString) {
            return this.transformLineString((LineString)inputGeom, null);
        }
        if (inputGeom instanceof MultiLineString) {
            return this.transformMultiLineString((MultiLineString)inputGeom, null);
        }
        if (inputGeom instanceof Polygon) {
            Geometry geometry = this.transformPolygon((Polygon)inputGeom, null);
            Intrinsics.checkNotNull((Object)geometry);
            return geometry;
        }
        if (inputGeom instanceof MultiPolygon) {
            return this.transformMultiPolygon((MultiPolygon)inputGeom, null);
        }
        if (inputGeom instanceof GeometryCollection) {
            return this.transformGeometryCollection((GeometryCollection)inputGeom, null);
        }
        throw new IllegalArgumentException("Unknown Geometry subtype: " + Reflection.getOrCreateKotlinClass(inputGeom.getClass()));
    }

    @NotNull
    protected final CoordinateSequence createCoordinateSequence(@Nullable Coordinate[] coords) {
        GeometryFactory geometryFactory = this.factory;
        Intrinsics.checkNotNull((Object)geometryFactory);
        return geometryFactory.getCoordinateSequenceFactory().create(coords);
    }

    @NotNull
    protected final CoordinateSequence copy(@Nullable CoordinateSequence seq) {
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return coordinateSequence.copy();
    }

    @Nullable
    protected CoordinateSequence transformCoordinates(@Nullable CoordinateSequence coords, @Nullable Geometry parent) {
        return this.copy(coords);
    }

    @NotNull
    protected final Geometry transformPoint(@NotNull Point geom, @Nullable Geometry parent) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        GeometryFactory geometryFactory = this.factory;
        Intrinsics.checkNotNull((Object)geometryFactory);
        return geometryFactory.createPoint(this.transformCoordinates(geom.getCoordinateSequence(), geom));
    }

    @NotNull
    protected final Geometry transformMultiPoint(@NotNull MultiPoint geom, @Nullable Geometry parent) {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        List transGeomList = new ArrayList();
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry2 = geom.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            Geometry transformGeom = this.transformPoint((Point)geometry2, geom);
            if (transformGeom.isEmpty()) continue;
            transGeomList.add(transformGeom);
        }
        if (transGeomList.isEmpty()) {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.createMultiPoint();
        } else {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.buildGeometry(transGeomList);
        }
        return geometry;
    }

    @Nullable
    protected Geometry transformLinearRing(@Nullable LinearRing geom, @Nullable Geometry parent) {
        Geometry geometry;
        LinearRing linearRing = geom;
        Intrinsics.checkNotNull((Object)linearRing);
        CoordinateSequence coordinateSequence = this.transformCoordinates(linearRing.getCoordinateSequence(), geom);
        if (coordinateSequence == null) {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            return geometryFactory.createLinearRing((CoordinateSequence)null);
        }
        CoordinateSequence seq = coordinateSequence;
        int seqSize = seq.size();
        boolean bl = 1 <= seqSize ? seqSize < 4 : false;
        if (bl && !this.preserveType) {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.createLineString(seq);
        } else {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.createLinearRing(seq);
        }
        return geometry;
    }

    @NotNull
    protected final Geometry transformLineString(@NotNull LineString geom, @Nullable Geometry parent) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        GeometryFactory geometryFactory = this.factory;
        Intrinsics.checkNotNull((Object)geometryFactory);
        return geometryFactory.createLineString(this.transformCoordinates(geom.getCoordinateSequence(), geom));
    }

    @NotNull
    protected final Geometry transformMultiLineString(@NotNull MultiLineString geom, @Nullable Geometry parent) {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        List transGeomList = new ArrayList();
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry2 = geom.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            Geometry transformGeom = this.transformLineString((LineString)geometry2, geom);
            if (transformGeom.isEmpty()) continue;
            transGeomList.add(transformGeom);
        }
        if (transGeomList.isEmpty()) {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.createMultiLineString();
        } else {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.buildGeometry(transGeomList);
        }
        return geometry;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Geometry transformPolygon(@NotNull Polygon geom, @Nullable Geometry parent) {
        Geometry geometry;
        Geometry hole;
        boolean shellIsNullOrEmpty;
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        boolean isAllValidLinearRings = true;
        Geometry shell = this.transformLinearRing(geom.getExteriorRing(), geom);
        boolean bl = shellIsNullOrEmpty = shell == null || shell.isEmpty();
        if (geom.isEmpty() && shellIsNullOrEmpty) {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            return GeometryFactory.createPolygon$default(geometryFactory, null, null, 3, null);
        }
        if (shellIsNullOrEmpty || !(shell instanceof LinearRing)) {
            isAllValidLinearRings = false;
        }
        ArrayList<Geometry> holes = new ArrayList<Geometry>();
        int n = geom.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            hole = this.transformLinearRing(geom.getInteriorRingN(i), geom);
            if (hole == null || hole.isEmpty()) continue;
            if (!(hole instanceof LinearRing)) {
                isAllValidLinearRings = false;
            }
            holes.add(hole);
        }
        if (isAllValidLinearRings) {
            void $this$toTypedArray$iv;
            Collection<LinearRing> collection;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            Intrinsics.checkNotNull((Object)shell, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
            Iterable i = holes;
            LinearRing linearRing = (LinearRing)shell;
            GeometryFactory geometryFactory2 = geometryFactory;
            boolean $i$f$map = false;
            hole = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Geometry geometry2 = (Geometry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
                collection.add((LinearRing)it);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            geometry = geometryFactory2.createPolygon(linearRing, thisCollection$iv.toArray(new LinearRing[0]));
        } else {
            List components = new ArrayList();
            if (shell != null) {
                components.add(shell);
            }
            components.addAll((Collection)holes);
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.buildGeometry(components);
        }
        return geometry;
    }

    @NotNull
    protected Geometry transformMultiPolygon(@NotNull MultiPolygon geom, @Nullable Geometry parent) {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        List transGeomList = new ArrayList();
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry transformGeom;
            Geometry geometry2 = geom.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            if (this.transformPolygon((Polygon)geometry2, geom) == null || transformGeom.isEmpty()) continue;
            transGeomList.add(transformGeom);
        }
        if (transGeomList.isEmpty()) {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.createMultiPolygon();
        } else {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.buildGeometry(transGeomList);
        }
        return geometry;
    }

    @NotNull
    protected final Geometry transformGeometryCollection(@NotNull GeometryCollection geom, @Nullable Geometry parent) {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        List transGeomList = new ArrayList();
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry transformGeom = this.transform(geom.getGeometryN(i));
            if (this.pruneEmptyGeometry && transformGeom.isEmpty()) continue;
            transGeomList.add(transformGeom);
        }
        if (this.preserveGeometryCollectionType) {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.createGeometryCollection(GeometryFactory.Companion.toGeometryArray(transGeomList));
        } else {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.buildGeometry(transGeomList);
        }
        return geometry;
    }
}

