/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geomgraph.Label;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u001e\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\rJ\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/geomgraph/Depth;", "", "<init>", "()V", "depth", "", "", "[[I", "getDepth", "", "geomIndex", "posIndex", "setDepth", "", "depthValue", "getLocation", "add", "location", "isNull", "", "()Z", "lbl", "Lorg/locationtech/jts/geomgraph/Label;", "getDelta", "normalize", "toString", "", "Companion", "kts-core"})
public final class Depth {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[][] depth;
    private static final int NULL_VALUE = -1;

    public Depth() {
        int n = 0;
        int[][] nArrayArray = new int[2][];
        Depth depth = this;
        while (n < 2) {
            int n2 = n++;
            nArrayArray[n2] = new int[3];
        }
        depth.depth = nArrayArray;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.depth[i][j] = -1;
            }
        }
    }

    public final int getDepth(int geomIndex, int posIndex) {
        return this.depth[geomIndex][posIndex];
    }

    public final void setDepth(int geomIndex, int posIndex, int depthValue) {
        this.depth[geomIndex][posIndex] = depthValue;
    }

    public final int getLocation(int geomIndex, int posIndex) {
        return this.depth[geomIndex][posIndex] <= 0 ? 2 : 0;
    }

    public final void add(int geomIndex, int posIndex, int location) {
        if (location == 0) {
            int[] nArray = this.depth[geomIndex];
            int n = nArray[posIndex];
            nArray[posIndex] = n + 1;
        }
    }

    public final boolean isNull() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.depth[i][j] == -1) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isNull(int geomIndex) {
        return this.depth[geomIndex][1] == -1;
    }

    public final boolean isNull(int geomIndex, int posIndex) {
        return this.depth[geomIndex][posIndex] == -1;
    }

    public final void add(@NotNull Label lbl) {
        Intrinsics.checkNotNullParameter((Object)lbl, (String)"lbl");
        for (int i = 0; i < 2; ++i) {
            block4: for (int j = 1; j < 3; ++j) {
                int loc = lbl.getLocation(i, j);
                switch (loc) {
                    case 0: 
                    case 2: {
                        if (this.isNull(i, j)) {
                            this.depth[i][j] = Companion.depthAtLocation(loc);
                            continue block4;
                        }
                        int[] nArray = this.depth[i];
                        int n = j;
                        nArray[n] = nArray[n] + Companion.depthAtLocation(loc);
                    }
                }
            }
        }
    }

    public final int getDelta(int geomIndex) {
        return this.depth[geomIndex][2] - this.depth[geomIndex][1];
    }

    public final void normalize() {
        for (int i = 0; i < 2; ++i) {
            if (this.isNull(i)) continue;
            int minDepth = this.depth[i][1];
            if (this.depth[i][2] < minDepth) {
                minDepth = this.depth[i][2];
            }
            if (minDepth < 0) {
                minDepth = 0;
            }
            for (int j = 1; j < 3; ++j) {
                int newValue = 0;
                if (this.depth[i][j] > minDepth) {
                    newValue = 1;
                }
                this.depth[i][j] = newValue;
            }
        }
    }

    @NotNull
    public String toString() {
        return "A: " + this.depth[0][1] + "," + this.depth[0][2] + " B: " + this.depth[1][1] + "," + this.depth[1][2];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/geomgraph/Depth$Companion;", "", "<init>", "()V", "NULL_VALUE", "", "depthAtLocation", "location", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int depthAtLocation(int location) {
            if (location == 2) {
                return 0;
            }
            return location == 0 ? 1 : -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

