/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.EdgeRing;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006J\u001b\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\bJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0006J \u0010 \u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000fH\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/geomgraph/DirectedEdgeStar;", "Lorg/locationtech/jts/geomgraph/EdgeEndStar;", "<init>", "()V", "resultAreaEdgeList", "", "Lorg/locationtech/jts/geomgraph/DirectedEdge;", "label", "Lorg/locationtech/jts/geomgraph/Label;", "insert", "", "ee", "Lorg/locationtech/jts/geomgraph/EdgeEnd;", "getLabel", "getOutgoingDegree", "", "er", "Lorg/locationtech/jts/geomgraph/EdgeRing;", "getRightmostEdge", "computeLabelling", "geom", "", "Lorg/locationtech/jts/geomgraph/GeometryGraph;", "([Lorg/locationtech/jts/geomgraph/GeometryGraph;)V", "mergeSymLabels", "updateLabelling", "nodeLabel", "getResultAreaEdges", "linkResultDirectedEdges", "linkMinimalDirectedEdges", "linkAllDirectedEdges", "findCoveredLineEdges", "computeDepths", "de", "startIndex", "endIndex", "startDepth", "Companion", "kts-core"})
public final class DirectedEdgeStar
extends EdgeEndStar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<DirectedEdge> resultAreaEdgeList;
    @Nullable
    private Label label;
    private static final int SCANNING_FOR_INCOMING = 1;
    private static final int LINKING_TO_OUTGOING = 2;

    @Override
    public void insert(@Nullable EdgeEnd ee) {
        Intrinsics.checkNotNull((Object)ee, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
        DirectedEdge de = (DirectedEdge)ee;
        this.insertEdgeEnd(de, de);
    }

    @Nullable
    public final Label getLabel() {
        return this.label;
    }

    public final int getOutgoingDegree() {
        int degree = 0;
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            if (!de.isInResult()) continue;
            ++degree;
        }
        return degree;
    }

    public final int getOutgoingDegree(@NotNull EdgeRing er) {
        Intrinsics.checkNotNullParameter((Object)er, (String)"er");
        int degree = 0;
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            if (de.getEdgeRing() != er) continue;
            ++degree;
        }
        return degree;
    }

    @Nullable
    public final DirectedEdge getRightmostEdge() {
        List<EdgeEnd> edges = this.getEdges();
        int size = edges.size();
        if (size < 1) {
            return null;
        }
        EdgeEnd edgeEnd = edges.get(0);
        Intrinsics.checkNotNull((Object)edgeEnd, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
        DirectedEdge de0 = (DirectedEdge)edgeEnd;
        if (size == 1) {
            return de0;
        }
        EdgeEnd edgeEnd2 = edges.get(size - 1);
        Intrinsics.checkNotNull((Object)edgeEnd2, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
        DirectedEdge deLast = (DirectedEdge)edgeEnd2;
        int quad0 = de0.getQuadrant();
        int quad1 = deLast.getQuadrant();
        if (Quadrant.INSTANCE.isNorthern(quad0) && Quadrant.INSTANCE.isNorthern(quad1)) {
            return de0;
        }
        if (!Quadrant.INSTANCE.isNorthern(quad0) && !Quadrant.INSTANCE.isNorthern(quad1)) {
            return deLast;
        }
        Object nonHorizontalEdge = null;
        if (!(de0.getDy() == 0.0)) {
            return de0;
        }
        if (!(deLast.getDy() == 0.0)) {
            return deLast;
        }
        Assert.shouldNeverReachHere("found two horizontal edges incident on node");
        return null;
    }

    @Override
    public void computeLabelling(@NotNull GeometryGraph[] geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        super.computeLabelling(geom);
        this.label = new Label(-1);
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd ee = (EdgeEnd)obj;
            Edge e = ee.getEdge();
            Intrinsics.checkNotNull((Object)e.getLabel());
            for (int i = 0; i < 2; ++i) {
                Label eLabel;
                int eLoc = eLabel.getLocation(i);
                switch (eLoc) {
                    case 0: 
                    case 1: {
                        Label label = this.label;
                        Intrinsics.checkNotNull((Object)label);
                        label.setLocation(i, 0);
                    }
                }
            }
        }
    }

    public final void mergeSymLabels() {
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Label label;
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            Intrinsics.checkNotNull((Object)de.getLabel());
            DirectedEdge directedEdge = de.getSym();
            Intrinsics.checkNotNull((Object)directedEdge);
            Label label2 = directedEdge.getLabel();
            Intrinsics.checkNotNull((Object)label2);
            label.merge(label2);
        }
    }

    public final void updateLabelling(@NotNull Label nodeLabel) {
        Intrinsics.checkNotNullParameter((Object)nodeLabel, (String)"nodeLabel");
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Label label;
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            Intrinsics.checkNotNull((Object)de.getLabel());
            label.setAllLocationsIfNull(0, nodeLabel.getLocation(0));
            label.setAllLocationsIfNull(1, nodeLabel.getLocation(1));
        }
    }

    private final List<DirectedEdge> getResultAreaEdges() {
        if (this.resultAreaEdgeList != null) {
            List<DirectedEdge> list = this.resultAreaEdgeList;
            Intrinsics.checkNotNull(list);
            return list;
        }
        this.resultAreaEdgeList = new ArrayList();
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            if (!de.isInResult()) {
                DirectedEdge directedEdge = de.getSym();
                Intrinsics.checkNotNull((Object)directedEdge);
                if (!directedEdge.isInResult()) continue;
            }
            List<DirectedEdge> list = this.resultAreaEdgeList;
            Intrinsics.checkNotNull(list);
            list.add(de);
        }
        List<DirectedEdge> list = this.resultAreaEdgeList;
        Intrinsics.checkNotNull(list);
        return list;
    }

    public final void linkResultDirectedEdges() {
        this.getResultAreaEdges();
        DirectedEdge firstOut = null;
        DirectedEdge incoming = null;
        int state = 1;
        List<DirectedEdge> list = this.resultAreaEdgeList;
        Intrinsics.checkNotNull(list);
        int n = ((Collection)list).size();
        block4: for (int i = 0; i < n; ++i) {
            List<DirectedEdge> list2 = this.resultAreaEdgeList;
            Intrinsics.checkNotNull(list2);
            DirectedEdge nextOut = list2.get(i);
            Intrinsics.checkNotNull((Object)nextOut.getSym());
            Label label = nextOut.getLabel();
            Intrinsics.checkNotNull((Object)label);
            if (!label.isArea()) continue;
            if (firstOut == null && nextOut.isInResult()) {
                firstOut = nextOut;
            }
            switch (state) {
                case 1: {
                    DirectedEdge nextIn;
                    if (!nextIn.isInResult()) continue block4;
                    incoming = nextIn;
                    state = 2;
                    continue block4;
                }
                case 2: {
                    if (!nextOut.isInResult()) continue block4;
                    DirectedEdge directedEdge = incoming;
                    Intrinsics.checkNotNull((Object)directedEdge);
                    directedEdge.setNext(nextOut);
                    state = 1;
                }
            }
        }
        if (state == 2) {
            if (firstOut == null) {
                throw new TopologyException("no outgoing dirEdge found", this.getCoordinate());
            }
            Assert.INSTANCE.isTrue(firstOut.isInResult(), "unable to link last incoming dirEdge");
            DirectedEdge directedEdge = incoming;
            Intrinsics.checkNotNull(directedEdge);
            directedEdge.setNext(firstOut);
        }
    }

    public final void linkMinimalDirectedEdges(@NotNull EdgeRing er) {
        Intrinsics.checkNotNullParameter((Object)er, (String)"er");
        DirectedEdge firstOut = null;
        DirectedEdge incoming = null;
        int state = 1;
        List<DirectedEdge> list = this.resultAreaEdgeList;
        Intrinsics.checkNotNull(list);
        int n = ((Collection)list).size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                List<DirectedEdge> list2 = this.resultAreaEdgeList;
                Intrinsics.checkNotNull(list2);
                DirectedEdge nextOut = list2.get(i);
                Intrinsics.checkNotNull((Object)nextOut.getSym());
                if (firstOut == null && nextOut.getEdgeRing() == er) {
                    firstOut = nextOut;
                }
                switch (state) {
                    case 1: {
                        DirectedEdge nextIn;
                        if (nextIn.getEdgeRing() != er) break;
                        incoming = nextIn;
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (nextOut.getEdgeRing() != er) break;
                        DirectedEdge directedEdge = incoming;
                        Intrinsics.checkNotNull((Object)directedEdge);
                        directedEdge.setNextMin(nextOut);
                        state = 1;
                    }
                }
            } while (0 <= n);
        }
        if (state == 2) {
            Assert.INSTANCE.isTrue(firstOut != null, "found null for first outgoing dirEdge");
            DirectedEdge directedEdge = firstOut;
            Intrinsics.checkNotNull(directedEdge);
            Assert.INSTANCE.isTrue(directedEdge.getEdgeRing() == er, "unable to link last incoming dirEdge");
            DirectedEdge directedEdge2 = incoming;
            Intrinsics.checkNotNull(directedEdge2);
            directedEdge2.setNextMin(firstOut);
        }
    }

    public final void linkAllDirectedEdges() {
        this.getEdges();
        DirectedEdge prevOut = null;
        DirectedEdge firstIn = null;
        Intrinsics.checkNotNull(this.getEdgeList());
        for (int i = (v36178).size() - 1; -1 < i; --i) {
            List<EdgeEnd> list = this.getEdgeList();
            Intrinsics.checkNotNull(list);
            EdgeEnd edgeEnd = list.get(i);
            Intrinsics.checkNotNull((Object)edgeEnd, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge nextOut = (DirectedEdge)edgeEnd;
            DirectedEdge nextIn = nextOut.getSym();
            if (firstIn == null) {
                firstIn = nextIn;
            }
            if (prevOut != null) {
                DirectedEdge directedEdge = nextIn;
                Intrinsics.checkNotNull((Object)directedEdge);
                directedEdge.setNext(prevOut);
            }
            prevOut = nextOut;
        }
        DirectedEdge directedEdge = firstIn;
        Intrinsics.checkNotNull(directedEdge);
        directedEdge.setNext(prevOut);
    }

    public final void findCoveredLineEdges() {
        int startLoc = 0;
        startLoc = -1;
        DirectedEdgeStar $this$findCoveredLineEdges_u24lambda_u240 = this;
        boolean bl = false;
        Iterator<?> it = $this$findCoveredLineEdges_u24lambda_u240.iterator();
        while (it.hasNext()) {
            DirectedEdge nextIn;
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge nextOut = (DirectedEdge)obj;
            Intrinsics.checkNotNull((Object)nextOut.getSym());
            if (nextOut.isLineEdge()) continue;
            if (nextOut.isInResult()) {
                startLoc = 0;
                break;
            }
            if (!nextIn.isInResult()) continue;
            startLoc = 2;
            break;
        }
        if (startLoc == -1) {
            return;
        }
        int currLoc = startLoc;
        Iterator<?> it2 = this.iterator();
        while (it2.hasNext()) {
            DirectedEdge nextIn;
            Object obj = it2.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge nextOut = (DirectedEdge)obj;
            Intrinsics.checkNotNull((Object)nextOut.getSym());
            if (nextOut.isLineEdge()) {
                nextOut.getEdge().setCovered(currLoc == 0);
                continue;
            }
            if (nextOut.isInResult()) {
                currLoc = 2;
            }
            if (!nextIn.isInResult()) continue;
            currLoc = 0;
        }
    }

    public final void computeDepths(@NotNull DirectedEdge de) {
        Intrinsics.checkNotNullParameter((Object)de, (String)"de");
        int edgeIndex = this.findIndex(de);
        int startDepth = de.getDepth(1);
        int targetLastDepth = de.getDepth(2);
        List<EdgeEnd> list = this.getEdgeList();
        Intrinsics.checkNotNull(list);
        int nextDepth = this.computeDepths(edgeIndex + 1, list.size(), startDepth);
        int lastDepth = this.computeDepths(0, edgeIndex, nextDepth);
        if (lastDepth != targetLastDepth) {
            throw new TopologyException("depth mismatch at " + de.getCoordinate());
        }
    }

    private final int computeDepths(int startIndex, int endIndex, int startDepth) {
        int currDepth = startDepth;
        for (int i = startIndex; i < endIndex; ++i) {
            List<EdgeEnd> list = this.getEdgeList();
            Intrinsics.checkNotNull(list);
            EdgeEnd edgeEnd = list.get(i);
            Intrinsics.checkNotNull((Object)edgeEnd, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge nextDe = (DirectedEdge)edgeEnd;
            nextDe.setEdgeDepths(2, currDepth);
            currDepth = nextDe.getDepth(1);
        }
        return currDepth;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/locationtech/jts/geomgraph/DirectedEdgeStar$Companion;", "", "<init>", "()V", "SCANNING_FOR_INCOMING", "", "LINKING_TO_OUTGOING", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

