/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B-\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0004J\u0013\u0010,\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0010\u0010.\u001a\u00020&2\b\u0010/\u001a\u0004\u0018\u00010\u0000J\u0010\u00100\u001a\u00020+2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0006R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001b\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u001e\u0010!\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001e\u0010$\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u001e\u0010'\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020&@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00065"}, d2={"Lorg/locationtech/jts/geomgraph/EdgeEnd;", "", "", "edge", "Lorg/locationtech/jts/geomgraph/Edge;", "<init>", "(Lorg/locationtech/jts/geomgraph/Edge;)V", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "label", "Lorg/locationtech/jts/geomgraph/Label;", "(Lorg/locationtech/jts/geomgraph/Edge;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geomgraph/Label;)V", "getEdge", "()Lorg/locationtech/jts/geomgraph/Edge;", "setEdge", "getLabel", "()Lorg/locationtech/jts/geomgraph/Label;", "setLabel", "(Lorg/locationtech/jts/geomgraph/Label;)V", "node", "Lorg/locationtech/jts/geomgraph/Node;", "getNode", "()Lorg/locationtech/jts/geomgraph/Node;", "setNode", "(Lorg/locationtech/jts/geomgraph/Node;)V", "value", "coordinate", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "directedCoordinate", "getDirectedCoordinate", "", "dx", "getDx", "()D", "dy", "getDy", "", "quadrant", "getQuadrant", "()I", "init", "", "compareTo", "obj", "compareDirection", "e", "computeLabel", "boundaryNodeRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "toString", "", "kts-core"})
public class EdgeEnd
implements Comparable<Object> {
    @NotNull
    private Edge edge;
    @Nullable
    private Label label;
    @Nullable
    private Node node;
    @Nullable
    private Coordinate coordinate;
    @Nullable
    private Coordinate directedCoordinate;
    private double dx;
    private double dy;
    private int quadrant;

    protected EdgeEnd(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        this.edge = edge;
    }

    @NotNull
    public Edge getEdge() {
        return this.edge;
    }

    public void setEdge(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"<set-?>");
        this.edge = edge;
    }

    @Nullable
    public final Label getLabel() {
        return this.label;
    }

    public final void setLabel(@Nullable Label label) {
        this.label = label;
    }

    @Nullable
    public final Node getNode() {
        return this.node;
    }

    public final void setNode(@Nullable Node node) {
        this.node = node;
    }

    @Nullable
    public final Coordinate getCoordinate() {
        return this.coordinate;
    }

    @Nullable
    public final Coordinate getDirectedCoordinate() {
        return this.directedCoordinate;
    }

    public final double getDx() {
        return this.dx;
    }

    public final double getDy() {
        return this.dy;
    }

    public final int getQuadrant() {
        return this.quadrant;
    }

    @JvmOverloads
    public EdgeEnd(@NotNull Edge edge, @NotNull Coordinate p0, @NotNull Coordinate p1, @Nullable Label label) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this(edge);
        this.init(p0, p1);
        this.label = label;
    }

    public /* synthetic */ EdgeEnd(Edge edge, Coordinate coordinate, Coordinate coordinate2, Label label, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            label = null;
        }
        this(edge, coordinate, coordinate2, label);
    }

    protected final void init(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this.coordinate = p0;
        this.directedCoordinate = p1;
        this.dx = p1.x - p0.x;
        this.dy = p1.y - p0.y;
        this.quadrant = Quadrant.INSTANCE.quadrant(this.dx, this.dy);
        Assert.INSTANCE.isTrue(!(this.dx == 0.0) || !(this.dy == 0.0), "EdgeEnd with identical endpoints found");
    }

    @Override
    public int compareTo(@Nullable Object obj) {
        EdgeEnd e = (EdgeEnd)obj;
        return this.compareDirection(e);
    }

    public final int compareDirection(@Nullable EdgeEnd e) {
        EdgeEnd edgeEnd = e;
        Intrinsics.checkNotNull((Object)edgeEnd);
        if (this.dx == edgeEnd.dx && this.dy == e.dy) {
            return 0;
        }
        if (this.quadrant > e.quadrant) {
            return 1;
        }
        return this.quadrant < e.quadrant ? -1 : Orientation.index(e.coordinate, e.directedCoordinate, this.directedCoordinate);
    }

    public void computeLabel(@NotNull BoundaryNodeRule boundaryNodeRule) {
        Intrinsics.checkNotNullParameter((Object)boundaryNodeRule, (String)"boundaryNodeRule");
    }

    @NotNull
    public String toString() {
        double angle = Math.INSTANCE.atan2(this.dy, this.dx);
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        String className = string;
        int lastDotPos = StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null);
        String string2 = className.substring(lastDotPos + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String name = string2;
        return "  " + name + ": " + this.coordinate + " - " + this.directedCoordinate + " " + this.quadrant + ":" + angle + "   " + this.label;
    }

    @JvmOverloads
    public EdgeEnd(@NotNull Edge edge, @NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this(edge, p0, p1, null, 8, null);
    }
}

