/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.legacy.map.TreeMap;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H&J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0004J\u0006\u0010\u001c\u001a\u00020\u001dJ\r\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0086\u0002J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u000e\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006J\u001b\u0010#\u001a\u00020\u00142\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*H\u0002J+\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\u0002012\u0006\u0010$\u001a\u00020&J\u0010\u00102\u001a\u0002012\u0006\u0010,\u001a\u00020\u001dH\u0002J\u000e\u00103\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u001dJ\u000e\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u0006J\b\u00106\u001a\u000207H\u0016R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00068"}, d2={"Lorg/locationtech/jts/geomgraph/EdgeEndStar;", "", "<init>", "()V", "edgeMap", "", "Lorg/locationtech/jts/geomgraph/EdgeEnd;", "getEdgeMap", "()Ljava/util/Map;", "setEdgeMap", "(Ljava/util/Map;)V", "edgeList", "", "getEdgeList", "()Ljava/util/List;", "setEdgeList", "(Ljava/util/List;)V", "ptInAreaLocation", "", "insert", "", "e", "insertEdgeEnd", "obj", "coordinate", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "getDegree", "", "iterator", "", "getEdges", "getNextCW", "ee", "computeLabelling", "geomGraph", "", "Lorg/locationtech/jts/geomgraph/GeometryGraph;", "([Lorg/locationtech/jts/geomgraph/GeometryGraph;)V", "computeEdgeEndLabels", "boundaryNodeRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "getLocation", "geomIndex", "p", "geom", "(ILorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geomgraph/GeometryGraph;)I", "isAreaLabelsConsistent", "", "checkAreaLabelsConsistent", "propagateSideLabels", "findIndex", "eSearch", "toString", "", "kts-core"})
public abstract class EdgeEndStar {
    @NotNull
    private Map<EdgeEnd, EdgeEnd> edgeMap = new TreeMap(null, 1, null);
    @Nullable
    private List<EdgeEnd> edgeList;
    @NotNull
    private final int[] ptInAreaLocation;

    public EdgeEndStar() {
        int[] nArray = new int[]{-1, -1};
        this.ptInAreaLocation = nArray;
    }

    @NotNull
    protected final Map<EdgeEnd, EdgeEnd> getEdgeMap() {
        return this.edgeMap;
    }

    protected final void setEdgeMap(@NotNull Map<EdgeEnd, EdgeEnd> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.edgeMap = map;
    }

    @Nullable
    protected final List<EdgeEnd> getEdgeList() {
        return this.edgeList;
    }

    protected final void setEdgeList(@Nullable List<EdgeEnd> list) {
        this.edgeList = list;
    }

    public abstract void insert(@Nullable EdgeEnd var1);

    protected final void insertEdgeEnd(@NotNull EdgeEnd e, @NotNull EdgeEnd obj) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        this.edgeMap.put(e, obj);
        this.edgeList = null;
    }

    @Nullable
    public final Coordinate getCoordinate() {
        Iterator<?> it = this.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Object obj = it.next();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
        EdgeEnd e = (EdgeEnd)obj;
        return e.getCoordinate();
    }

    public final int getDegree() {
        return this.edgeMap.size();
    }

    @NotNull
    public final Iterator<?> iterator() {
        return this.getEdges().iterator();
    }

    @NotNull
    public final List<EdgeEnd> getEdges() {
        if (this.edgeList == null) {
            this.edgeList = new ArrayList<EdgeEnd>(this.edgeMap.values());
        }
        List<EdgeEnd> list = this.edgeList;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @NotNull
    public final EdgeEnd getNextCW(@NotNull EdgeEnd ee) {
        Intrinsics.checkNotNullParameter((Object)ee, (String)"ee");
        this.getEdges();
        List<EdgeEnd> list = this.edgeList;
        Intrinsics.checkNotNull(list);
        int i = list.indexOf(ee);
        int iNextCW = i - 1;
        if (i == 0) {
            List<EdgeEnd> list2 = this.edgeList;
            Intrinsics.checkNotNull(list2);
            iNextCW = list2.size() - 1;
        }
        List<EdgeEnd> list3 = this.edgeList;
        Intrinsics.checkNotNull(list3);
        return list3.get(iNextCW);
    }

    public void computeLabelling(@NotNull GeometryGraph[] geomGraph) {
        Intrinsics.checkNotNullParameter((Object)geomGraph, (String)"geomGraph");
        BoundaryNodeRule boundaryNodeRule = geomGraph[0].getBoundaryNodeRule();
        Intrinsics.checkNotNull((Object)boundaryNodeRule);
        this.computeEdgeEndLabels(boundaryNodeRule);
        this.propagateSideLabels(0);
        this.propagateSideLabels(1);
        boolean[] blArray = new boolean[]{false, false};
        boolean[] hasDimensionalCollapseEdge = blArray;
        EdgeEndStar $this$computeLabelling_u24lambda_u240 = this;
        boolean bl = false;
        Iterator<?> it = $this$computeLabelling_u24lambda_u240.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)obj;
            Intrinsics.checkNotNull((Object)e.getLabel());
            for (int geomi = 0; geomi < 2; ++geomi) {
                Label label;
                if (!label.isLine(geomi) || label.getLocation(geomi) != 1) continue;
                hasDimensionalCollapseEdge[geomi] = true;
            }
        }
        Iterator<?> it2 = this.iterator();
        while (it2.hasNext()) {
            Object obj = it2.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)obj;
            Intrinsics.checkNotNull((Object)e.getLabel());
            for (int geomi = 0; geomi < 2; ++geomi) {
                int n;
                Label label;
                if (!label.isAnyNull(geomi)) continue;
                int loc = -1;
                if (hasDimensionalCollapseEdge[geomi]) {
                    n = 2;
                } else {
                    Coordinate p;
                    Intrinsics.checkNotNull((Object)e.getCoordinate());
                    n = this.getLocation(geomi, p, geomGraph);
                }
                loc = n;
                label.setAllLocationsIfNull(geomi, loc);
            }
        }
    }

    private final void computeEdgeEndLabels(BoundaryNodeRule boundaryNodeRule) {
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd ee = (EdgeEnd)obj;
            ee.computeLabel(boundaryNodeRule);
        }
    }

    private final int getLocation(int geomIndex, Coordinate p, GeometryGraph[] geom) {
        if (this.ptInAreaLocation[geomIndex] == -1) {
            Geometry geometry = geom[geomIndex].getGeometry();
            Intrinsics.checkNotNull((Object)geometry);
            this.ptInAreaLocation[geomIndex] = SimplePointInAreaLocator.Companion.locate(p, geometry);
        }
        return this.ptInAreaLocation[geomIndex];
    }

    public final boolean isAreaLabelsConsistent(@NotNull GeometryGraph geomGraph) {
        Intrinsics.checkNotNullParameter((Object)geomGraph, (String)"geomGraph");
        BoundaryNodeRule boundaryNodeRule = geomGraph.getBoundaryNodeRule();
        Intrinsics.checkNotNull((Object)boundaryNodeRule);
        this.computeEdgeEndLabels(boundaryNodeRule);
        return this.checkAreaLabelsConsistent(0);
    }

    private final boolean checkAreaLabelsConsistent(int geomIndex) {
        List<EdgeEnd> edges = this.getEdges();
        if (edges.size() <= 0) {
            return true;
        }
        int lastEdgeIndex = edges.size() - 1;
        Label label = edges.get(lastEdgeIndex).getLabel();
        Intrinsics.checkNotNull((Object)label);
        Label startLabel = label;
        int startLoc = startLabel.getLocation(geomIndex, 1);
        Assert.INSTANCE.isTrue(startLoc != -1, "Found unlabelled area edge");
        int currLoc = startLoc;
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Label label2;
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)obj;
            Intrinsics.checkNotNull((Object)e.getLabel());
            Assert.INSTANCE.isTrue(label2.isArea(geomIndex), "Found non-area edge");
            int leftLoc = label2.getLocation(geomIndex, 1);
            int rightLoc = label2.getLocation(geomIndex, 2);
            if (leftLoc == rightLoc) {
                return false;
            }
            if (rightLoc != currLoc) {
                return false;
            }
            currLoc = leftLoc;
        }
        return true;
    }

    public final void propagateSideLabels(int geomIndex) {
        int startLoc = 0;
        startLoc = -1;
        EdgeEndStar $this$propagateSideLabels_u24lambda_u240 = this;
        boolean bl = false;
        Iterator<?> it = $this$propagateSideLabels_u24lambda_u240.iterator();
        while (it.hasNext()) {
            Label label;
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)obj;
            Intrinsics.checkNotNull((Object)e.getLabel());
            if (!label.isArea(geomIndex) || label.getLocation(geomIndex, 1) == -1) continue;
            startLoc = label.getLocation(geomIndex, 1);
        }
        if (startLoc == -1) {
            return;
        }
        int currLoc = startLoc;
        Iterator<?> it2 = this.iterator();
        while (it2.hasNext()) {
            Label label;
            Object obj = it2.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)obj;
            Intrinsics.checkNotNull((Object)e.getLabel());
            if (label.getLocation(geomIndex, 0) == -1) {
                label.setLocation(geomIndex, 0, currLoc);
            }
            if (!label.isArea(geomIndex)) continue;
            int leftLoc = label.getLocation(geomIndex, 1);
            int rightLoc = label.getLocation(geomIndex, 2);
            if (rightLoc != -1) {
                if (rightLoc != currLoc) {
                    throw new TopologyException("side location conflict", e.getCoordinate());
                }
                if (leftLoc == -1) {
                    Assert.shouldNeverReachHere("found single null side (at " + e.getCoordinate() + ")");
                }
                currLoc = leftLoc;
                continue;
            }
            Assert.INSTANCE.isTrue(label.getLocation(geomIndex, 1) == -1, "found single null side");
            label.setLocation(geomIndex, 2, currLoc);
            label.setLocation(geomIndex, 1, currLoc);
        }
    }

    public final int findIndex(@NotNull EdgeEnd eSearch) {
        Intrinsics.checkNotNullParameter((Object)eSearch, (String)"eSearch");
        this.iterator();
        List<EdgeEnd> list = this.edgeList;
        Intrinsics.checkNotNull(list);
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            List<EdgeEnd> list2 = this.edgeList;
            Intrinsics.checkNotNull(list2);
            if (list2.get(i) != eSearch) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("EdgeEndStar:   " + this.getCoordinate());
        buf.append("\n");
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)obj;
            buf.append(e);
            buf.append("\n");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

