/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\bJ\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0016\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006J\b\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lorg/locationtech/jts/geomgraph/EdgeIntersection;", "", "", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "segmentIndex", "", "dist", "", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;ID)V", "getCoord", "()Lorg/locationtech/jts/geom/Coordinate;", "setCoord", "(Lorg/locationtech/jts/geom/Coordinate;)V", "getSegmentIndex", "()I", "setSegmentIndex", "(I)V", "getDist", "()D", "setDist", "(D)V", "getCoordinate", "getDistance", "compareTo", "obj", "compare", "isEndPoint", "", "maxSegmentIndex", "toString", "", "kts-core"})
public final class EdgeIntersection
implements Comparable<Object> {
    @NotNull
    private Coordinate coord;
    private int segmentIndex;
    private double dist;

    public EdgeIntersection(@Nullable Coordinate coord, int segmentIndex, double dist) {
        Coordinate coordinate = coord;
        Intrinsics.checkNotNull((Object)coordinate);
        this.coord = new Coordinate(coordinate);
        this.segmentIndex = segmentIndex;
        this.dist = dist;
    }

    @NotNull
    public final Coordinate getCoord() {
        return this.coord;
    }

    public final void setCoord(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"<set-?>");
        this.coord = coordinate;
    }

    public final int getSegmentIndex() {
        return this.segmentIndex;
    }

    public final void setSegmentIndex(int n) {
        this.segmentIndex = n;
    }

    public final double getDist() {
        return this.dist;
    }

    public final void setDist(double d) {
        this.dist = d;
    }

    @NotNull
    public final Coordinate getCoordinate() {
        return this.coord;
    }

    public final double getDistance() {
        return this.dist;
    }

    @Override
    public int compareTo(@Nullable Object obj) {
        EdgeIntersection other;
        EdgeIntersection edgeIntersection = other = (EdgeIntersection)obj;
        Intrinsics.checkNotNull((Object)edgeIntersection);
        return this.compare(edgeIntersection.segmentIndex, other.dist);
    }

    public final int compare(int segmentIndex, double dist) {
        if (this.segmentIndex < segmentIndex) {
            return -1;
        }
        if (this.segmentIndex > segmentIndex) {
            return 1;
        }
        if (this.dist < dist) {
            return -1;
        }
        return this.dist > dist ? 1 : 0;
    }

    public final boolean isEndPoint(int maxSegmentIndex) {
        if (this.segmentIndex == 0 && this.dist == 0.0) {
            return true;
        }
        return this.segmentIndex == maxSegmentIndex;
    }

    @NotNull
    public String toString() {
        return this.coord + " seg # = " + this.segmentIndex + " dist = " + this.dist;
    }
}

