/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.legacy.map.TreeMap;
import org.locationtech.jts.noding.OrientedCoordinateArray;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0012\u0010\r\u001a\u00020\u000b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0006J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/geomgraph/EdgeList;", "", "<init>", "()V", "edges", "", "Lorg/locationtech/jts/geomgraph/Edge;", "ocaMap", "", "Lorg/locationtech/jts/noding/OrientedCoordinateArray;", "add", "", "e", "addAll", "edgeColl", "", "getEdges", "", "findEqualEdge", "iterator", "", "get", "i", "", "findEdgeIndex", "kts-core"})
public final class EdgeList {
    @NotNull
    private final List<Edge> edges = new ArrayList();
    @NotNull
    private final Map<OrientedCoordinateArray, Object> ocaMap = new TreeMap(null, 1, null);

    public final void add(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.edges.add(e);
        OrientedCoordinateArray oca = new OrientedCoordinateArray(e.getCoordinates());
        this.ocaMap.put(oca, e);
    }

    public final void addAll(@NotNull Collection<?> edgeColl) {
        Intrinsics.checkNotNullParameter(edgeColl, (String)"edgeColl");
        for (Object obj : edgeColl) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            this.add((Edge)obj);
        }
    }

    @NotNull
    public final List<Edge> getEdges() {
        return this.edges;
    }

    @Nullable
    public final Edge findEqualEdge(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        OrientedCoordinateArray oca = new OrientedCoordinateArray(e.getCoordinates());
        return (Edge)this.ocaMap.get(oca);
    }

    @NotNull
    public final ListIterator<Edge> iterator() {
        return this.edges.listIterator();
    }

    @NotNull
    public final Edge get(int i) {
        return this.edges.get(i);
    }

    public final int findEdgeIndex(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int n = ((Collection)this.edges).size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)this.edges.get(i), (Object)e)) continue;
            return i;
        }
        return -1;
    }
}

