/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010!\u001a\u00020\u001cJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0012J\b\u0010$\u001a\u0004\u0018\u00010\u001aJ\u0006\u0010%\u001a\u00020\u0018J\u0006\u0010&\u001a\u00020\u001cJ\b\u0010'\u001a\u0004\u0018\u00010\u0000J\u0010\u0010(\u001a\u00020)2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0000J\u0010\u0010*\u001a\u00020)2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0000J\u000e\u0010+\u001a\u00020,2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010-\u001a\u00020)J\u0012\u0010.\u001a\u0004\u0018\u00010\u00032\u0006\u0010/\u001a\u00020\u0003H&J\u0018\u00100\u001a\u00020)2\u0006\u0010/\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0000H&J\n\u00102\u001a\u0006\u0012\u0002\b\u00030\u0014J\u0012\u00103\u001a\u00020)2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0004J\u0006\u00104\u001a\u00020\u0012J\b\u00105\u001a\u00020)H\u0002J\u0006\u00106\u001a\u00020)J\u0010\u00107\u001a\u00020)2\u0006\u00108\u001a\u00020\u0018H\u0004J\u0018\u00107\u001a\u00020)2\u0006\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020\u0012H\u0004J \u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020\u001cH\u0004J\u0010\u0010?\u001a\u00020\u001c2\b\u0010@\u001a\u0004\u0018\u00010\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001e\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fj\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001` X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/locationtech/jts/geomgraph/EdgeRing;", "", "start", "Lorg/locationtech/jts/geomgraph/DirectedEdge;", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geomgraph/DirectedEdge;Lorg/locationtech/jts/geom/GeometryFactory;)V", "getGeometryFactory", "()Lorg/locationtech/jts/geom/GeometryFactory;", "setGeometryFactory", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "startDe", "getStartDe", "()Lorg/locationtech/jts/geomgraph/DirectedEdge;", "setStartDe", "(Lorg/locationtech/jts/geomgraph/DirectedEdge;)V", "maxNodeDegree", "", "edges", "", "pts", "Lorg/locationtech/jts/geom/Coordinate;", "label", "Lorg/locationtech/jts/geomgraph/Label;", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "isHole", "", "shell", "holes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "isIsolated", "getCoordinate", "i", "getLinearRing", "getLabel", "isShell", "getShell", "setShell", "", "addHole", "toPolygon", "Lorg/locationtech/jts/geom/Polygon;", "computeRing", "getNext", "de", "setEdgeRing", "er", "getEdges", "computePoints", "getMaxNodeDegree", "computeMaxNodeDegree", "setInResult", "mergeLabel", "deLabel", "geomIndex", "addPoints", "edge", "Lorg/locationtech/jts/geomgraph/Edge;", "isForward", "isFirstEdge", "containsPoint", "p", "kts-core"})
public abstract class EdgeRing {
    @NotNull
    private GeometryFactory geometryFactory;
    @Nullable
    private DirectedEdge startDe;
    private int maxNodeDegree;
    @NotNull
    private final List<Object> edges;
    @NotNull
    private final List<Coordinate> pts;
    @NotNull
    private final Label label;
    @Nullable
    private LinearRing ring;
    private boolean isHole;
    @Nullable
    private EdgeRing shell;
    @NotNull
    private final ArrayList<Object> holes;

    public EdgeRing(@Nullable DirectedEdge start, @NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        this.geometryFactory = geometryFactory;
        this.maxNodeDegree = -1;
        this.edges = new ArrayList();
        this.pts = new ArrayList();
        this.label = new Label(-1);
        this.holes = new ArrayList();
        this.computePoints(start);
        this.computeRing();
    }

    @NotNull
    protected final GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    protected final void setGeometryFactory(@NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"<set-?>");
        this.geometryFactory = geometryFactory;
    }

    @Nullable
    protected final DirectedEdge getStartDe() {
        return this.startDe;
    }

    protected final void setStartDe(@Nullable DirectedEdge directedEdge) {
        this.startDe = directedEdge;
    }

    public final boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    public final boolean isHole() {
        return this.isHole;
    }

    @NotNull
    public final Coordinate getCoordinate(int i) {
        return this.pts.get(i);
    }

    @Nullable
    public final LinearRing getLinearRing() {
        return this.ring;
    }

    @NotNull
    public final Label getLabel() {
        return this.label;
    }

    public final boolean isShell() {
        return this.shell == null;
    }

    @Nullable
    public final EdgeRing getShell() {
        return this.shell;
    }

    public final void setShell(@Nullable EdgeRing shell) {
        block0: {
            this.shell = shell;
            EdgeRing edgeRing = shell;
            if (edgeRing == null) break block0;
            edgeRing.addHole(this);
        }
    }

    public final void addHole(@Nullable EdgeRing ring) {
        this.holes.add(ring);
    }

    @NotNull
    public final Polygon toPolygon(@NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        Object[] holeLR = new LinearRing[this.holes.size()];
        int n = ((Collection)this.holes).size();
        for (int i = 0; i < n; ++i) {
            Object object = this.holes.get(i);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeRing");
            holeLR[i] = ((EdgeRing)object).getLinearRing();
        }
        return geometryFactory.createPolygon(this.getLinearRing(), (LinearRing[])ArraysKt.requireNoNulls((Object[])holeLR));
    }

    public final void computeRing() {
        if (this.ring != null) {
            return;
        }
        Object[] coord = new Coordinate[this.pts.size()];
        int n = ((Collection)this.pts).size();
        for (int i = 0; i < n; ++i) {
            coord[i] = this.pts.get(i);
        }
        LinearRing linearRing = this.ring = this.geometryFactory.createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])coord));
        Intrinsics.checkNotNull((Object)linearRing);
        this.isHole = Orientation.isCCW(linearRing.getCoordinates());
    }

    @Nullable
    public abstract DirectedEdge getNext(@NotNull DirectedEdge var1);

    public abstract void setEdgeRing(@NotNull DirectedEdge var1, @NotNull EdgeRing var2);

    @NotNull
    public final List<?> getEdges() {
        return this.edges;
    }

    protected final void computePoints(@Nullable DirectedEdge start) {
        this.startDe = start;
        DirectedEdge de = start;
        boolean isFirstEdge = true;
        do {
            Label label;
            if (de == null) {
                throw new TopologyException("Found null DirectedEdge");
            }
            if (de.getEdgeRing() == this) {
                throw new TopologyException("Directed Edge visited twice during ring-building at " + de.getCoordinate());
            }
            this.edges.add(de);
            Intrinsics.checkNotNull((Object)de.getLabel());
            Assert.isTrue(label.isArea());
            this.mergeLabel(label);
            this.addPoints(de.getEdge(), de.isForward(), isFirstEdge);
            isFirstEdge = false;
            this.setEdgeRing(de, this);
        } while ((de = this.getNext(de)) != this.startDe);
    }

    public final int getMaxNodeDegree() {
        if (this.maxNodeDegree < 0) {
            this.computeMaxNodeDegree();
        }
        return this.maxNodeDegree;
    }

    private final void computeMaxNodeDegree() {
        this.maxNodeDegree = 0;
        DirectedEdge de = this.startDe;
        do {
            Node node;
            DirectedEdge directedEdge = de;
            Intrinsics.checkNotNull((Object)directedEdge);
            Intrinsics.checkNotNull((Object)directedEdge.getNode());
            EdgeEndStar edgeEndStar = node.getEdges();
            Intrinsics.checkNotNull((Object)edgeEndStar, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdgeStar");
            int degree = ((DirectedEdgeStar)edgeEndStar).getOutgoingDegree(this);
            if (degree <= this.maxNodeDegree) continue;
            this.maxNodeDegree = degree;
        } while ((de = this.getNext(de)) != this.startDe);
        this.maxNodeDegree *= 2;
    }

    public final void setInResult() {
        DirectedEdge de = this.startDe;
        do {
            DirectedEdge directedEdge = de;
            Intrinsics.checkNotNull((Object)directedEdge);
            directedEdge.getEdge().setInResult(true);
        } while ((de = de.getNext()) != this.startDe);
    }

    protected final void mergeLabel(@NotNull Label deLabel) {
        Intrinsics.checkNotNullParameter((Object)deLabel, (String)"deLabel");
        this.mergeLabel(deLabel, 0);
        this.mergeLabel(deLabel, 1);
    }

    protected final void mergeLabel(@NotNull Label deLabel, int geomIndex) {
        Intrinsics.checkNotNullParameter((Object)deLabel, (String)"deLabel");
        int loc = deLabel.getLocation(geomIndex, 2);
        if (loc == -1) {
            return;
        }
        if (this.label.getLocation(geomIndex) == -1) {
            this.label.setLocation(geomIndex, loc);
            return;
        }
    }

    protected final void addPoints(@NotNull Edge edge, boolean isForward, boolean isFirstEdge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        Coordinate[] edgePts = edge.getCoordinates();
        if (isForward) {
            int startIndex = 1;
            if (isFirstEdge) {
                startIndex = 0;
            }
            int n = edgePts.length;
            for (int i = startIndex; i < n; ++i) {
                this.pts.add(edgePts[i]);
            }
        } else {
            int startIndex = edgePts.length - 2;
            if (isFirstEdge) {
                startIndex = edgePts.length - 1;
            }
            for (int i = startIndex; -1 < i; --i) {
                this.pts.add(edgePts[i]);
            }
        }
    }

    public final boolean containsPoint(@Nullable Coordinate p) {
        LinearRing shell;
        LinearRing linearRing = shell = this.getLinearRing();
        Intrinsics.checkNotNull((Object)linearRing);
        Envelope env = linearRing.getEnvelopeInternal();
        Coordinate coordinate = p;
        Intrinsics.checkNotNull((Object)coordinate);
        if (!env.contains(coordinate)) {
            return false;
        }
        if (!PointLocation.isInRing(p, shell.getCoordinates())) {
            return false;
        }
        Iterator<Object> iterator2 = this.holes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Object> i = iterator2;
        while (i.hasNext()) {
            Object object = i.next();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeRing");
            EdgeRing hole = (EdgeRing)object;
            if (!hole.containsPoint(p)) continue;
            return false;
        }
        return true;
    }
}

