/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.geomgraph.index.EdgeSetIntersector;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.geomgraph.index.SimpleMCSweepLineIntersector;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 L2\u00020\u0001:\u0001LB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u0013\u001a\u00020\u0010J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0015J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005J\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0012J\u0013\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150 \u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%J\u0014\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0)J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020'2\u0006\u00100\u001a\u000201H\u0002J\"\u00102\u001a\u00020'2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0002J\u0010\u00107\u001a\u00020'2\u0006\u00100\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020'2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020#J\u000e\u0010/\u001a\u00020'2\u0006\u0010<\u001a\u00020\u0015J\u0018\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020\u0010J \u0010B\u001a\u00020>2\u0006\u0010+\u001a\u00020\u00002\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010C\u001a\u00020\u0010J \u0010D\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\u0003H\u0002J\u0018\u0010G\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\u0015H\u0002J\u0010\u0010H\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010I\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u0003H\u0002J\u0010\u0010K\u001a\u00020\u00032\b\u0010<\u001a\u0004\u0018\u00010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/locationtech/jts/geomgraph/GeometryGraph;", "Lorg/locationtech/jts/geomgraph/PlanarGraph;", "argIndex", "", "parentGeom", "Lorg/locationtech/jts/geom/Geometry;", "boundaryNodeRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "<init>", "(ILorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/algorithm/BoundaryNodeRule;)V", "getBoundaryNodeRule", "()Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "lineEdgeMap", "", "", "useBoundaryDeterminationRule", "", "boundaryNodes", "", "hasTooFewPoints", "invalidPoint", "Lorg/locationtech/jts/geom/Coordinate;", "areaPtLocator", "Lorg/locationtech/jts/algorithm/locate/PointOnGeometryLocator;", "ptLocator", "Lorg/locationtech/jts/algorithm/PointLocator;", "createEdgeSetIntersector", "Lorg/locationtech/jts/geomgraph/index/EdgeSetIntersector;", "getInvalidPoint", "getGeometry", "getBoundaryNodes", "getBoundaryPoints", "", "()[Lorg/locationtech/jts/geom/Coordinate;", "findEdge", "Lorg/locationtech/jts/geomgraph/Edge;", "line", "Lorg/locationtech/jts/geom/LineString;", "computeSplitEdges", "", "edgelist", "", "add", "g", "addCollection", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "addPoint", "p", "Lorg/locationtech/jts/geom/Point;", "addPolygonRing", "lr", "Lorg/locationtech/jts/geom/LinearRing;", "cwLeft", "cwRight", "addPolygon", "Lorg/locationtech/jts/geom/Polygon;", "addLineString", "addEdge", "e", "pt", "computeSelfNodes", "Lorg/locationtech/jts/geomgraph/index/SegmentIntersector;", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "computeRingSelfNodes", "computeEdgeIntersections", "includeProper", "insertPoint", "coord", "onLocation", "insertBoundaryPoint", "addSelfIntersectionNodes", "addSelfIntersectionNode", "loc", "locate", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nGeometryGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeometryGraph.kt\norg/locationtech/jts/geomgraph/GeometryGraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1#2:416\n*E\n"})
public final class GeometryGraph
extends PlanarGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int argIndex;
    @Nullable
    private final Geometry parentGeom;
    @Nullable
    private final BoundaryNodeRule boundaryNodeRule;
    @NotNull
    private final Map<Object, Object> lineEdgeMap;
    private boolean useBoundaryDeterminationRule;
    @Nullable
    private Collection<?> boundaryNodes;
    private boolean hasTooFewPoints;
    @Nullable
    private Coordinate invalidPoint;
    @Nullable
    private PointOnGeometryLocator areaPtLocator;
    @NotNull
    private final PointLocator ptLocator;

    @JvmOverloads
    public GeometryGraph(int argIndex, @Nullable Geometry parentGeom, @Nullable BoundaryNodeRule boundaryNodeRule) {
        block0: {
            this.argIndex = argIndex;
            this.parentGeom = parentGeom;
            this.boundaryNodeRule = boundaryNodeRule;
            this.lineEdgeMap = new HashMap();
            this.useBoundaryDeterminationRule = true;
            this.ptLocator = new PointLocator();
            Geometry geometry = this.parentGeom;
            if (geometry == null) break block0;
            Geometry it = geometry;
            boolean bl = false;
            this.add(it);
        }
    }

    public /* synthetic */ GeometryGraph(int n, Geometry geometry, BoundaryNodeRule boundaryNodeRule, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            boundaryNodeRule = BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE;
        }
        this(n, geometry, boundaryNodeRule);
    }

    @Nullable
    public final BoundaryNodeRule getBoundaryNodeRule() {
        return this.boundaryNodeRule;
    }

    private final EdgeSetIntersector createEdgeSetIntersector() {
        return new SimpleMCSweepLineIntersector();
    }

    public final boolean hasTooFewPoints() {
        return this.hasTooFewPoints;
    }

    @Nullable
    public final Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    @Nullable
    public final Geometry getGeometry() {
        return this.parentGeom;
    }

    @NotNull
    public final Collection<?> getBoundaryNodes() {
        if (this.boundaryNodes == null) {
            this.boundaryNodes = this.getNodes().getBoundaryNodes(this.argIndex);
        }
        Collection<?> collection = this.boundaryNodes;
        Intrinsics.checkNotNull(collection);
        return collection;
    }

    @NotNull
    public final Coordinate[] getBoundaryPoints() {
        Collection<?> coll = this.getBoundaryNodes();
        Coordinate[] pts = new Coordinate[coll.size()];
        int i = 0;
        for (Object obj : coll) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            int n = i++;
            Coordinate coordinate = node.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            pts[n] = coordinate.copy();
        }
        return pts;
    }

    @Nullable
    public final Edge findEdge(@Nullable LineString line) {
        return (Edge)this.lineEdgeMap.get(line);
    }

    public final void computeSplitEdges(@NotNull List<Edge> edgelist) {
        Intrinsics.checkNotNullParameter(edgelist, (String)"edgelist");
        Iterator<Edge> i = this.getEdges().iterator();
        while (i.hasNext()) {
            Edge e;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            e.getEiList().addSplitEdges(edgelist);
        }
    }

    private final void add(Geometry g) {
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof MultiPolygon) {
            this.useBoundaryDeterminationRule = false;
        }
        if (g instanceof Polygon) {
            this.addPolygon((Polygon)g);
        } else if (g instanceof LineString) {
            this.addLineString((LineString)g);
        } else if (g instanceof Point) {
            this.addPoint((Point)g);
        } else if (g instanceof MultiPoint) {
            this.addCollection((GeometryCollection)g);
        } else if (g instanceof MultiLineString) {
            this.addCollection((GeometryCollection)g);
        } else if (g instanceof MultiPolygon) {
            this.addCollection((GeometryCollection)g);
        } else if (g instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g);
        } else {
            throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(g.getClass()).getSimpleName());
        }
    }

    private final void addCollection(GeometryCollection gc) {
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry g = gc.getGeometryN(i);
            this.add(g);
        }
    }

    private final void addPoint(Point p) {
        Coordinate coordinate = p.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coord = coordinate;
        this.insertPoint(this.argIndex, coord, 0);
    }

    private final void addPolygonRing(LinearRing lr, int cwLeft, int cwRight) {
        LinearRing linearRing = lr;
        Intrinsics.checkNotNull((Object)linearRing);
        if (linearRing.isEmpty()) {
            return;
        }
        Coordinate[] coord = CoordinateArrays.INSTANCE.removeRepeatedPoints(lr.getCoordinates());
        if (coord.length < 4) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coord[0];
            return;
        }
        int left = cwLeft;
        int right = cwRight;
        if (Orientation.isCCW(coord)) {
            left = cwRight;
            right = cwLeft;
        }
        Edge e = new Edge(coord, new Label(this.argIndex, 1, left, right));
        this.lineEdgeMap.put(lr, e);
        this.insertEdge(e);
        this.insertPoint(this.argIndex, coord[0], 1);
    }

    private final void addPolygon(Polygon p) {
        this.addPolygonRing(p.getExteriorRing(), 2, 0);
        int n = p.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            LinearRing hole = p.getInteriorRingN(i);
            this.addPolygonRing(hole, 0, 2);
        }
    }

    private final void addLineString(LineString line) {
        Coordinate[] coord = CoordinateArrays.INSTANCE.removeRepeatedPoints(line.getCoordinates());
        if (coord.length < 2) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coord[0];
            return;
        }
        Edge e = new Edge(coord, new Label(this.argIndex, 0));
        this.lineEdgeMap.put(line, e);
        this.insertEdge(e);
        Assert.INSTANCE.isTrue(coord.length >= 2, "found LineString with single point");
        this.insertBoundaryPoint(this.argIndex, coord[0]);
        this.insertBoundaryPoint(this.argIndex, coord[coord.length - 1]);
    }

    public final void addEdge(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.insertEdge(e);
        Coordinate[] coord = e.getCoordinates();
        this.insertPoint(this.argIndex, coord[0], 1);
        this.insertPoint(this.argIndex, coord[coord.length - 1], 1);
    }

    public final void addPoint(@NotNull Coordinate pt) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        this.insertPoint(this.argIndex, pt, 0);
    }

    @NotNull
    public final SegmentIntersector computeSelfNodes(@Nullable LineIntersector li, boolean computeRingSelfNodes) {
        LineIntersector lineIntersector = li;
        Intrinsics.checkNotNull((Object)lineIntersector);
        SegmentIntersector si = new SegmentIntersector(lineIntersector, true, false);
        EdgeSetIntersector esi = this.createEdgeSetIntersector();
        boolean isRings = this.parentGeom instanceof LinearRing || this.parentGeom instanceof Polygon || this.parentGeom instanceof MultiPolygon;
        boolean computeAllSegments = computeRingSelfNodes || !isRings;
        esi.computeIntersections(this.getEdges(), si, computeAllSegments);
        this.addSelfIntersectionNodes(this.argIndex);
        return si;
    }

    @NotNull
    public final SegmentIntersector computeEdgeIntersections(@NotNull GeometryGraph g, @Nullable LineIntersector li, boolean includeProper) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        LineIntersector lineIntersector = li;
        Intrinsics.checkNotNull((Object)lineIntersector);
        SegmentIntersector si = new SegmentIntersector(lineIntersector, includeProper, true);
        si.setBoundaryNodes(this.getBoundaryNodes(), g.getBoundaryNodes());
        EdgeSetIntersector esi = this.createEdgeSetIntersector();
        esi.computeIntersections(this.getEdges(), g.getEdges(), si);
        return si;
    }

    private final void insertPoint(int argIndex, Coordinate coord, int onLocation) {
        Node n = this.getNodes().addNode(coord);
        Label lbl = n.getLabel();
        if (lbl == null) {
            n.setLabel(new Label(argIndex, onLocation));
        } else {
            lbl.setLocation(argIndex, onLocation);
        }
    }

    private final void insertBoundaryPoint(int argIndex, Coordinate coord) {
        Node n = this.getNodes().addNode(coord);
        Label label = n.getLabel();
        Intrinsics.checkNotNull((Object)label);
        Label lbl = label;
        int boundaryCount = 1;
        int loc = -1;
        loc = lbl.getLocation(argIndex, 0);
        if (loc == 1) {
            ++boundaryCount;
        }
        int newLoc = Companion.determineBoundary(this.boundaryNodeRule, boundaryCount);
        lbl.setLocation(argIndex, newLoc);
    }

    private final void addSelfIntersectionNodes(int argIndex) {
        Iterator<Edge> i = this.getEdges().iterator();
        while (i.hasNext()) {
            Edge e;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Label label = e.getLabel();
            Intrinsics.checkNotNull((Object)label);
            int eLoc = label.getLocation(argIndex);
            Iterator<?> eiIt = e.getEiList().iterator();
            while (eiIt.hasNext()) {
                Object obj = eiIt.next();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeIntersection");
                EdgeIntersection ei = (EdgeIntersection)obj;
                this.addSelfIntersectionNode(argIndex, ei.getCoord(), eLoc);
            }
        }
    }

    private final void addSelfIntersectionNode(int argIndex, Coordinate coord, int loc) {
        if (this.isBoundaryNode(argIndex, coord)) {
            return;
        }
        if (loc == 1 && this.useBoundaryDeterminationRule) {
            this.insertBoundaryPoint(argIndex, coord);
        } else {
            this.insertPoint(argIndex, coord, loc);
        }
    }

    public final int locate(@Nullable Coordinate pt) {
        if (this.parentGeom instanceof Polygonal && this.parentGeom.getNumGeometries() > 50) {
            if (this.areaPtLocator == null) {
                this.areaPtLocator = new IndexedPointInAreaLocator(this.parentGeom);
            }
            PointOnGeometryLocator pointOnGeometryLocator = this.areaPtLocator;
            Intrinsics.checkNotNull((Object)pointOnGeometryLocator);
            Coordinate coordinate = pt;
            Intrinsics.checkNotNull((Object)coordinate);
            return pointOnGeometryLocator.locate(coordinate);
        }
        Coordinate coordinate = pt;
        Intrinsics.checkNotNull((Object)coordinate);
        Geometry geometry = this.parentGeom;
        Intrinsics.checkNotNull((Object)geometry);
        return this.ptLocator.locate(coordinate, geometry);
    }

    @JvmOverloads
    public GeometryGraph(int argIndex, @Nullable Geometry parentGeom) {
        this(argIndex, parentGeom, null, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/geomgraph/GeometryGraph$Companion;", "", "<init>", "()V", "determineBoundary", "", "boundaryNodeRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "boundaryCount", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int determineBoundary(@Nullable BoundaryNodeRule boundaryNodeRule, int boundaryCount) {
            BoundaryNodeRule boundaryNodeRule2 = boundaryNodeRule;
            Intrinsics.checkNotNull((Object)boundaryNodeRule2);
            return boundaryNodeRule2.isInBoundary(boundaryCount) ? 1 : 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

