/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.NodeFactory;
import org.locationtech.jts.geomgraph.NodeMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\f\b\u0016\u0018\u0000 82\u00020\u0001:\u00018B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019J\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\tH\u0004J\u000e\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015J\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0019J\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\u000e\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!J\u0012\u0010*\u001a\u0004\u0018\u00010(2\b\u0010 \u001a\u0004\u0018\u00010!J\u0014\u0010+\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\t0-J\u0006\u0010.\u001a\u00020#J\u0006\u0010/\u001a\u00020#J\u0010\u00100\u001a\u0004\u0018\u00010\u00152\u0006\u0010$\u001a\u00020\tJ\u0018\u00101\u001a\u0004\u0018\u00010\t2\u0006\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020!J\u0018\u00104\u001a\u0004\u0018\u00010\t2\u0006\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020!J(\u00105\u001a\u00020\u001d2\u0006\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020!2\u0006\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020!H\u0002R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\r\u00a8\u00069"}, d2={"Lorg/locationtech/jts/geomgraph/PlanarGraph;", "", "nodeFact", "Lorg/locationtech/jts/geomgraph/NodeFactory;", "<init>", "(Lorg/locationtech/jts/geomgraph/NodeFactory;)V", "()V", "edges", "", "Lorg/locationtech/jts/geomgraph/Edge;", "getEdges", "()Ljava/util/List;", "setEdges", "(Ljava/util/List;)V", "nodes", "Lorg/locationtech/jts/geomgraph/NodeMap;", "getNodes", "()Lorg/locationtech/jts/geomgraph/NodeMap;", "setNodes", "(Lorg/locationtech/jts/geomgraph/NodeMap;)V", "edgeEndList", "Lorg/locationtech/jts/geomgraph/EdgeEnd;", "getEdgeEndList", "setEdgeEndList", "getEdgeIterator", "", "getEdgeEnds", "", "isBoundaryNode", "", "geomIndex", "", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "insertEdge", "", "e", "add", "getNodeIterator", "addNode", "Lorg/locationtech/jts/geomgraph/Node;", "node", "find", "addEdges", "edgesToAdd", "", "linkResultDirectedEdges", "linkAllDirectedEdges", "findEdgeEnd", "findEdge", "p0", "p1", "findEdgeInSameDirection", "matchInSameDirection", "ep0", "ep1", "Companion", "kts-core"})
public class PlanarGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Edge> edges;
    @NotNull
    private NodeMap nodes;
    @NotNull
    private List<EdgeEnd> edgeEndList;

    @NotNull
    protected final List<Edge> getEdges() {
        return this.edges;
    }

    protected final void setEdges(@NotNull List<Edge> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.edges = list;
    }

    @NotNull
    public final NodeMap getNodes() {
        return this.nodes;
    }

    public final void setNodes(@NotNull NodeMap nodeMap) {
        Intrinsics.checkNotNullParameter((Object)nodeMap, (String)"<set-?>");
        this.nodes = nodeMap;
    }

    @NotNull
    protected final List<EdgeEnd> getEdgeEndList() {
        return this.edgeEndList;
    }

    protected final void setEdgeEndList(@NotNull List<EdgeEnd> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.edgeEndList = list;
    }

    public PlanarGraph(@NotNull NodeFactory nodeFact) {
        Intrinsics.checkNotNullParameter((Object)nodeFact, (String)"nodeFact");
        this.edges = new ArrayList();
        this.edgeEndList = new ArrayList();
        this.nodes = new NodeMap(nodeFact);
    }

    public PlanarGraph() {
        this.edges = new ArrayList();
        this.edgeEndList = new ArrayList();
        this.nodes = new NodeMap(new NodeFactory());
    }

    @NotNull
    public final Iterator<?> getEdgeIterator() {
        return this.edges.iterator();
    }

    @NotNull
    public final Collection<?> getEdgeEnds() {
        return this.edgeEndList;
    }

    public final boolean isBoundaryNode(int geomIndex, @Nullable Coordinate coord) {
        Node node = this.nodes.find(coord);
        if (node == null) {
            return false;
        }
        Node node2 = node;
        Label label = node2.getLabel();
        return label != null && label.getLocation(geomIndex) == 1;
    }

    protected final void insertEdge(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.edges.add(e);
    }

    public final void add(@NotNull EdgeEnd e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.nodes.add(e);
        this.edgeEndList.add(e);
    }

    @NotNull
    public final Iterator<?> getNodeIterator() {
        return this.nodes.iterator();
    }

    @NotNull
    public final Collection<?> getNodes() {
        return this.nodes.values();
    }

    @NotNull
    public final Node addNode(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.nodes.addNode(node);
    }

    @NotNull
    public final Node addNode(@NotNull Coordinate coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        return this.nodes.addNode(coord);
    }

    @Nullable
    public final Node find(@Nullable Coordinate coord) {
        return this.nodes.find(coord);
    }

    public final void addEdges(@NotNull List<Edge> edgesToAdd) {
        Intrinsics.checkNotNullParameter(edgesToAdd, (String)"edgesToAdd");
        Iterator<Edge> it = edgesToAdd.iterator();
        while (it.hasNext()) {
            Edge e;
            Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            this.edges.add(e);
            DirectedEdge de1 = new DirectedEdge(e, true);
            DirectedEdge de2 = new DirectedEdge(e, false);
            de1.setSym(de2);
            de2.setSym(de1);
            this.add(de1);
            this.add(de2);
        }
    }

    public final void linkResultDirectedEdges() {
        Iterator<?> nodeit = this.nodes.iterator();
        while (nodeit.hasNext()) {
            Object obj = nodeit.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            EdgeEndStar edgeEndStar = node.getEdges();
            Intrinsics.checkNotNull((Object)edgeEndStar, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdgeStar");
            ((DirectedEdgeStar)edgeEndStar).linkResultDirectedEdges();
        }
    }

    public final void linkAllDirectedEdges() {
        Iterator<?> nodeit = this.nodes.iterator();
        while (nodeit.hasNext()) {
            Object obj = nodeit.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            EdgeEndStar edgeEndStar = node.getEdges();
            Intrinsics.checkNotNull((Object)edgeEndStar, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdgeStar");
            ((DirectedEdgeStar)edgeEndStar).linkAllDirectedEdges();
        }
    }

    @Nullable
    public final EdgeEnd findEdgeEnd(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        for (Object obj : this.getEdgeEnds()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd ee = (EdgeEnd)obj;
            if (ee.getEdge() != e) continue;
            return ee;
        }
        return null;
    }

    @Nullable
    public final Edge findEdge(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        int n = ((Collection)this.edges).size();
        for (int i = 0; i < n; ++i) {
            Edge e = this.edges.get(i);
            Coordinate[] eCoord = e.getCoordinates();
            if (!Intrinsics.areEqual((Object)p0, (Object)eCoord[0]) || !Intrinsics.areEqual((Object)p1, (Object)eCoord[1])) continue;
            return e;
        }
        return null;
    }

    @Nullable
    public final Edge findEdgeInSameDirection(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        int n = ((Collection)this.edges).size();
        for (int i = 0; i < n; ++i) {
            Edge e = this.edges.get(i);
            Coordinate[] eCoord = e.getCoordinates();
            if (this.matchInSameDirection(p0, p1, eCoord[0], eCoord[1])) {
                return e;
            }
            if (!this.matchInSameDirection(p0, p1, eCoord[eCoord.length - 1], eCoord[eCoord.length - 2])) continue;
            return e;
        }
        return null;
    }

    private final boolean matchInSameDirection(Coordinate p0, Coordinate p1, Coordinate ep0, Coordinate ep1) {
        if (!Intrinsics.areEqual((Object)p0, (Object)ep0)) {
            return false;
        }
        return Orientation.index(p0, p1, ep1) == 0 && Quadrant.INSTANCE.quadrant(p0, p1) == Quadrant.INSTANCE.quadrant(ep0, ep1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/geomgraph/PlanarGraph$Companion;", "", "<init>", "()V", "linkResultDirectedEdges", "", "nodes", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void linkResultDirectedEdges(@NotNull Collection<?> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            for (Object obj : nodes) {
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
                Node node = (Node)obj;
                EdgeEndStar edgeEndStar = node.getEdges();
                Intrinsics.checkNotNull((Object)edgeEndStar, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdgeStar");
                ((DirectedEdgeStar)edgeEndStar).linkResultDirectedEdges();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

